/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GBiomes;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GPlacedFeatures;
import org.jetbrains.annotations.NotNull;

public class GBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_CRYSTAL_CANYONS_FEATURES = GBiomeModifiers.register("add_crystal_canyons_features");
    public static final ResourceKey<BiomeModifier> ADD_CRYSTAL_CANYONS_SPAWNS = GBiomeModifiers.register("add_crystal_canyons_spawns");
    public static final ResourceKey<BiomeModifier> ADD_LICHEN_CAVES_FEATURES = GBiomeModifiers.register("add_lichen_caves_spawns");
    public static final ResourceKey<BiomeModifier> ADD_LICHEN_CAVES_SPAWNS = GBiomeModifiers.register("add_lichen_caves_features");
    public static final ResourceKey<BiomeModifier> ADD_PINK_SALT_CAVES_FEATURES = GBiomeModifiers.register("add_pink_salt_caves_features");
    public static final ResourceKey<BiomeModifier> ADD_PINK_SALT_CAVES_MODIFICATIONS = GBiomeModifiers.register("add_pink_salt_caves_modifications");
    public static final ResourceKey<BiomeModifier> ADD_SILVER_ORES = GBiomeModifiers.register("add_silver_ores");
    public static final ResourceKey<BiomeModifier> ADD_LARGE_SILVER_ORES = GBiomeModifiers.register("add_large_silver_ores");

    public static void bootstrap(BootstrapContext<BiomeModifier> bootstapContext) {
        bootstapContext.register(ADD_CRYSTAL_CANYONS_FEATURES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.CRYSTAL_CANYONS), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.ALLURITE_CEILING_CRYSTALS, GPlacedFeatures.ALLURITE_FLOOR_CRYSTALS, GPlacedFeatures.LARGE_CEILING_ALLURITE_CRYSTALS, GPlacedFeatures.LARGE_FLOOR_ALLURITE_CRYSTALS, GPlacedFeatures.LUMIERE_FLOOR_CRYSTALS, GPlacedFeatures.LUMIERE_CEILING_CRYSTALS, GPlacedFeatures.LARGE_CEILING_LUMIERE_CRYSTALS, GPlacedFeatures.LARGE_FLOOR_LUMIERE_CRYSTALS), GenerationStep.Decoration.VEGETAL_DECORATION));
        bootstapContext.register(ADD_CRYSTAL_CANYONS_SPAWNS, (Object)new BiomeModifiers.AddSpawnsBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.CRYSTAL_CANYONS), WeightedList.builder().add((Object)new MobSpawnSettings.SpawnerData(GEntityTypes.SPARKLE.get(), 4, 6), 10).add((Object)new MobSpawnSettings.SpawnerData(EntityType.GLOW_SQUID, 4, 6)).build()));
        bootstapContext.register(ADD_LICHEN_CAVES_FEATURES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.LICHEN_CAVES), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.BOWL_LICHEN, GPlacedFeatures.LICHEN_VEGETATION, GPlacedFeatures.LICHEN_CORDYCEPS_COLUMN, GPlacedFeatures.GRAVEL_PATCH), GenerationStep.Decoration.VEGETAL_DECORATION));
        bootstapContext.register(ADD_LICHEN_CAVES_SPAWNS, (Object)new BiomeModifiers.AddSpawnsBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.LICHEN_CAVES), WeightedList.builder().add((Object)new MobSpawnSettings.SpawnerData(GEntityTypes.SPECTRE.get(), 8, 8), 20).build()));
        bootstapContext.register(ADD_SILVER_ORES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, (TagKey<Biome>)BiomeTags.IS_OVERWORLD), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.ORE_SILVER_SMALL), GenerationStep.Decoration.UNDERGROUND_ORES));
        bootstapContext.register(ADD_LARGE_SILVER_ORES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.CRYSTAL_CANYONS), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.ORE_SILVER_LARGE), GenerationStep.Decoration.UNDERGROUND_ORES));
        bootstapContext.register(ADD_PINK_SALT_CAVES_FEATURES, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.PINK_SALT_CAVES), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.PINK_SALT_NOISE_CEILING_PATCH, GPlacedFeatures.PINK_SALT_NOISE_GROUND_PATCH, GPlacedFeatures.PINK_SALT_STRAW_CEILING_PATCH, GPlacedFeatures.PINK_SALT_STRAW_FLOOR_PATCH), GenerationStep.Decoration.VEGETAL_DECORATION));
        bootstapContext.register(ADD_PINK_SALT_CAVES_MODIFICATIONS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.PINK_SALT_CAVES), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.OASIS), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
    }

    @NotNull
    private static HolderSet.Direct<Biome> getBiome(BootstrapContext<BiomeModifier> bootstapContext, ResourceKey<Biome> biome) {
        return HolderSet.direct((Holder[])new Holder[]{bootstapContext.lookup(Registries.BIOME).getOrThrow(biome)});
    }

    private static HolderSet.Named<Biome> getBiome(BootstrapContext<BiomeModifier> bootstapContext, TagKey<Biome> biome) {
        return bootstapContext.lookup(Registries.BIOME).getOrThrow(biome);
    }

    @SafeVarargs
    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstrapContext<BiomeModifier> context, ResourceKey<PlacedFeature> ... placedFeature) {
        return HolderSet.direct(Stream.of(placedFeature).map(resourceKey -> context.lookup(Registries.PLACED_FEATURE).getOrThrow(resourceKey)).collect(Collectors.toList()));
    }

    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstrapContext<BiomeModifier> context, ResourceKey<PlacedFeature> placedFeature) {
        return HolderSet.direct((Holder[])new Holder[]{context.lookup(Registries.PLACED_FEATURE).getOrThrow(placedFeature)});
    }

    @NotNull
    private static ResourceKey<BiomeModifier> register(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Galosphere.id(name));
    }
}

