/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ClampedNormalInt;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseBasedCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GConfiguredFeatures;

public class GPlacedFeatures {
    public static final ResourceKey<PlacedFeature> LARGE_CEILING_ALLURITE_CRYSTALS = GPlacedFeatures.registerPlacedFeature("large_ceiling_allurite_crystals");
    public static final ResourceKey<PlacedFeature> LARGE_CEILING_LUMIERE_CRYSTALS = GPlacedFeatures.registerPlacedFeature("large_ceiling_lumiere_crystals");
    public static final ResourceKey<PlacedFeature> ALLURITE_CEILING_CRYSTALS = GPlacedFeatures.registerPlacedFeature("allurite_ceiling_crystals");
    public static final ResourceKey<PlacedFeature> LUMIERE_CEILING_CRYSTALS = GPlacedFeatures.registerPlacedFeature("lumiere_ceiling_crystals");
    public static final ResourceKey<PlacedFeature> LARGE_FLOOR_ALLURITE_CRYSTALS = GPlacedFeatures.registerPlacedFeature("large_floor_allurite_crystals");
    public static final ResourceKey<PlacedFeature> LARGE_FLOOR_LUMIERE_CRYSTALS = GPlacedFeatures.registerPlacedFeature("large_floor_lumiere_crystals");
    public static final ResourceKey<PlacedFeature> ALLURITE_FLOOR_CRYSTALS = GPlacedFeatures.registerPlacedFeature("allurite_floor_crystals");
    public static final ResourceKey<PlacedFeature> LUMIERE_FLOOR_CRYSTALS = GPlacedFeatures.registerPlacedFeature("lumiere_floor_crystals");
    public static final ResourceKey<PlacedFeature> ORE_SILVER_SMALL = GPlacedFeatures.registerPlacedFeature("ore_silver_small");
    public static final ResourceKey<PlacedFeature> BOWL_LICHEN = GPlacedFeatures.registerPlacedFeature("bowl_lichen");
    public static final ResourceKey<PlacedFeature> LICHEN_VEGETATION = GPlacedFeatures.registerPlacedFeature("lichen_caves_vegetation");
    public static final ResourceKey<PlacedFeature> GRAVEL_PATCH = GPlacedFeatures.registerPlacedFeature("gravel_patch");
    public static final ResourceKey<PlacedFeature> LICHEN_CORDYCEPS_COLUMN = GPlacedFeatures.registerPlacedFeature("lichen_cordyceps_column");
    public static final ResourceKey<PlacedFeature> ORE_SILVER_LARGE = GPlacedFeatures.registerPlacedFeature("ore_silver_large");
    public static final ResourceKey<PlacedFeature> PINK_SALT_NOISE_GROUND_PATCH = GPlacedFeatures.registerPlacedFeature("pink_salt_noise_ground_patch");
    public static final ResourceKey<PlacedFeature> PINK_SALT_NOISE_CEILING_PATCH = GPlacedFeatures.registerPlacedFeature("pink_salt_noise_ceiling_patch");
    public static final ResourceKey<PlacedFeature> PINK_SALT_STRAW_CEILING_PATCH = GPlacedFeatures.registerPlacedFeature("pink_salt_straw_ceiling_patch");
    public static final ResourceKey<PlacedFeature> PINK_SALT_STRAW_FLOOR_PATCH = GPlacedFeatures.registerPlacedFeature("pink_salt_straw_floor_patch");
    public static final ResourceKey<PlacedFeature> OASIS = GPlacedFeatures.registerPlacedFeature("oasis");
    public static final ResourceKey<PlacedFeature> BERSERKER = GPlacedFeatures.registerPlacedFeature("mobs/berserker");

    public static void bootstrap(BootstrapContext<PlacedFeature> bootstapContext) {
        HolderGetter holderGetter = bootstapContext.lookup(Registries.CONFIGURED_FEATURE);
        PlacementUtils.register(bootstapContext, LARGE_CEILING_ALLURITE_CRYSTALS, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.LARGE_ALLURITE_CRYSTAL_FLOOR), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)140, (int)180)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, LARGE_CEILING_LUMIERE_CRYSTALS, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.LARGE_LUMIERE_CRYSTAL_CEILING), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)140, (int)180)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, ALLURITE_CEILING_CRYSTALS, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.ALLURITE_CRYSTAL_CEILING), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)180, (int)200)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, LUMIERE_CEILING_CRYSTALS, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.LUMIERE_CRYSTAL_CEILING), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)180, (int)200)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, LARGE_FLOOR_ALLURITE_CRYSTALS, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.LARGE_ALLURITE_CRYSTAL_FLOOR), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)140, (int)180)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, LARGE_FLOOR_LUMIERE_CRYSTALS, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.LARGE_LUMIERE_CRYSTAL_FLOOR), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)140, (int)180)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, ALLURITE_FLOOR_CRYSTALS, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.ALLURITE_CRYSTAL_FLOOR), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)180, (int)200)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, LUMIERE_FLOOR_CRYSTALS, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.LUMIERE_CRYSTAL_FLOOR), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)180, (int)200)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, ORE_SILVER_SMALL, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.ORE_SILVER_SMALL), GPlacedFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)48))));
        PlacementUtils.register(bootstapContext, BOWL_LICHEN, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.BOWL_LICHEN), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)35), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, LICHEN_VEGETATION, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.LICHEN_PATCH), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)125), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, GRAVEL_PATCH, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.GRAVEL_PATCH), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)20), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_OR_WATER_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, LICHEN_CORDYCEPS_COLUMN, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.LICHEN_CORDYCEPS), (PlacementModifier[])new PlacementModifier[]{NoiseBasedCountPlacement.of((int)200, (double)4.0, (double)-0.12), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1)), BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, ORE_SILVER_LARGE, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.ORE_SILVER_LARGE), GPlacedFeatures.commonOrePlacement(16, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-16), (VerticalAnchor)VerticalAnchor.absolute((int)112))));
        PlacementUtils.register(bootstapContext, PINK_SALT_NOISE_GROUND_PATCH, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.PINK_SALT_GROUND_NOISE_PATCH), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)125), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, PINK_SALT_NOISE_CEILING_PATCH, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.PINK_SALT_CEILING_NOISE_PATCH), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)125), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, PINK_SALT_STRAW_CEILING_PATCH, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.PINK_SALT_STRAW_CEILING_PATCH), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)192, (int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, RandomOffsetPlacement.of((IntProvider)ClampedNormalInt.of((float)0.0f, (float)3.0f, (int)-10, (int)10), (IntProvider)ClampedNormalInt.of((float)0.0f, (float)0.6f, (int)-2, (int)2)), BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, PINK_SALT_STRAW_FLOOR_PATCH, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.PINK_SALT_STRAW_FLOOR_PATCH), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((IntProvider)UniformInt.of((int)192, (int)256)), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, RandomOffsetPlacement.of((IntProvider)ClampedNormalInt.of((float)0.0f, (float)3.0f, (int)-10, (int)10), (IntProvider)ClampedNormalInt.of((float)0.0f, (float)0.6f, (int)-2, (int)2)), BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, OASIS, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.OASIS), (PlacementModifier[])new PlacementModifier[]{CountPlacement.of((int)50), InSquarePlacement.spread(), PlacementUtils.RANGE_BOTTOM_TO_MAX_TERRAIN_HEIGHT, EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), BiomeFilter.biome()});
        PlacementUtils.register(bootstapContext, BERSERKER, (Holder)holderGetter.getOrThrow(GConfiguredFeatures.BERSERKER), (PlacementModifier[])new PlacementModifier[0]);
    }

    public static ResourceKey<PlacedFeature> registerPlacedFeature(String id) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Galosphere.id(id));
    }

    private static List<PlacementModifier> orePlacement(PlacementModifier modifier, PlacementModifier modifier2) {
        return List.of(modifier, InSquarePlacement.spread(), modifier2, BiomeFilter.biome());
    }

    private static List<PlacementModifier> commonOrePlacement(int count, PlacementModifier modifier) {
        return GPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)count), modifier);
    }
}

