/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.ClientAsset;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.entities.variants.SparkleVariant;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GRegistries;

public class GSparkleVariants {
    public static final List<ResourceKey<SparkleVariant>> VARIANTS = Lists.newArrayList();
    public static final ResourceKey<SparkleVariant> DEFAULT = GSparkleVariants.register("default");
    public static final ResourceKey<SparkleVariant> ALLURITE = GSparkleVariants.register("allurite");
    public static final ResourceKey<SparkleVariant> LUMIERE = GSparkleVariants.register("lumiere");

    public static ResourceKey<SparkleVariant> register(String name) {
        ResourceKey key = ResourceKey.create(GRegistries.SPARKLE_VARIANT, (ResourceLocation)Galosphere.id(name));
        VARIANTS.add((ResourceKey<SparkleVariant>)key);
        return key;
    }

    public static void bootstrap(BootstrapContext<SparkleVariant> bootstrapContext) {
        GSparkleVariants.register(bootstrapContext, DEFAULT, "entity/sparkle/default");
        GSparkleVariants.register(bootstrapContext, ALLURITE, "entity/sparkle/allurite", (Item)GItems.ALLURITE_SHARD.get(), ((Block)GBlocks.ALLURITE_CLUSTER.get()).asItem(), (Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get());
        GSparkleVariants.register(bootstrapContext, LUMIERE, "entity/sparkle/lumiere", (Item)GItems.LUMIERE_SHARD.get(), ((Block)GBlocks.LUMIERE_CLUSTER.get()).asItem(), (Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get());
    }

    private static void register(BootstrapContext<SparkleVariant> bootstrapContext, ResourceKey<SparkleVariant> resourceKey, String string, Item shard, Item crystal, Block glinted) {
        GSparkleVariants.register(bootstrapContext, resourceKey, string, Optional.of(shard), Optional.of(crystal), Optional.of(glinted));
    }

    private static void register(BootstrapContext<SparkleVariant> bootstrapContext, ResourceKey<SparkleVariant> resourceKey, String string) {
        GSparkleVariants.register(bootstrapContext, resourceKey, string, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static void register(BootstrapContext<SparkleVariant> bootstrapContext, ResourceKey<SparkleVariant> resourceKey, String string, Optional<Item> item, Optional<Item> crystal, Optional<Block> glinted) {
        bootstrapContext.register(resourceKey, (Object)new SparkleVariant(new ClientAsset(Galosphere.id(string)), item, crystal, glinted));
    }
}

