/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.util.quests.IndexedQuest;

public class MiningPouchItem
extends Item {
    public MiningPouchItem(Item.Properties properties) {
        super(properties);
    }

    public int getBarColor(ItemStack itemStack) {
        return super.getBarColor(itemStack);
    }

    public int getBarWidth(ItemStack itemStack) {
        return super.getBarWidth(itemStack);
    }

    public boolean overrideOtherStackedOnMe(ItemStack itemStack, ItemStack itemStack2, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction != ClickAction.PRIMARY || !slot.allowModification(player)) {
            return false;
        }
        IndexedQuest miningPouch = (IndexedQuest)itemStack.get(GDataComponents.QUESTS.get());
        if (miningPouch != null && !itemStack2.isEmpty()) {
            List<ItemStack> required = miningPouch.requests();
            for (int i = 0; i < required.size(); ++i) {
                ItemStack requiredStack = required.get(i);
                if (!requiredStack.is(itemStack2.getItem())) continue;
                int integer = requiredStack.getCount();
                int newCount = Math.max(0, integer - itemStack2.getCount());
                ItemStack copy = itemStack2.copy();
                copy.setCount(newCount);
                itemStack2.shrink(integer);
                player.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.4f);
                if (newCount == 0) {
                    if (required.size() == 1) {
                        itemStack.set(GDataComponents.QUESTS.get(), (Object)new IndexedQuest(List.of(), miningPouch.rarity()));
                        break;
                    }
                    required.remove(i);
                    break;
                }
                required.set(i, copy);
                break;
            }
            return true;
        }
        return false;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        IndexedQuest miningPouch = (IndexedQuest)itemStack.get(GDataComponents.QUESTS.get());
        if (miningPouch != null && !miningPouch.requests().isEmpty()) {
            miningPouch.requests().forEach(stack -> consumer.accept((Component)Component.translatable((String)"item.container.item_count", (Object[])new Object[]{stack.getHoverName(), stack.getCount()}).withStyle(ChatFormatting.GRAY)));
        }
    }
}

