/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class PreservedFleshItem
extends Item {
    public PreservedFleshItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        if (!(livingEntity instanceof Player)) {
            return itemStack;
        }
        Player player = (Player)livingEntity;
        itemStack.hurtAndBreak(1, livingEntity, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        FoodProperties foodProperties = (FoodProperties)itemStack.get(DataComponents.FOOD);
        if (foodProperties != null && !livingEntity.level().isClientSide) {
            player.getFoodData().eat(foodProperties);
            player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemStack);
            }
            level.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), (Holder)SoundEvents.GENERIC_EAT, SoundSource.NEUTRAL, 1.0f, 1.0f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
            livingEntity.gameEvent((Holder)GameEvent.EAT);
        }
        return itemStack;
    }
}

