/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.level.Level;
import net.orcinus.galosphere.entities.RopeDartProjectile;
import net.orcinus.galosphere.init.GAttachmentTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class RopeDartItem
extends Item {
    public RopeDartItem(Item.Properties properties) {
        super(properties);
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        return ItemUseAnimation.SPEAR;
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 72000;
    }

    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity entity, int i) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (entity.hasData(GAttachmentTypes.ROPE_DART)) {
                RopeDartProjectile dart = (RopeDartProjectile)((Object)entity.getData(GAttachmentTypes.ROPE_DART));
                player.getCooldowns().addCooldown(stack, 5);
                if (!level.isClientSide()) {
                    dart.discard();
                    player.removeData(GAttachmentTypes.ROPE_DART);
                }
                player.swing(player.getUsedItemHand());
                return true;
            }
        }
        return false;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.hasData(GAttachmentTypes.ROPE_DART)) {
            return InteractionResult.FAIL;
        }
        if (!level.isClientSide()) {
            RopeDartProjectile entity = new RopeDartProjectile(level, player);
            entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
            level.addFreshEntity((Entity)entity);
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), GSoundEvents.ROPE_DART_THROW.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        player.startUsingItem(hand);
        return InteractionResult.SUCCESS;
    }
}

