/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.entities.PinkSaltPillar;
import net.orcinus.galosphere.init.GSoundEvents;

public class SaltboundTabletItem
extends Item {
    public SaltboundTabletItem(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 18;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        player.playSound(GSoundEvents.SALTBOUND_TABLET_PREPARE_ATTACK.get(), 1.0f, 1.0f);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity user) {
        return this.performAttack(stack, level, user);
    }

    public ItemStack performAttack(ItemStack stack, Level level, LivingEntity user) {
        if (user instanceof Player) {
            int cooldown;
            Player player = (Player)user;
            InteractionHand hand = player.getUsedItemHand();
            player.swing(hand);
            player.playSound(GSoundEvents.SALTBOUND_TABLET_CAST_ATTACK.get(), 1.0f, 1.0f);
            Vec3 lookAngle = player.getLookAngle();
            Vec3 adjustedAngle = lookAngle.add(player.getX(), player.getY(), player.getZ());
            double d = Math.min(adjustedAngle.y(), player.getY());
            double e = Math.max(adjustedAngle.y(), player.getY()) + 1.0;
            float f = (float)Mth.atan2((double)(adjustedAngle.z() - player.getZ()), (double)(adjustedAngle.x() - player.getX()));
            int n = cooldown = player.getAbilities().instabuild ? 10 : 60;
            if (lookAngle.get(Direction.Axis.Y) <= -0.8) {
                for (int round = 2; round < 5; ++round) {
                    for (float index = 0.0f; index < (float)Math.PI * 2; index += 0.7853982f) {
                        this.createPillar(player, stack, (int)(index * 2.0f), 8.0f, 0.0f, player.getX() + (double)(Mth.sin((float)index) * (float)round), player.getZ() + (double)(Mth.cos((float)index) * (float)round), d, e, f);
                        player.getCooldowns().addCooldown(stack, cooldown);
                    }
                }
            } else {
                for (int index = 0; index < 16; ++index) {
                    double h = 1.25 * (double)(index + 1);
                    this.createPillar(player, stack, index, 12.0f, 0.4f, adjustedAngle.x() + (double)Mth.cos((float)f) * h + (double)((player.getRandom().nextFloat() - 0.5f) * 0.4f), adjustedAngle.z() + (double)Mth.sin((float)f) * h + (double)((player.getRandom().nextFloat() - 0.5f) * 0.4f), d, e, f);
                    player.getCooldowns().addCooldown(stack, cooldown);
                }
            }
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
        return stack;
    }

    private void createPillar(Player player, ItemStack stack, int index, float damage, float damageLowerRate, double d, double e, double f, double g, float h) {
        BlockPos pos = BlockPos.containing((double)d, (double)g, (double)e);
        Level level = player.level();
        boolean bl = false;
        double j = 0.0;
        do {
            VoxelShape voxelShape;
            BlockPos pos2;
            BlockState state;
            if (!(state = level.getBlockState(pos2 = pos.below())).isFaceSturdy((BlockGetter)level, pos2, Direction.UP)) continue;
            if (!level.isEmptyBlock(pos) && !(voxelShape = level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos)).isEmpty()) {
                j = voxelShape.max(Direction.Axis.Y);
            }
            bl = true;
            break;
        } while ((pos = pos.below()).getY() >= Mth.floor((double)f) - 7);
        if (bl) {
            if (damageLowerRate > 0.0f) {
                damage -= (float)index * damageLowerRate;
            }
            level.addFreshEntity((Entity)new PinkSaltPillar(level, d, (double)pos.getY() + j, e, h, index, damage, (LivingEntity)player, stack));
        }
    }
}

