/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.orcinus.galosphere.api.BottlePickable;
import net.orcinus.galosphere.entities.Spectre;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class SpectreBottleItem
extends Item {
    public SpectreBottleItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext useOnContext) {
        BlockPlaceContext itemPlacementContext = new BlockPlaceContext(useOnContext);
        Level world = useOnContext.getLevel();
        Player playerEntity = useOnContext.getPlayer();
        BlockPos blockPos = itemPlacementContext.getClickedPos();
        ItemStack stack = useOnContext.getItemInHand();
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (!playerEntity.getAbilities().instabuild) {
                stack.shrink(1);
            }
            if (!playerEntity.getInventory().add(new ItemStack((ItemLike)Items.GLASS_BOTTLE))) {
                playerEntity.drop(new ItemStack((ItemLike)Items.GLASS_BOTTLE), false);
            }
            if (stack.has(GDataComponents.BOTTLE_ENTITY_DATA.get())) {
                CompoundTag compoundTag = ((CustomData)stack.get(GDataComponents.BOTTLE_ENTITY_DATA.get())).copyTag();
                Entity spectre = EntityType.loadEntityRecursive((CompoundTag)compoundTag, (Level)world, (EntitySpawnReason)EntitySpawnReason.LOAD, entity -> entity);
                if (spectre != null) {
                    spectre.setPos((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5);
                    serverWorld.addWithUUID(spectre);
                    if (spectre instanceof BottlePickable) {
                        BottlePickable bottlePickable = (BottlePickable)spectre;
                        bottlePickable.setFromBottle(true);
                    }
                }
            } else {
                Spectre spectre = (Spectre)GEntityTypes.SPECTRE.get().create(world, EntitySpawnReason.BREEDING);
                spectre.setPos((double)blockPos.getX() + 0.5, blockPos.getY(), (double)blockPos.getZ() + 0.5);
                spectre.setFromBottle(true);
                Entity entity2 = spectre.getType().spawn(serverWorld, stack, null, blockPos, EntitySpawnReason.SPAWN_ITEM_USE, true, false);
                if (entity2 instanceof BottlePickable) {
                    BottlePickable bottlePickable = (BottlePickable)entity2;
                    bottlePickable.setFromBottle(true);
                }
                world.playSound(null, blockPos, GSoundEvents.SPECTRE_BOTTLE_EMPTY.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                world.gameEvent((Entity)useOnContext.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockPos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }
}

