/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items;

import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GArmorMaterials;
import net.orcinus.galosphere.init.GAttributes;

public class SterlingArmorItem
extends Item {
    public static final ResourceLocation HELMET_TEXTURE = Galosphere.id("textures/entity/equipment/helmet/sterling_helmet.png");
    private static final ArmorMaterial material = GArmorMaterials.STERLING;

    public SterlingArmorItem(ArmorType type, Item.Properties properties) {
        super(properties.durability(type.getDurability(material.durability())).attributes(SterlingArmorItem.createAttributes(type)).enchantable(material.enchantmentValue()).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)type.getSlot()).setEquipSound(material.equipSound()).setAsset(material.assetId()).build()).repairable(material.repairIngredient()));
    }

    private static ItemAttributeModifiers createAttributes(ArmorType armorType) {
        int i = material.defense().getOrDefault(armorType, 0);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup equipmentSlotGroup = EquipmentSlotGroup.bySlot((EquipmentSlot)armorType.getSlot());
        ResourceLocation resourceLocation = ResourceLocation.withDefaultNamespace((String)("armor." + armorType.getName()));
        ResourceLocation gResourceLocation = Galosphere.id("armor." + armorType.getName());
        builder.add(Attributes.ARMOR, new AttributeModifier(resourceLocation, (double)i, AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourceLocation, (double)material.toughness(), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        builder.add(GAttributes.ILLAGER_RESISTANCE, new AttributeModifier(gResourceLocation, (double)SterlingArmorItem.getIllagerResistance(armorType.getSlot()), AttributeModifier.Operation.ADD_VALUE), equipmentSlotGroup);
        return builder.build();
    }

    public static float getIllagerResistance(EquipmentSlot slot) {
        float[] array = new float[]{3.0f, 5.0f, 6.0f, 2.0f};
        return array[slot.getIndex()];
    }
}

