/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.ConsumableListener;
import net.minecraft.world.level.Level;
import net.orcinus.galosphere.init.GAttachmentTypes;

public record AirSupplyAmplifier(int airSupply, int extraAirSupply) implements ConsumableListener
{
    public static final Codec<AirSupplyAmplifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("air_supply").forGetter(AirSupplyAmplifier::airSupply), (App)Codec.INT.optionalFieldOf("extra_air_supply", (Object)0).forGetter(AirSupplyAmplifier::extraAirSupply)).apply((Applicative)instance, AirSupplyAmplifier::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AirSupplyAmplifier> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, AirSupplyAmplifier::airSupply, (StreamCodec)ByteBufCodecs.VAR_INT, AirSupplyAmplifier::extraAirSupply, AirSupplyAmplifier::new);

    public AirSupplyAmplifier(int airSupply) {
        this(airSupply, 0);
    }

    public void onConsume(Level level, LivingEntity livingEntity, ItemStack itemStack, Consumable consumable) {
        boolean flag1;
        int supply = livingEntity.getAirSupply();
        int maxSupply = livingEntity.getMaxAirSupply();
        int i = maxSupply * 3 / 4;
        boolean flag = supply < maxSupply;
        boolean bl = flag1 = supply > i;
        if (flag1) {
            livingEntity.setData(GAttachmentTypes.GOLDEN_AIR_SUPPLY.get(), (Object)this.extraAirSupply);
        }
        if (flag) {
            livingEntity.setAirSupply(Math.min(supply + this.airSupply, maxSupply));
        }
    }
}

