/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin;

import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.storage.loot.LootTable;
import net.orcinus.galosphere.api.Sifting;
import net.orcinus.galosphere.util.GEnchantmentHelper;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BrushableBlockEntity.class})
public class BrushableBlockEntityMixin
implements Sifting {
    @Shadow
    @Nullable
    private ResourceKey<LootTable> lootTable;
    @Unique
    @Nullable
    private ResourceKey<LootTable> siftingLootTable;
    @Unique
    private long siftingSeed;
    @Unique
    private boolean sifted;

    @Inject(at={@At(value="TAIL")}, method={"saveAdditional"})
    private void G$saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider, CallbackInfo ci) {
        compoundTag.putBoolean("sifted", this.sifted);
    }

    @Inject(at={@At(value="TAIL")}, method={"loadAdditional"})
    private void G$loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider, CallbackInfo ci) {
        this.sifted = compoundTag.getBooleanOr("sifted", false);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BrushableBlockEntity;unpackLootTable(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/item/ItemStack;)V")}, method={"brush"})
    private void G$brush(long l, ServerLevel serverLevel, LivingEntity livingEntity, Direction direction, ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        if (this.siftingLootTable == null) {
            this.siftingLootTable = this.lootTable;
        }
        if (this.siftingSeed == 0L) {
            this.siftingSeed = serverLevel.getRandom().nextLong();
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z")}, method={"brushingCompleted"}, cancellable=true)
    private void G$brushingCompleted(ServerLevel serverLevel, LivingEntity livingEntity, ItemStack itemStack, CallbackInfo ci) {
        BrushableBlockEntity $this = (BrushableBlockEntity)this;
        int siftingLevel = GEnchantmentHelper.getSiftingChance(serverLevel, itemStack, (Entity)livingEntity);
        float chance = (float)siftingLevel / 4.0f;
        if (!this.sifted && livingEntity.getRandom().nextFloat() < chance) {
            serverLevel.setBlock($this.getBlockPos(), $this.getBlockState().getBlock().defaultBlockState(), 3);
            BlockEntity blockEntity = serverLevel.getBlockEntity($this.getBlockPos());
            if (blockEntity instanceof BrushableBlockEntity) {
                BrushableBlockEntity brushableBlockEntity = (BrushableBlockEntity)blockEntity;
                brushableBlockEntity.brushCount = 0;
                brushableBlockEntity.hitDirection = null;
                brushableBlockEntity.brushCountResetsAtTick = 0L;
                brushableBlockEntity.coolDownEndsAtTick = 0L;
                if (brushableBlockEntity instanceof Sifting) {
                    Sifting sifting = (Sifting)brushableBlockEntity;
                    sifting.setSiftingApplied();
                }
                brushableBlockEntity.checkReset(serverLevel);
                brushableBlockEntity.setLootTable(this.siftingLootTable, this.siftingSeed);
            }
            ci.cancel();
        }
    }

    @Override
    public void setSiftingApplied() {
        this.sifted = true;
    }
}

