/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.entities.GlowFlare;
import net.orcinus.galosphere.entities.SpectreFlare;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.mixin.ProjectileWeaponItemAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    @Inject(at={@At(value="HEAD")}, method={"createProjectile"}, cancellable=true)
    private void G$createProjectile(Level level, LivingEntity livingEntity, ItemStack itemStack, ItemStack itemStack2, boolean bl, CallbackInfoReturnable<Projectile> cir) {
        if (itemStack2.is((Item)GItems.GLOW_FLARE.get())) {
            cir.setReturnValue((Object)new GlowFlare(level, itemStack2, (Entity)livingEntity, livingEntity.getX(), livingEntity.getEyeY() - (double)0.15f, livingEntity.getZ(), true));
        } else if (itemStack2.is((Item)GItems.SPECTRE_FLARE.get())) {
            cir.setReturnValue((Object)new SpectreFlare(level, itemStack2, (Entity)livingEntity, livingEntity.getX(), livingEntity.getEyeY() - (double)0.15f, livingEntity.getZ(), true));
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;", shift=At.Shift.AFTER)}, method={"tryLoadProjectiles"})
    private static void G$tryLoadProjectiles(LivingEntity shooter, ItemStack crossbowStack, CallbackInfoReturnable<Boolean> cir) {
        ItemStack first;
        List<ItemStack> list = ProjectileWeaponItemAccessor.callDraw(crossbowStack, shooter.getProjectile(crossbowStack), shooter);
        if (!list.isEmpty() && ((first = list.getFirst()).is(GItems.GLOW_FLARE) || first.is(GItems.SPECTRE_FLARE))) {
            String name = "crossbow_" + BuiltInRegistries.ITEM.getKey((Object)first.getItem()).getPath();
            crossbowStack.set(DataComponents.ITEM_MODEL, (Object)Galosphere.id(name));
        }
    }
}

