/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.network;

import java.util.Optional;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.orcinus.galosphere.client.gui.GoldenBreathOverlay;
import net.orcinus.galosphere.events.ClientEvents;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.network.ClientboundBoostPlayerPacket;
import net.orcinus.galosphere.network.PlayCooldownSoundPacket;
import net.orcinus.galosphere.network.SendOpalParticlePacket;
import net.orcinus.galosphere.network.SendParticlesPacket;
import net.orcinus.galosphere.network.SendPerspectivePacket;
import net.orcinus.galosphere.network.UpdateGoldenAirPacket;
import net.orcinus.galosphere.network.UpdateSpectreBoundPacket;

public class ClientEventsHandler {
    public static void handleSendParticles(SendParticlesPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            Optional.of(ctx.player().level()).ifPresent(world -> {
                RandomSource randomsource = world.getRandom();
                world.playLocalSound(packet.blockPos(), GSoundEvents.GLOW_FLARE_SPREAD.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
                boolean flag = world.getBlockState(packet.blockPos()).isCollisionShapeFullBlock((BlockGetter)world, packet.blockPos());
                int l2 = flag ? 40 : 20;
                float f9 = flag ? 0.45f : 0.25f;
                for (int count = 0; count < l2; ++count) {
                    float x = 2.0f * randomsource.nextFloat() - 1.0f;
                    float y = 2.0f * randomsource.nextFloat() - 1.0f;
                    float z = 2.0f * randomsource.nextFloat() - 1.0f;
                    world.addParticle((ParticleOptions)ParticleTypes.GLOW, (double)packet.blockPos().getX() + 0.5 + (double)(x * f9), (double)packet.blockPos().getY() + 0.5 + (double)(y * f9), (double)packet.blockPos().getZ() + 0.5 + (double)(z * f9), (double)(x * 0.07f), (double)(y * 0.07f), (double)(z * 0.07f));
                }
                world.playLocalSound(packet.blockPos(), GSoundEvents.GLOW_FLARE_SPREAD.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
            });
        }).exceptionally(e -> null);
    }

    public static void updateGoldenAir(UpdateGoldenAirPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            GoldenBreathOverlay.airSupply = packet.supply();
        });
    }

    public static void updateSpectreBound(UpdateSpectreBoundPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Minecraft instance = Minecraft.getInstance();
            if (!packet.using()) {
                instance.setCameraEntity((Entity)ctx.player());
            }
            ClientEvents.usingSpectreBoundSpyglass = packet.using();
        }).exceptionally(e -> null);
    }

    public static void sendPerspective(SendPerspectivePacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Minecraft client = Minecraft.getInstance();
            Optional.ofNullable(client.level).flatMap(world -> Optional.ofNullable(world.getPlayerByUUID(packet.uuid())).filter(player -> player.equals((Object)client.player)).flatMap(player -> Optional.ofNullable(client.level.getEntity(packet.id())))).ifPresent(entity -> {
                client.setCameraEntity(entity);
                if (!client.options.getCameraType().isFirstPerson()) {
                    client.options.setCameraType(CameraType.FIRST_PERSON);
                }
            });
        }).exceptionally(e -> null);
    }

    public static void playCooldownSound(PlayCooldownSoundPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> ctx.player().playSound(GSoundEvents.SALTBOUND_TABLET_COOLDOWN_OVER.get(), 1.0f, 1.0f)).exceptionally(e -> null);
    }

    public static void boostPlayer(ClientboundBoostPlayerPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            player.setDeltaMovement(player.getDeltaMovement().scale(packet.power()).add(player.getLookAngle().scale(0.3)));
        }).exceptionally(e -> null);
    }

    public static void handleOpalParticles(SendOpalParticlePacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockPos blockPos;
            Level world = ctx.player().level();
            Block patt0$temp = world.getBlockState(blockPos = packet.blockPos()).getBlock();
            if (patt0$temp instanceof BonemealableBlock) {
                BonemealableBlock bonemealableBlock = (BonemealableBlock)patt0$temp;
                BlockPos blockPos2 = bonemealableBlock.getParticlePos(blockPos);
                ParticleUtils.spawnParticleInBlock((LevelAccessor)world, (BlockPos)blockPos2, (int)15, (ParticleOptions)((ParticleOptions)GParticleTypes.OPAL_GLINT.get()));
                world.playLocalSound(blockPos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
        }).exceptionally(e -> null);
    }
}

