/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.util;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.neoforged.neoforge.common.Tags;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.items.components.EchobellTracker;

public class HandbellManager {
    public static boolean shouldResonate(Player player) {
        int time = (int)player.level().getGameTime();
        Predicate<ItemStack> predicate = itemStack -> {
            EchobellTracker minersBell = (EchobellTracker)itemStack.get(GDataComponents.ECHO_BELL_TRACKER.get());
            return itemStack.is((Item)GItems.ECHO_BELL.get()) && minersBell != null && minersBell.shouldActivate();
        };
        return player.getInventory().contains(predicate);
    }

    public static void resonance(ServerLevel serverLevel, Player player, RandomSource random, int xzRange, int yRange, int particleRange) {
        HandbellManager.handbellTick(player);
        HandbellManager.handleOreResonance(serverLevel, player, random, xzRange, yRange, particleRange);
    }

    private static void handleOreResonance(ServerLevel serverLevel, Player player, RandomSource random, int xzRange, int yRange, int particleRange) {
        for (BlockPos blockPos : BlockPos.withinManhattan((BlockPos)player.blockPosition(), (int)xzRange, (int)yRange, (int)xzRange)) {
            boolean flag = HandbellManager.validTarget(player, serverLevel, blockPos) && random.nextFloat() < 0.07f;
            if (!flag) continue;
            BlockPos pos2 = blockPos.offset(Mth.randomBetweenInclusive((RandomSource)random, (int)(-particleRange), (int)particleRange), Mth.randomBetweenInclusive((RandomSource)random, (int)(-particleRange), (int)particleRange), Mth.randomBetweenInclusive((RandomSource)random, (int)(-particleRange), (int)particleRange));
            int count = UniformInt.of((int)3, (int)6).sample(random);
            HandbellManager.spawnParticles(serverLevel, blockPos, count, pos2);
        }
    }

    private static void handbellTick(Player player) {
        for (ItemStack itemStack : player.getInventory().getNonEquipmentItems()) {
            EchobellTracker handbellTracker;
            if (!itemStack.is((Item)GItems.ECHO_BELL.get()) || (handbellTracker = (EchobellTracker)itemStack.get(GDataComponents.ECHO_BELL_TRACKER.get())) == null || handbellTracker.ticks() >= (int)player.level().getGameTime()) continue;
            player.level().playSound(null, player.blockPosition(), SoundEvents.CONDUIT_DEACTIVATE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            itemStack.set(GDataComponents.ECHO_BELL_TRACKER.get(), (Object)new EchobellTracker(handbellTracker.fuel() - 1, false, 1200));
        }
    }

    private static boolean validTarget(Player player, ServerLevel serverLevel, BlockPos blockPos) {
        BlockState state = serverLevel.getBlockState(blockPos);
        if (state.is(Tags.Blocks.ORES) && !state.is(GBlockTags.MINER_BELL_NON_DETECTABLES)) {
            Optional<Direction> optional = Arrays.stream(Direction.values()).filter(direction -> serverLevel.isStateAtPosition(blockPos.relative(direction), DripstoneUtils::isEmptyOrWaterOrLava)).findAny();
            double distance = player.blockPosition().distManhattan((Vec3i)blockPos);
            if (distance < 6.0) {
                return optional.isEmpty();
            }
            return true;
        }
        return false;
    }

    private static void spawnParticles(ServerLevel serverLevel, BlockPos blockPos, int count, BlockPos pos2) {
        for (int i = 0; i < count; ++i) {
            if (serverLevel.getBlockState(pos2).isCollisionShapeFullBlock((BlockGetter)serverLevel, pos2)) continue;
            float velX = 0.06f * (float)(blockPos.getX() - pos2.getX());
            float velY = 0.06f * (float)(blockPos.getY() - pos2.getY());
            float velZ = 0.06f * (float)(blockPos.getZ() - pos2.getZ());
            serverLevel.sendParticles((ParticleOptions)GParticleTypes.ECHO_TRAIL.get(), (double)((float)pos2.getX() + 0.5f), (double)pos2.getY(), (double)((float)pos2.getZ() + 0.5f), 0, (double)velX, (double)velY, (double)velZ, 1.0);
        }
        if (serverLevel.getRandom().nextFloat() < 0.01f) {
            serverLevel.playSound(null, blockPos, SoundEvents.AMETHYST_BLOCK_RESONATE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

