/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypes;

public class BerserkerFeature
extends Feature<NoneFeatureConfiguration> {
    public BerserkerFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        BlockPos pos = featurePlaceContext.origin();
        WorldGenLevel world = featurePlaceContext.level();
        Berserker berserker = (Berserker)GEntityTypes.BERSERKER.get().create((Level)world.getLevel(), EntitySpawnReason.STRUCTURE);
        berserker.setPersistenceRequired();
        berserker.snapTo((double)pos.getX() + 0.5, pos.getY(), (double)pos.getZ() + 0.5);
        BlockState directionalState = world.getBlockState(pos.below(2));
        int rot = 180;
        if (directionalState.is(Blocks.MAGENTA_GLAZED_TERRACOTTA)) {
            Direction direction = (Direction)directionalState.getValue((Property)HorizontalDirectionalBlock.FACING);
            if (direction == Direction.EAST) {
                rot = 90;
            } else if (direction == Direction.NORTH) {
                rot = 0;
            } else if (direction == Direction.WEST) {
                rot = 270;
            }
            berserker.setYRot(rot);
            world.setBlock(pos.below(2), ((Block)GBlocks.PINK_SALT_BRICKS.get()).defaultBlockState(), 2);
        }
        berserker.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(pos), EntitySpawnReason.STRUCTURE, null);
        world.addFreshEntityWithPassengers((Entity)berserker);
        return true;
    }
}

