/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.features;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.world.gen.FastNoise;
import net.orcinus.galosphere.world.gen.PinkSaltUtil;

public class OasisFeature
extends Feature<NoneFeatureConfiguration> {
    public OasisFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        BlockPos blockPos = featurePlaceContext.origin();
        RandomSource random = featurePlaceContext.random();
        int worldSeed = (int)world.getSeed();
        FastNoise fastNoise = new FastNoise(worldSeed);
        fastNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
        fastNoise.SetFrequency(0.8f);
        FastNoise ceilingNoise = new FastNoise(worldSeed);
        ceilingNoise.SetNoiseType(FastNoise.NoiseType.Simplex);
        ceilingNoise.SetFrequency(0.3f);
        ceilingNoise.SetFractalOctaves(3);
        int xRadius = this.getRandomRadius(random) / 2;
        int yRadius = UniformInt.of((int)15, (int)20).sample(random);
        int zRadius = this.getRandomRadius(random) / 2;
        ArrayList positions = Lists.newArrayList();
        for (int x = -xRadius; x <= xRadius; ++x) {
            for (int z = -zRadius; z <= zRadius; ++z) {
                for (int y = -yRadius; y <= 0; ++y) {
                    boolean flag;
                    BlockPos pos = new BlockPos(blockPos.getX() + x, blockPos.getY() + y, blockPos.getZ() + z);
                    StructureManager structureManager = featurePlaceContext.level().getLevel().structureManager();
                    Structure structure = (Structure)structureManager.registryAccess().lookupOrThrow(Registries.STRUCTURE).getValue(Galosphere.id("pink_salt_shrine"));
                    boolean bl = flag = structure != null && structureManager.getStructureAt(blockPos, structure).isValid();
                    if (flag) {
                        return false;
                    }
                    double xSquared = x * x;
                    double ySquared = y * y;
                    double zSquared = z * z;
                    double threshold = 1.0f + 3.0f * fastNoise.GetNoise(blockPos.getX() + x, blockPos.getY() + y, blockPos.getZ() + z);
                    if (!(xSquared / (double)(xRadius * 2) + ySquared / (double)(yRadius * 2) + zSquared / (double)(zRadius * 2) < threshold) || !(xSquared + ySquared + zSquared <= (double)(xRadius * zRadius)) || y >= 0) continue;
                    positions.add(pos);
                }
            }
        }
        int waterLevel = blockPos.getY() - 1;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (BlockPos position : positions) {
            BlockPos.MutableBlockPos mutable3 = mutableBlockPos.set(position.getX(), Math.min(position.getY(), waterLevel), position.getZ());
            for (int i = mutable3.getY(); i <= waterLevel; ++i) {
                this.generateMiniAquifer(world, (BlockPos)mutable3);
                mutable3.move(Direction.UP);
            }
        }
        return true;
    }

    private int getRandomRadius(RandomSource random) {
        return UniformInt.of((int)15, (int)21).sample(random);
    }

    private void generateMiniAquifer(WorldGenLevel world, BlockPos mutable2) {
        if (world.getBlockState(mutable2.above()).isAir()) {
            world.setBlock(mutable2, Blocks.WATER.defaultBlockState(), 2);
            world.scheduleTick(mutable2, (Fluid)Fluids.WATER, 0);
        }
        BlockPos.MutableBlockPos mutable3 = new BlockPos.MutableBlockPos();
        for (Direction value : Direction.values()) {
            if (value == Direction.UP) continue;
            mutable3.setWithOffset((Vec3i)mutable2, value);
            if (world.getBlockState((BlockPos)mutable3).is(Blocks.WATER)) continue;
            world.setBlock((BlockPos)mutable3, PinkSaltUtil.getBlock(world.getSeed(), mutable3).defaultBlockState(), 2);
        }
    }
}

