/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.foliage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.orcinus.galosphere.init.GFoliagePlacerTypes;

public class OpalFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<OpalFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)IntProvider.codec((int)0, (int)16).fieldOf("radius").forGetter(foliagePlacer -> foliagePlacer.radius), (App)IntProvider.codec((int)0, (int)16).fieldOf("offset").forGetter(foliagePlacer -> foliagePlacer.offset), (App)IntProvider.codec((int)0, (int)16).fieldOf("hanging_leaves_length").forGetter(foliagePlacer -> foliagePlacer.hangingLeavesLength)).apply((Applicative)instance, OpalFoliagePlacer::new));
    private final IntProvider hangingLeavesLength;

    public OpalFoliagePlacer(IntProvider intProvider, IntProvider intProvider2, IntProvider hangingLeavesLength) {
        super(intProvider, intProvider2);
        this.hangingLeavesLength = hangingLeavesLength;
    }

    protected FoliagePlacerType<?> type() {
        return GFoliagePlacerTypes.OPAL_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, int i, FoliagePlacer.FoliageAttachment foliageAttachment, int j, int k, int l) {
        BlockPos blockPos = foliageAttachment.pos();
        this.placeLeavesRow(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockPos.above(), k + foliageAttachment.radiusOffset(), 0, false);
        this.placeLeavesRow(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockPos.above(), k + foliageAttachment.radiusOffset(), -1, false);
        for (int x = -k; x <= k; ++x) {
            for (int z = -k; z <= k; ++z) {
                int randomLength = UniformInt.of((int)2, (int)6).sample(randomSource);
                for (int length = 0; length < randomLength; ++length) {
                    if (length == 1 && x != 0 && z != 0) continue;
                    BlockPos leavesPos = BlockPos.containing((double)(blockPos.getX() + x), (double)(blockPos.getY() - length), (double)(blockPos.getZ() + z));
                    OpalFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)leavesPos);
                }
            }
        }
    }

    public int foliageHeight(RandomSource randomSource, int i, TreeConfiguration treeConfiguration) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource randomSource, int i, int j, int k, int l, boolean bl) {
        return j == 0 & i == l && k == l;
    }
}

