/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.processors.decorations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.orcinus.galosphere.init.GStructureProcessorTypes;
import org.jetbrains.annotations.Nullable;

public class ChiseledBookshelfProcessor
extends StructureProcessor {
    public static final MapCodec<ChiseledBookshelfProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("book_chance").forGetter(processor -> Float.valueOf(processor.book_chance)), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("enchanted_chance").forGetter(processor -> Float.valueOf(processor.enchanted_chance)), (App)TagKey.hashedCodec((ResourceKey)Registries.ENCHANTMENT).optionalFieldOf("enchantments").forGetter(processor -> processor.enchantments)).apply((Applicative)instance, ChiseledBookshelfProcessor::new));
    private final float book_chance;
    private final float enchanted_chance;
    private final Optional<TagKey<Enchantment>> enchantments;

    public ChiseledBookshelfProcessor(float book_chance, float enchanted_chance, Optional<TagKey<Enchantment>> enchantments) {
        this.book_chance = book_chance;
        this.enchanted_chance = enchanted_chance;
        this.enchantments = enchantments;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlaceSettings) {
        BlockState state = structureBlockInfo2.state();
        BlockPos pos = structureBlockInfo2.pos();
        RandomSource randomSource = structurePlaceSettings.getRandom(pos);
        if (state.is(Blocks.CHISELED_BOOKSHELF)) {
            if (randomSource.nextFloat() >= this.book_chance) {
                return new StructureTemplate.StructureBlockInfo(pos, Blocks.BOOKSHELF.defaultBlockState(), structureBlockInfo2.nbt());
            }
            int max = 6;
            NonNullList items = NonNullList.withSize((int)max, (Object)ItemStack.EMPTY);
            RegistryAccess registryAccess = levelReader.registryAccess();
            Registry enchantments = registryAccess.lookupOrThrow(Registries.ENCHANTMENT);
            for (int i = 0; i < max; ++i) {
                if (!randomSource.nextBoolean()) continue;
                state = (BlockState)state.setValue((Property)ChiseledBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(i), (Comparable)Boolean.valueOf(true));
                ItemStack book = new ItemStack((ItemLike)Items.BOOK);
                if (randomSource.nextFloat() < this.enchanted_chance && this.enchantments.isPresent()) {
                    book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                    Optional optional = enchantments.get(this.enchantments.get());
                    if (optional.isPresent()) {
                        HolderSet.Named holders = (HolderSet.Named)optional.get();
                        Holder holder = holders.get(randomSource.nextInt(holders.size()));
                        Enchantment value = (Enchantment)holder.value();
                        int level = Mth.nextInt((RandomSource)randomSource, (int)value.getMinLevel(), (int)((Enchantment)holder.value()).getMaxLevel());
                        book.enchant(holder, level);
                    }
                }
                items.set(i, (Object)book);
            }
            CompoundTag tag = new CompoundTag();
            ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)registryAccess);
            return new StructureTemplate.StructureBlockInfo(structureBlockInfo2.pos(), state, tag);
        }
        return structureBlockInfo2;
    }

    protected StructureProcessorType<?> getType() {
        return GStructureProcessorTypes.CHISELED_BOOKSHELF.get();
    }
}

