/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.processors.decorations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.orcinus.galosphere.init.GStructureProcessorTypes;
import org.jetbrains.annotations.Nullable;

public class MultipleCandleProcessor
extends StructureProcessor {
    public static final MapCodec<MultipleCandleProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("lit_chance").forGetter(processor -> Float.valueOf(processor.lit_chance))).apply((Applicative)instance, MultipleCandleProcessor::new));
    private final float lit_chance;

    public MultipleCandleProcessor(float lit_chance) {
        this.lit_chance = lit_chance;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlaceSettings) {
        BlockState state = structureBlockInfo2.state();
        BlockPos position = structureBlockInfo2.pos();
        RandomSource randomSource = structurePlaceSettings.getRandom(position);
        if (state.getBlock() instanceof CandleBlock) {
            if (randomSource.nextFloat() < this.lit_chance) {
                state = (BlockState)state.setValue((Property)CandleBlock.LIT, (Comparable)Boolean.valueOf(true));
            }
            return new StructureTemplate.StructureBlockInfo(position, (BlockState)state.setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)randomSource, (int)1, (int)4))), structureBlockInfo2.nbt());
        }
        return structureBlockInfo2;
    }

    protected StructureProcessorType<?> getType() {
        return GStructureProcessorTypes.MULTIPLE_CANDLES.get();
    }
}

