/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen.processors.pink_salt_shrine;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.orcinus.galosphere.blocks.PinkSaltStrawBlock;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GStructureProcessorTypes;
import org.jetbrains.annotations.Nullable;

public class MainRoomProcessor
extends StructureProcessor {
    public static final MapCodec<MainRoomProcessor> CODEC = MapCodec.unit(MainRoomProcessor::new);

    @Nullable
    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos blockPos, BlockPos blockPos2, StructureTemplate.StructureBlockInfo structureBlockInfo, StructureTemplate.StructureBlockInfo structureBlockInfo2, StructurePlaceSettings structurePlaceSettings) {
        BlockState state = structureBlockInfo2.state();
        BlockPos position = structureBlockInfo2.pos();
        RandomSource randomSource = structurePlaceSettings.getRandom(position);
        if (state.getBlock() instanceof CandleBlock) {
            return new StructureTemplate.StructureBlockInfo(position, (BlockState)state.setValue((Property)CandleBlock.CANDLES, (Comparable)Integer.valueOf(Mth.nextInt((RandomSource)randomSource, (int)1, (int)4))), structureBlockInfo2.nbt());
        }
        if (state.is((Block)GBlocks.PINK_SALT_STRAW.get())) {
            BlockPos.MutableBlockPos mutableBlockPos = position.mutable();
            Direction direction = (Direction)state.getValue(PinkSaltStrawBlock.TIP_DIRECTION);
            int height = UniformInt.of((int)2, (int)4).sample(randomSource);
            for (int i = 0; i <= height; ++i) {
                if (levelReader.isEmptyBlock((BlockPos)mutableBlockPos) || levelReader.getBlockState((BlockPos)mutableBlockPos).is((Block)GBlocks.PINK_SALT_STRAW.get())) {
                    boolean emptyBlock;
                    boolean bl = emptyBlock = levelReader.isEmptyBlock(mutableBlockPos.relative(direction)) || levelReader.getBlockState(mutableBlockPos.relative(direction)).is((Block)GBlocks.PINK_SALT_STRAW.get());
                    if (i == height || !emptyBlock) {
                        levelReader.getChunk((BlockPos)mutableBlockPos).setBlockState((BlockPos)mutableBlockPos, (BlockState)((BlockState)((Block)GBlocks.PINK_SALT_STRAW.get()).defaultBlockState().setValue(PinkSaltStrawBlock.TIP_DIRECTION, (Comparable)direction)).setValue(PinkSaltStrawBlock.STRAW_SHAPE, (Comparable)((Object)PinkSaltStrawBlock.StrawShape.TOP)), 3);
                        break;
                    }
                    PinkSaltStrawBlock.StrawShape strawShape = i == 0 ? PinkSaltStrawBlock.StrawShape.BOTTOM : PinkSaltStrawBlock.StrawShape.MIDDLE;
                    levelReader.getChunk((BlockPos)mutableBlockPos).setBlockState((BlockPos)mutableBlockPos, (BlockState)((BlockState)((Block)GBlocks.PINK_SALT_STRAW.get()).defaultBlockState().setValue(PinkSaltStrawBlock.TIP_DIRECTION, (Comparable)direction)).setValue(PinkSaltStrawBlock.STRAW_SHAPE, (Comparable)((Object)strawShape)), 3);
                }
                mutableBlockPos.move(direction);
            }
        }
        if (state.is(Blocks.CHAIN)) {
            BlockPos pos;
            int height = UniformInt.of((int)1, (int)3).sample(randomSource);
            for (int i = 1; i <= height && levelReader.getBlockState(pos = position.below(i)).isAir(); ++i) {
                levelReader.getChunk(pos).setBlockState(pos, Blocks.CHAIN.defaultBlockState(), 3);
            }
        }
        return structureBlockInfo2;
    }

    protected StructureProcessorType<?> getType() {
        return GStructureProcessorTypes.PINK_SALT_MAIN_ROOM.get();
    }
}

