/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks.blockentities;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5712;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import net.orcinus.galosphere.blocks.MoleBurrowBlock;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.items.components.MoleData;
import net.orcinus.galosphere.util.quests.MiningPouchManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class MoleBurrowBlockEntity
extends class_2586 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private class_9279 data = class_9279.field_49302;
    private final class_6019 RANDOM_DURATION = class_6019.method_35017((int)600, (int)1200);
    @Nullable
    private class_1814 rarity = null;
    private int ticks = -1;
    private int maxTicks = 0;
    private int pauseTicks = 0;
    private int spawnCount = 0;

    public MoleBurrowBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(GBlockEntityTypes.MOLE_BURROW, blockPos, blockState);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.ticks = compoundTag.method_10550("Ticks");
        this.maxTicks = compoundTag.method_10550("MaxTicks");
        this.pauseTicks = compoundTag.method_10550("PauseTicks");
        this.spawnCount = compoundTag.method_10550("SpawnCount");
        class_9279.field_49303.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10580("Mole")).resultOrPartial(string -> LOGGER.error("Failed to parse mole: '{}'", string)).ifPresent(customData -> {
            this.data = customData;
        });
        if (compoundTag.method_10580("Rarity") != null) {
            class_1814.field_50001.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10580("Rarity")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setRarity);
        }
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_10569("Ticks", this.ticks);
        compoundTag.method_10569("MaxTicks", this.maxTicks);
        compoundTag.method_10569("PauseTicks", this.pauseTicks);
        compoundTag.method_10569("SpawnCount", this.spawnCount);
        compoundTag.method_10566("Mole", (class_2520)class_9279.field_49303.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.data).getOrThrow());
        if (this.rarity != null) {
            compoundTag.method_10566("Rarity", (class_2520)class_1814.field_50001.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.getRarity()).getOrThrow());
        }
    }

    public void setRarity(class_1814 rarity) {
        this.rarity = rarity;
    }

    @Nullable
    public class_1814 getRarity() {
        return this.rarity;
    }

    public static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, MoleBurrowBlockEntity entity) {
        MoleBurrowBlockEntity.tickMole(level, blockPos, blockState, entity);
        MoleBurrowBlockEntity.generateRewards(level, blockPos, entity);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void generateRewards(class_1937 level, class_2338 blockPos, MoleBurrowBlockEntity entity) {
        class_1814 rarity = entity.getRarity();
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (rarity != null && entity.spawnCount < 3) {
                class_1799 itemStack = (class_1799)MiningPouchManager.getPouchRewards(serverLevel, blockPos, rarity).get(0);
                if (entity.pauseTicks > 0) {
                    --entity.pauseTicks;
                    return;
                }
                class_2347.method_10134((class_1937)level, (class_1799)itemStack, (int)2, (class_2350)class_2350.field_11036, (class_2374)class_243.method_24955((class_2382)blockPos).method_43206(class_2350.field_11036, 1.2));
                level.method_8396(null, blockPos, class_3417.field_14627, class_3419.field_15245, 1.0f, 1.0f);
                serverLevel.method_14199((class_2394)class_2398.field_46763, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 1.0, (double)blockPos.method_10260() + 0.5, 15, 0.0, 0.0, 0.0, 0.0);
                entity.pauseTicks = 20;
                ++entity.spawnCount;
                return;
            }
        }
        entity.rarity = null;
        entity.spawnCount = 0;
    }

    private static void tickMole(class_1937 level, class_2338 blockPos, class_2680 blockState, MoleBurrowBlockEntity entity) {
        if (!entity.isEmpty()) {
            if (entity.ticks < entity.maxTicks) {
                ++entity.ticks;
                if (level.method_8409().method_43058() < 0.005) {
                    level.method_43128(null, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264(), (double)blockPos.method_10260() + 0.5, class_3417.field_20612, class_3419.field_15245, 1.0f, 1.0f);
                }
            } else {
                MoleBurrowBlockEntity.releaseMole(level, blockPos, entity, entity.data.method_57461(), MoleReleaseStatus.MOLE_RELEASED);
                MoleBurrowBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)blockState);
            }
        }
    }

    private static boolean releaseMole(class_1937 level, class_2338 blockPos, MoleBurrowBlockEntity blockEntity, class_2487 compoundTag, MoleReleaseStatus moleReleaseStatus) {
        boolean bl;
        class_2338 blockPos3 = blockPos.method_10084();
        boolean bl2 = bl = !level.method_8320(blockPos3).method_26220((class_1922)level, blockPos3).method_1110();
        if (bl && moleReleaseStatus != MoleReleaseStatus.EMERGENCY) {
            return false;
        }
        if (compoundTag.method_33133()) {
            blockEntity.data = class_9279.field_49302;
            return false;
        }
        class_1297 entity = class_1299.method_17842((class_2487)compoundTag, (class_1937)level, e -> e);
        if (entity != null) {
            level.method_43276((class_6880)class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)level.method_8320(blockPos)));
            if (entity instanceof Mole) {
                Mole mole = (Mole)entity;
                double e2 = (double)blockPos.method_10263() + 0.5;
                double g = (double)blockPos.method_10264() + 1.0;
                double h = (double)blockPos.method_10260() + 0.5;
                mole.method_5808(e2, g, h, mole.method_36454(), mole.method_36455());
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    mole.method_5864().method_5894(serverLevel, null, null, blockPos, class_3730.field_16461, true, false);
                }
                blockEntity.ticks = -1;
                blockEntity.maxTicks = -1;
                blockEntity.data = class_9279.field_49302;
            }
            return true;
        }
        return false;
    }

    public void releaseAllOccupants(class_2680 blockState, MoleReleaseStatus moleReleaseStatus) {
        if (this.isEmpty()) {
            return;
        }
        MoleBurrowBlockEntity.releaseMole(this.field_11863, this.field_11867, this, this.data.method_57461(), moleReleaseStatus);
        super.method_5431();
    }

    public void addMole(class_1297 entity) {
        this.addMole(entity, true);
    }

    public void addMole(class_1297 entity, boolean pouch) {
        if (!this.isEmpty()) {
            return;
        }
        entity.method_5848();
        entity.method_5772();
        this.storeMole(entity, pouch);
        entity.method_31472();
        super.method_5431();
    }

    private void storeMole(class_1297 entity, boolean pouch) {
        class_2487 compoundTag = new class_2487();
        entity.method_5662(compoundTag);
        if (this.field_11863 != null) {
            class_2338 blockPos = this.method_11016();
            class_2680 state = this.method_11010();
            int pouches = pouch ? Math.min(3, (Integer)state.method_11654((class_2769)MoleBurrowBlock.POUCHES) + 1) : 0;
            this.field_11863.method_8501(blockPos, (class_2680)state.method_11657((class_2769)MoleBurrowBlock.POUCHES, (Comparable)Integer.valueOf(pouches)));
            this.field_11863.method_43128(null, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), class_3417.field_20609, class_3419.field_15245, 1.0f, 1.0f);
            this.field_11863.method_43276((class_6880)class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)this.method_11010()));
        }
        this.data = class_9279.method_57456((class_2487)compoundTag);
        this.ticks = 0;
        this.maxTicks = this.RANDOM_DURATION.method_35008(entity.method_59922());
    }

    public boolean isEmpty() {
        return this.data == class_9279.field_49302;
    }

    protected void method_57568(class_2586.class_9473 dataComponentInput) {
        super.method_57568(dataComponentInput);
        this.data = ((MoleData)dataComponentInput.method_58695(GDataComponents.MOLE, (Object)MoleData.EMPTY)).moleData();
    }

    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(GDataComponents.MOLE, (Object)new MoleData(this.data));
    }

    public void method_57569(class_2487 compoundTag) {
        super.method_57569(compoundTag);
        compoundTag.method_10551("Mole");
    }

    public static enum MoleReleaseStatus {
        ITEM_DELIVERED,
        MOLE_RELEASED,
        EMERGENCY;

    }
}

