/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1421;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.server.MinecraftServer;
import net.orcinus.galosphere.api.Spectatable;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class SpectatorVision
extends class_1421
implements Spectatable {
    private static final class_2940<Optional<UUID>> MANIPULATOR = class_2945.method_12791(SpectatorVision.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Integer> PHASE = class_2945.method_12791(SpectatorVision.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SPECTATING_TICKS = class_2945.method_12791(SpectatorVision.class, (class_2941)class_2943.field_13327);

    public SpectatorVision(class_1937 level) {
        super(GEntityTypes.SPECTATOR_VISION, level);
    }

    public SpectatorVision(class_1299<? extends class_1421> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23720, (double)0.1f).method_26868(class_5134.field_23719, (double)0.1f);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MANIPULATOR, Optional.empty());
        builder.method_56912(PHASE, (Object)0);
        builder.method_56912(SPECTATING_TICKS, (Object)0);
    }

    public boolean method_5679(class_1282 damageSource) {
        return true;
    }

    public void method_6007() {
        super.method_6007();
        if (this.getManipulatorUUID() == null) {
            this.method_31472();
        }
        if (!this.method_37908().method_8608() || this.matchesClientPlayerUUID()) {
            ((Optional)this.field_6011.method_12789(MANIPULATOR)).ifPresent(this::spectateTick);
        }
        if (!this.method_37908().field_9236) {
            int spectatableTime = this.getSpectatableTime();
            if (spectatableTime > 0) {
                this.setSpectatableTime(spectatableTime - 1);
            }
            if (this.getPhase() < 12 && this.field_6012 % 5 == 0) {
                this.setPhase(this.getPhase() + 1);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236 && this.field_5974.method_43048(5) == 0) {
            int count = class_6019.method_35017((int)3, (int)6).method_35008(this.field_5974);
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            class_2338 blockPos = this.method_24515();
            int range = 3;
            for (int i = 0; i < count; ++i) {
                mutableBlockPos.method_25504((class_2382)blockPos, class_3532.method_15395((class_5819)this.field_5974, (int)(-range), (int)range), class_3532.method_15395((class_5819)this.field_5974, (int)(-range), (int)range), class_3532.method_15395((class_5819)this.field_5974, (int)(-range), (int)range));
                if (this.method_37908().method_8320((class_2338)mutableBlockPos).method_26234((class_1922)this.method_37908(), (class_2338)mutableBlockPos)) continue;
                float velX = 0.06f * (float)(blockPos.method_10263() - mutableBlockPos.method_10263());
                float velY = 0.06f * (float)(blockPos.method_10264() - mutableBlockPos.method_10264());
                float velZ = 0.06f * (float)(blockPos.method_10260() - mutableBlockPos.method_10260());
                this.method_37908().method_8406((class_2394)GParticleTypes.SPECTATE_ORB, (double)((float)mutableBlockPos.method_10263() + 0.5f), (double)mutableBlockPos.method_10264(), (double)((float)mutableBlockPos.method_10260() + 0.5f), (double)velX, (double)velY, (double)velZ);
            }
        }
    }

    public class_1306 method_6068() {
        return null;
    }

    public void method_5749(class_2487 tag) {
        UUID uuid;
        super.method_5749(tag);
        this.setSpectatableTime(tag.method_10550("SpectatingTicks"));
        this.setPhase(tag.method_10550("Phase"));
        if (tag.method_25928("Manipulator")) {
            uuid = tag.method_25926("Manipulator");
        } else {
            String s = tag.method_10558("Manipulator");
            uuid = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)s);
        }
        if (uuid != null) {
            this.setManipulatorUUID(uuid);
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.getManipulatorUUID() != null) {
            tag.method_25927("Manipulator", this.getManipulatorUUID());
        }
        tag.method_10569("SpectatingTicks", this.getSpectatableTime());
        tag.method_10569("Phase", this.getPhase());
    }

    public class_1799 method_6118(class_1304 equipmentSlot) {
        return class_1799.field_8037;
    }

    public void method_6091(class_243 vec3) {
        if (this.getManipulatorUUID() == null) {
            super.method_6091(vec3);
        }
    }

    public void method_5673(class_1304 equipmentSlot, class_1799 itemStack) {
    }

    @Override
    @Nullable
    public UUID getManipulatorUUID() {
        return ((Optional)this.field_6011.method_12789(MANIPULATOR)).orElse(null);
    }

    @Override
    public void setManipulatorUUID(@Nullable UUID uuid) {
        this.field_6011.method_12778(MANIPULATOR, Optional.ofNullable(uuid));
    }

    @Override
    public void spectateTick(UUID uuid) {
        class_1657 player = this.method_37908().method_18470(uuid);
        if (player != null) {
            player.field_6212 = 0.0f;
            player.field_6250 = 0.0f;
            player.method_6100(false);
            this.copyPlayerRotation((class_1309)this, player);
            ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(this.getSpectatableTime() > 0);
            if (player.method_21751() || this.getSpectatableTime() == 0) {
                this.setManipulatorUUID(null);
                if (this.method_37908().field_9236) {
                    this.stopUsingSpyglass(player);
                } else {
                    ((SpectreBoundSpyglass)player).setUsingSpectreBoundedSpyglass(false);
                    player.method_17356(GSoundEvents.SPECTRE_MANIPULATE_END, this.method_5634(), 1.0f, 1.0f);
                    this.setManipulatorUUID(null);
                }
            }
        }
        if (!this.method_37908().method_8608() && player == null) {
            this.field_6011.method_12778(MANIPULATOR, Optional.empty());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void stopUsingSpyglass(class_1657 player) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == player) {
            client.method_1504((class_1297)player);
        }
    }

    public int getPhase() {
        return (Integer)this.field_6011.method_12789(PHASE);
    }

    public void setPhase(int phase) {
        this.field_6011.method_12778(PHASE, (Object)phase);
    }

    public static SpectatorVision create(class_1937 world, class_243 blockPos, class_3222 serverPlayer, int ticks) {
        SpectatorVision spectatorVision = new SpectatorVision(world);
        spectatorVision.method_24203(blockPos.field_1352, blockPos.field_1351, blockPos.field_1350);
        spectatorVision.setSpectatableTime(ticks);
        spectatorVision.setManipulatorUUID(serverPlayer.method_5667());
        return spectatorVision;
    }

    public int getSpectatableTime() {
        return (Integer)this.field_6011.method_12789(SPECTATING_TICKS);
    }

    public void setSpectatableTime(int spectatableTime) {
        this.field_6011.method_12778(SPECTATING_TICKS, (Object)spectatableTime);
    }
}

