/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.sensors;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_11;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4148;

public class NearestBlockSensor
extends class_4148<class_1308> {
    private static final int DEFAULT_RANGE = 8;
    private final class_4140<class_2338> memory;
    private final class_4140<?> required;
    private final NearestBlockCondition filter;
    private final int range;

    public NearestBlockSensor(class_4140<class_2338> memory, NearestBlockCondition filter) {
        this(memory, memory, filter, 8);
    }

    public NearestBlockSensor(class_4140<class_2338> memory, class_4140<?> required, NearestBlockCondition filter) {
        this(memory, required, filter, 8);
    }

    public NearestBlockSensor(class_4140<class_2338> memory, NearestBlockCondition filter, int range) {
        this(memory, memory, filter, range);
    }

    public NearestBlockSensor(class_4140<class_2338> memory, class_4140<?> required, NearestBlockCondition filter, int range) {
        this.memory = memory;
        this.required = required;
        this.filter = filter;
        this.range = range;
    }

    protected void doTick(class_3218 serverLevel, class_1308 entity) {
        ArrayList poses = Lists.newArrayList();
        for (int x = -this.range; x <= this.range; ++x) {
            for (int z = -this.range; z <= this.range; ++z) {
                for (int y = -this.range; y <= this.range; ++y) {
                    class_2338 pos = class_2338.method_49637((double)(entity.method_23317() + (double)x), (double)(entity.method_23318() + (double)y), (double)(entity.method_23321() + (double)z));
                    if (!this.filter.test((class_1937)serverLevel, pos, (class_1309)entity)) continue;
                    poses.add(pos);
                }
            }
        }
        if (!poses.isEmpty()) {
            poses.sort(Comparator.comparingDouble(arg_0 -> ((class_2338)entity.method_24515()).method_10262(arg_0)));
            for (class_2338 pos : poses) {
                boolean hasValue = entity.method_18868().method_18896(this.memory);
                boolean canReach = Optional.ofNullable(entity.method_5942().method_6348(pos, 0)).map(class_11::method_21655).orElse(false);
                if (hasValue || !canReach) continue;
                entity.method_18868().method_18878(this.memory, (Object)pos);
            }
        } else {
            entity.method_18868().method_18875(this.memory);
        }
    }

    public Set<class_4140<?>> method_19099() {
        return ImmutableSet.of(this.required);
    }

    public static interface NearestBlockCondition {
        public boolean test(class_1937 var1, class_2338 var2, class_1309 var3);
    }
}

