/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_5760;
import net.minecraft.class_7923;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.Specterpillar;
import net.orcinus.galosphere.entities.ai.MoleAi;
import net.orcinus.galosphere.entities.ai.SparkleAi;
import net.orcinus.galosphere.entities.ai.SpectreAi;
import net.orcinus.galosphere.entities.ai.sensors.BerserkerEntitySensor;
import net.orcinus.galosphere.entities.ai.sensors.MoleEntitySensor;
import net.orcinus.galosphere.entities.ai.sensors.NearestBlockSensor;
import net.orcinus.galosphere.entities.ai.sensors.PreservedEntitySensor;
import net.orcinus.galosphere.entities.ai.sensors.RepellentSensor;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class GSensorTypes {
    public static final Map<class_2960, class_4149<?>> SENSOR_TYPES = Maps.newLinkedHashMap();
    public static final class_4149<class_5760> SPARKLE_TEMPTATIONS = GSensorTypes.register("sparkle_temptations", () -> new class_5760(SparkleAi.getTemptations()));
    public static final class_4149<class_5760> SPECTRE_TEMPTATIONS = GSensorTypes.register("spectre_temptations", () -> new class_5760(SpectreAi.getTemptations()));
    public static final class_4149<class_5760> MOLE_TEMPTATIONS = GSensorTypes.register("mole_temptations", () -> new class_5760(MoleAi.getTemptations()));
    public static final class_4149<RepellentSensor> MOLE_REPELLENTS = GSensorTypes.register("mole_repellents", () -> new RepellentSensor(MoleAi::validRepellent));
    public static final class_4149<NearestBlockSensor> NEAREST_POLLINATED_CLUSTER = GSensorTypes.register("nearest_pollinated_cluster", () -> new NearestBlockSensor(GMemoryModuleTypes.NEAREST_POLLINATED_CLUSTER, Sparkle::isValidTargetState));
    public static final class_4149<NearestBlockSensor> NEAREST_LICHEN_MOSS = GSensorTypes.register("nearest_lichen_moss", () -> new NearestBlockSensor(GMemoryModuleTypes.NEAREST_LICHEN_MOSS, GMemoryModuleTypes.CAN_BURY, Specterpillar::isValidTargetState));
    public static final class_4149<NearestBlockSensor> NEAREST_MOLE_BURROW = GSensorTypes.register("nearest_mole_burrow", () -> new NearestBlockSensor(GMemoryModuleTypes.NEAREST_MOLE_BURROW, Mole::isValidTargetState));
    public static final class_4149<NearestBlockSensor> NEAREST_TUFF_DIRT = GSensorTypes.register("nearest_tuff_dirt", () -> new NearestBlockSensor(GMemoryModuleTypes.NEAREST_TUFF_DIRT, Mole::isTuffDirt));
    public static final class_4149<BerserkerEntitySensor> BERSERKER_ENTITY_SENSOR = GSensorTypes.register("berserker_entity_sensor", BerserkerEntitySensor::new);
    public static final class_4149<PreservedEntitySensor> PRESERVED_ENTITY_SENSOR = GSensorTypes.register("preserved_entity_sensor", PreservedEntitySensor::new);
    public static final class_4149<MoleEntitySensor> MOLE_ENTITY_SENSOR = GSensorTypes.register("mole_entity_sensor", MoleEntitySensor::new);

    private static <U extends class_4148<?>> class_4149<U> register(String string, Supplier<U> supplier) {
        class_4149 sensorType = new class_4149(supplier);
        SENSOR_TYPES.put(Galosphere.id(string), sensorType);
        return sensorType;
    }

    public static void init() {
        SENSOR_TYPES.forEach((resourceLocation, sensorType) -> class_2378.method_10230((class_2378)class_7923.field_41130, (class_2960)resourceLocation, (Object)sensorType));
    }
}

