/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.util.quests;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_8567;
import net.orcinus.galosphere.init.GBuiltinLootTables;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GRegistries;
import net.orcinus.galosphere.util.quests.IndexedQuest;
import net.orcinus.galosphere.util.quests.MiningQuest;

public class MiningPouchManager {
    public static class_1799 getPouch(class_3218 serverLevel, class_2338 blockPos) {
        IndexedQuest indexedQuest = MiningPouchManager.create(serverLevel, blockPos);
        class_1799 itemStack = new class_1799((class_1935)GItems.MINING_POUCH);
        itemStack.method_57379(GDataComponents.QUESTS, (Object)new IndexedQuest(indexedQuest.requests(), indexedQuest.rarity()));
        return itemStack;
    }

    public static ObjectArrayList<class_1799> getPouchRewards(class_3218 serverLevel, class_2338 blockPos, class_1814 rarity) {
        class_5321 resourcekey;
        List<MiningQuest> miningQuest = serverLevel.method_30349().method_30530(GRegistries.MINING_QUEST).method_10220().filter(quest -> quest.rarity() == rarity).toList();
        if (miningQuest.isEmpty()) {
            resourcekey = GBuiltinLootTables.MINING_QUESTS_COMMON_GIFT;
        } else {
            List<class_5321> key = miningQuest.stream().map(MiningQuest::gift).toList();
            resourcekey = key.get(serverLevel.method_8409().method_43048(key.size()));
        }
        return MiningPouchManager.generateItems(resourcekey, serverLevel, blockPos, 1);
    }

    public static IndexedQuest create(class_3218 serverLevel, class_2338 blockPos) {
        MiningQuest randomQuest = MiningPouchManager.getRandomQuest(serverLevel);
        ObjectArrayList<class_1799> required = MiningPouchManager.generateItems(randomQuest.required(), serverLevel, blockPos, 3);
        return new IndexedQuest((List<class_1799>)required, randomQuest.rarity());
    }

    public static MiningQuest getRandomQuest(class_3218 level) {
        List<MiningQuest> questsManager = level.method_30349().method_30530(GRegistries.MINING_QUEST).method_10220().toList();
        int randomValue = level.field_9229.method_43048(MiningPouchManager.getTotalQuestWeight(questsManager));
        for (MiningQuest miningQuest : questsManager) {
            int i = randomValue - miningQuest.weight();
            if (i >= 0) continue;
            return miningQuest;
        }
        return questsManager.get(level.method_8409().method_43048(questsManager.size()));
    }

    private static int getTotalQuestWeight(List<MiningQuest> quests) {
        long l = 0L;
        for (MiningQuest miningQuest : quests) {
            l += (long)miningQuest.weight();
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l;
    }

    public static ObjectArrayList<class_1799> generateItems(class_5321<class_52> key, class_3218 serverLevel, class_2338 blockPos, int count) {
        class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(key);
        ObjectArrayList result = new ObjectArrayList();
        if (count == 1) {
            class_8567 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockPos)).method_51875(class_173.field_48928);
            return lootTable.method_51878(lootParams);
        }
        for (int i = 0; i < 3; ++i) {
            class_8567 lootParams = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockPos)).method_51875(class_173.field_48928);
            ObjectArrayList randomItems = lootTable.method_51878(lootParams);
            boolean skip = false;
            if (!result.isEmpty()) {
                for (class_1799 stack : result) {
                    if (!stack.method_31574(((class_1799)randomItems.get(0)).method_7909())) continue;
                    skip = true;
                    break;
                }
            }
            if (skip) continue;
            result.add((Object)((class_1799)randomItems.get(0)));
        }
        return result;
    }
}

