/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.world.gen;

import net.orcinus.galosphere.world.gen.GVector2f;
import net.orcinus.galosphere.world.gen.GVector3f;

public class FastNoise {
    private int m_seed = 1337;
    private float m_frequency = 0.01f;
    private Interp m_interp = Interp.Quintic;
    private NoiseType m_noiseType = NoiseType.Simplex;
    private int m_octaves = 3;
    private float m_lacunarity = 2.0f;
    private float m_gain = 0.5f;
    private FractalType m_fractalType = FractalType.FBM;
    private float m_fractalBounding;
    private CellularDistanceFunction m_cellularDistanceFunction = CellularDistanceFunction.Euclidean;
    private CellularReturnType m_cellularReturnType = CellularReturnType.CellValue;
    private FastNoise m_cellularNoiseLookup = null;
    private float m_gradientPerturbAmp = 2.2222223f;
    private static final Float2[] GRAD_2D = new Float2[]{new Float2(-1.0f, -1.0f), new Float2(1.0f, -1.0f), new Float2(-1.0f, 1.0f), new Float2(1.0f, 1.0f), new Float2(0.0f, -1.0f), new Float2(-1.0f, 0.0f), new Float2(0.0f, 1.0f), new Float2(1.0f, 0.0f)};
    private static final Float3[] GRAD_3D = new Float3[]{new Float3(1.0f, 1.0f, 0.0f), new Float3(-1.0f, 1.0f, 0.0f), new Float3(1.0f, -1.0f, 0.0f), new Float3(-1.0f, -1.0f, 0.0f), new Float3(1.0f, 0.0f, 1.0f), new Float3(-1.0f, 0.0f, 1.0f), new Float3(1.0f, 0.0f, -1.0f), new Float3(-1.0f, 0.0f, -1.0f), new Float3(0.0f, 1.0f, 1.0f), new Float3(0.0f, -1.0f, 1.0f), new Float3(0.0f, 1.0f, -1.0f), new Float3(0.0f, -1.0f, -1.0f), new Float3(1.0f, 1.0f, 0.0f), new Float3(0.0f, -1.0f, 1.0f), new Float3(-1.0f, 1.0f, 0.0f), new Float3(0.0f, -1.0f, -1.0f)};
    private static final Float2[] CELL_2D = new Float2[]{new Float2(-0.43135393f, 0.12819435f), new Float2(-0.17333168f, 0.41527838f), new Float2(-0.28219575f, -0.35052183f), new Float2(-0.28064737f, 0.35176277f), new Float2(0.3125509f, -0.3237467f), new Float2(0.33830184f, -0.29673535f), new Float2(-0.4393982f, -0.09710417f), new Float2(-0.44604436f, -0.05953503f), new Float2(-0.30222303f, 0.3334085f), new Float2(-0.21268106f, -0.39656875f), new Float2(-0.29911566f, 0.33619907f), new Float2(0.22933237f, 0.38717782f), new Float2(0.44754392f, -0.046951506f), new Float2(0.1777518f, 0.41340572f), new Float2(0.16885225f, -0.4171198f), new Float2(-0.097659715f, 0.43927506f), new Float2(0.084501885f, 0.44199485f), new Float2(-0.40987605f, -0.18574613f), new Float2(0.34765857f, -0.2857158f), new Float2(-0.335067f, -0.30038327f), new Float2(0.229819f, -0.38688916f), new Float2(-0.010699241f, 0.4498728f), new Float2(-0.44601414f, -0.059761196f), new Float2(0.3650294f, 0.26316068f), new Float2(-0.34947944f, 0.28348568f), new Float2(-0.41227207f, 0.18036559f), new Float2(-0.26732782f, 0.36198872f), new Float2(0.32212403f, -0.31422302f), new Float2(0.2880446f, -0.34573156f), new Float2(0.38921708f, -0.22585405f), new Float2(0.4492085f, -0.026678115f), new Float2(-0.44977248f, 0.014307996f), new Float2(0.12781754f, -0.43146574f), new Float2(-0.035721004f, 0.44858f), new Float2(-0.4297407f, -0.13350253f), new Float2(-0.32178178f, 0.3145735f), new Float2(-0.3057159f, 0.33020872f), new Float2(-0.414504f, 0.17517549f), new Float2(-0.373814f, 0.25052565f), new Float2(0.22368914f, -0.39046532f), new Float2(0.0029677756f, -0.4499902f), new Float2(0.17471284f, -0.4146992f), new Float2(-0.44237724f, -0.08247648f), new Float2(-0.2763961f, -0.35511294f), new Float2(-0.4019386f, -0.20234962f), new Float2(0.3871414f, -0.22939382f), new Float2(-0.43000874f, 0.1326367f), new Float2(-0.030375743f, -0.44897363f), new Float2(-0.34861815f, 0.28454417f), new Float2(0.045535173f, -0.44769025f), new Float2(-0.037580293f, 0.44842806f), new Float2(0.3266409f, 0.309525f), new Float2(0.065400176f, -0.4452222f), new Float2(0.03409026f, 0.44870687f), new Float2(-0.44491938f, 0.06742967f), new Float2(-0.4255936f, -0.14618507f), new Float2(0.4499173f, 0.008627303f), new Float2(0.052426063f, 0.44693568f), new Float2(-0.4495305f, -0.020550266f), new Float2(-0.12047757f, 0.43357256f), new Float2(-0.3419864f, -0.2924813f), new Float2(0.386532f, 0.23041917f), new Float2(0.045060977f, -0.4477382f), new Float2(-0.06283466f, 0.4455915f), new Float2(0.39326003f, -0.21873853f), new Float2(0.44722617f, -0.04988731f), new Float2(0.3753571f, -0.24820767f), new Float2(-0.2736623f, 0.35722396f), new Float2(0.17004615f, 0.4166345f), new Float2(0.41026923f, 0.18487608f), new Float2(0.3232272f, -0.31308815f), new Float2(-0.28823102f, -0.34557614f), new Float2(0.20509727f, 0.4005435f), new Float2(0.4414086f, -0.08751257f), new Float2(-0.16847004f, 0.4172743f), new Float2(-0.0039780326f, 0.4499824f), new Float2(-0.20551336f, 0.4003302f), new Float2(-0.006095675f, -0.4499587f), new Float2(-0.11962281f, -0.43380916f), new Float2(0.39015284f, -0.2242337f), new Float2(0.017235318f, 0.4496698f), new Float2(-0.30150703f, 0.33405614f), new Float2(-0.015142624f, -0.44974515f), new Float2(-0.4142574f, -0.1757578f), new Float2(-0.19163772f, -0.40715474f), new Float2(0.37492487f, 0.24886008f), new Float2(-0.22377743f, 0.39041474f), new Float2(-0.41663432f, -0.17004661f), new Float2(0.36191717f, 0.2674247f), new Float2(0.18911268f, -0.4083337f), new Float2(-0.3127425f, 0.3235616f), new Float2(-0.3281808f, 0.30789182f), new Float2(-0.22948067f, 0.38708994f), new Float2(-0.34452662f, 0.28948474f), new Float2(-0.41670954f, -0.16986217f), new Float2(-0.2578903f, -0.36877173f), new Float2(-0.3612038f, 0.26838747f), new Float2(0.22679965f, 0.38866684f), new Float2(0.20715706f, 0.3994821f), new Float2(0.083551764f, -0.44217542f), new Float2(-0.43122333f, 0.12863296f), new Float2(0.32570556f, 0.3105091f), new Float2(0.1777011f, -0.41342753f), new Float2(-0.44518253f, 0.0656698f), new Float2(0.39551434f, 0.21463552f), new Float2(-0.4264614f, 0.14363383f), new Float2(-0.37937996f, -0.24201414f), new Float2(0.04617599f, -0.4476246f), new Float2(-0.37140542f, -0.25408268f), new Float2(0.25635704f, -0.36983925f), new Float2(0.03476646f, 0.44865498f), new Float2(-0.30654544f, 0.32943875f), new Float2(-0.22569798f, 0.38930762f), new Float2(0.41164485f, -0.18179253f), new Float2(-0.29077458f, -0.3434387f), new Float2(0.28422785f, -0.3488761f), new Float2(0.31145895f, -0.32479736f), new Float2(0.44641557f, -0.05668443f), new Float2(-0.3037334f, -0.33203316f), new Float2(0.4079607f, 0.18991591f), new Float2(-0.3486949f, -0.2844501f), new Float2(0.32648215f, 0.30969244f), new Float2(0.32111424f, 0.3152549f), new Float2(0.011833827f, 0.44984436f), new Float2(0.43338442f, 0.1211526f), new Float2(0.31186685f, 0.32440573f), new Float2(-0.27275348f, 0.35791835f), new Float2(-0.42222863f, -0.15563737f), new Float2(-0.10097001f, -0.438526f), new Float2(-0.2741171f, -0.35687506f), new Float2(-0.14651251f, 0.425481f), new Float2(0.2302279f, -0.38664597f), new Float2(-0.36994356f, 0.25620648f), new Float2(0.10570035f, -0.4374099f), new Float2(-0.26467136f, 0.36393553f), new Float2(0.3521828f, 0.2801201f), new Float2(-0.18641879f, -0.40957054f), new Float2(0.1994493f, -0.40338564f), new Float2(0.3937065f, 0.21793391f), new Float2(-0.32261583f, 0.31371805f), new Float2(0.37962353f, 0.2416319f), new Float2(0.1482922f, 0.424864f), new Float2(-0.4074004f, 0.19111493f), new Float2(0.4212853f, 0.15817298f), new Float2(-0.26212972f, 0.36577043f), new Float2(-0.2536987f, -0.37166783f), new Float2(-0.21002364f, 0.3979825f), new Float2(0.36241525f, 0.2667493f), new Float2(-0.36450386f, -0.26388812f), new Float2(0.23184867f, 0.38567626f), new Float2(-0.3260457f, 0.3101519f), new Float2(-0.21300453f, -0.3963951f), new Float2(0.3814999f, -0.23865843f), new Float2(-0.34297732f, 0.29131868f), new Float2(-0.43558657f, 0.11297941f), new Float2(-0.21046796f, 0.3977477f), new Float2(0.33483645f, -0.30064023f), new Float2(0.34304687f, 0.29123673f), new Float2(-0.22918367f, -0.38726586f), new Float2(0.25477073f, -0.3709338f), new Float2(0.42361748f, -0.1518164f), new Float2(-0.15387742f, 0.4228732f), new Float2(-0.44074494f, 0.09079596f), new Float2(-0.06805276f, -0.4448245f), new Float2(0.44535172f, -0.06451237f), new Float2(0.25624645f, -0.36991587f), new Float2(0.32781982f, -0.30827612f), new Float2(-0.41227743f, -0.18035334f), new Float2(0.3354091f, -0.30000123f), new Float2(0.44663286f, -0.054946158f), new Float2(-0.16089533f, 0.42025313f), new Float2(-0.09463955f, 0.43993562f), new Float2(-0.026376883f, -0.4492263f), new Float2(0.44710281f, -0.050981198f), new Float2(-0.4365671f, 0.10912917f), new Float2(-0.39598587f, 0.21376434f), new Float2(-0.42400482f, -0.15073125f), new Float2(-0.38827947f, 0.22746222f), new Float2(-0.42836526f, -0.13785212f), new Float2(0.3303888f, 0.30552125f), new Float2(0.3321435f, -0.30361274f), new Float2(-0.41302106f, -0.17864382f), new Float2(0.084030606f, -0.44208467f), new Float2(-0.38228828f, 0.23739347f), new Float2(-0.37123957f, -0.25432497f), new Float2(0.4472364f, -0.049795635f), new Float2(-0.44665912f, 0.054732345f), new Float2(0.048627254f, -0.44736493f), new Float2(-0.42031014f, -0.16074637f), new Float2(0.22053608f, 0.3922548f), new Float2(-0.36249006f, 0.2666476f), new Float2(-0.40360868f, -0.19899757f), new Float2(0.21527278f, 0.39516786f), new Float2(-0.43593928f, -0.11161062f), new Float2(0.4178354f, 0.1670735f), new Float2(0.20076302f, 0.40273342f), new Float2(-0.07278067f, -0.4440754f), new Float2(0.36447486f, -0.26392817f), new Float2(-0.43174517f, 0.12687041f), new Float2(-0.29743645f, 0.33768559f), new Float2(-0.2998672f, 0.3355289f), new Float2(-0.26736742f, 0.3619595f), new Float2(0.28084233f, 0.35160714f), new Float2(0.34989464f, 0.28297302f), new Float2(-0.22296856f, 0.39087725f), new Float2(0.33058232f, 0.30531186f), new Float2(-0.24366812f, -0.37831977f), new Float2(-0.034027766f, 0.4487116f), new Float2(-0.31935883f, 0.31703302f), new Float2(0.44546336f, -0.063737005f), new Float2(0.44835043f, 0.03849544f), new Float2(-0.44273585f, -0.08052933f), new Float2(0.054522987f, 0.44668472f), new Float2(-0.28125608f, 0.35127628f), new Float2(0.12666969f, 0.43180412f), new Float2(-0.37359813f, 0.25084746f), new Float2(0.29597083f, -0.3389709f), new Float2(-0.37143773f, 0.25403547f), new Float2(-0.4044671f, -0.19724695f), new Float2(0.16361657f, -0.41920117f), new Float2(0.32891855f, -0.30710354f), new Float2(-0.2494825f, -0.374511f), new Float2(0.032831334f, 0.44880074f), new Float2(-0.16630606f, -0.41814148f), new Float2(-0.10683318f, 0.43713462f), new Float2(0.0644026f, -0.4453676f), new Float2(-0.4483231f, 0.03881238f), new Float2(-0.42137775f, -0.15792651f), new Float2(0.05097921f, -0.44710302f), new Float2(0.20505841f, -0.40056342f), new Float2(0.41780984f, -0.16713744f), new Float2(-0.35651895f, -0.27458012f), new Float2(0.44783983f, 0.04403978f), new Float2(-0.33999997f, -0.2947881f), new Float2(0.3767122f, 0.24614613f), new Float2(-0.31389344f, 0.32244518f), new Float2(-0.14620018f, -0.42558843f), new Float2(0.39702904f, -0.21182053f), new Float2(0.44591492f, -0.0604969f), new Float2(-0.41048893f, -0.18438771f), new Float2(0.1475104f, -0.4251361f), new Float2(0.0925803f, 0.44037357f), new Float2(-0.15896647f, -0.42098653f), new Float2(0.2482445f, 0.37533274f), new Float2(0.43836242f, -0.10167786f), new Float2(0.06242803f, 0.44564867f), new Float2(0.2846591f, -0.3485243f), new Float2(-0.34420276f, -0.28986976f), new Float2(0.11981889f, -0.43375504f), new Float2(-0.2435907f, 0.37836963f), new Float2(0.2958191f, -0.3391033f), new Float2(-0.1164008f, 0.43468478f), new Float2(0.12740372f, -0.4315881f), new Float2(0.3680473f, 0.2589231f), new Float2(0.2451437f, 0.3773653f), new Float2(-0.43145096f, 0.12786736f)};
    private static final Float3[] CELL_3D = new Float3[]{new Float3(0.14537874f, -0.41497818f, -0.09569818f), new Float3(-0.012428297f, -0.14579184f, -0.42554703f), new Float3(0.28779796f, -0.026064834f, -0.34495357f), new Float3(-0.07732987f, 0.23770943f, 0.37418488f), new Float3(0.11072059f, -0.3552302f, -0.25308585f), new Float3(0.27552092f, 0.26405212f, -0.23846321f), new Float3(0.29416895f, 0.15260646f, 0.30442718f), new Float3(0.4000921f, -0.20340563f, 0.0324415f), new Float3(-0.16973041f, 0.39708647f, -0.12654613f), new Float3(-0.14832245f, -0.38596946f, 0.17756131f), new Float3(0.2623597f, -0.2354853f, 0.27966776f), new Float3(-0.2709003f, 0.3505271f, -0.07901747f), new Float3(-0.035165507f, 0.38852343f, 0.22430544f), new Float3(-0.12677127f, 0.1920044f, 0.38673422f), new Float3(0.02952022f, 0.44096857f, 0.084706925f), new Float3(-0.28068542f, -0.26699677f, 0.22897254f), new Float3(-0.17115955f, 0.21411856f, 0.35687205f), new Float3(0.21132272f, 0.39024058f, -0.074531786f), new Float3(-0.10243528f, 0.21280442f, -0.38304216f), new Float3(-0.330425f, -0.15669867f, 0.26223055f), new Float3(0.20911114f, 0.31332782f, -0.24616706f), new Float3(0.34467816f, -0.19442405f, -0.21423413f), new Float3(0.19844781f, -0.32143423f, -0.24453732f), new Float3(-0.29290086f, 0.22629151f, 0.2559321f), new Float3(-0.16173328f, 0.00631477f, -0.41988388f), new Float3(-0.35820603f, -0.14830318f, -0.2284614f), new Float3(-0.18520673f, -0.34541193f, -0.2211087f), new Float3(0.3046301f, 0.10263104f, 0.3149085f), new Float3(-0.038167685f, -0.25517663f, -0.3686843f), new Float3(-0.40849522f, 0.18059509f, 0.05492789f), new Float3(-0.026874434f, -0.27497414f, 0.35519993f), new Float3(-0.038010985f, 0.3277859f, 0.30596006f), new Float3(0.23711208f, 0.29003868f, -0.2493099f), new Float3(0.44476604f, 0.039469305f, 0.05590469f), new Float3(0.019851472f, -0.015031833f, -0.44931054f), new Float3(0.4274339f, 0.033459943f, -0.1366773f), new Float3(-0.20729886f, 0.28714147f, -0.27762738f), new Float3(-0.3791241f, 0.12811777f, 0.205793f), new Float3(-0.20987213f, -0.10070873f, -0.38511226f), new Float3(0.01582799f, 0.42638946f, 0.14297384f), new Float3(-0.18881294f, -0.31609967f, -0.2587096f), new Float3(0.1612989f, -0.19748051f, -0.3707885f), new Float3(-0.08974491f, 0.22914875f, -0.37674487f), new Float3(0.07041229f, 0.41502303f, -0.15905343f), new Float3(-0.108292565f, -0.15860616f, 0.40696046f), new Float3(0.24741006f, -0.33094147f, 0.17823021f), new Float3(-0.10688367f, -0.27016446f, -0.34363797f), new Float3(0.23964521f, 0.068036005f, -0.37475494f), new Float3(-0.30638862f, 0.25974283f, 0.2028785f), new Float3(0.15933429f, -0.311435f, -0.2830562f), new Float3(0.27096906f, 0.14126487f, -0.33033317f), new Float3(-0.15197805f, 0.3623355f, 0.2193528f), new Float3(0.16997737f, 0.3456013f, 0.232739f), new Float3(-0.19861557f, 0.38362765f, -0.12602258f), new Float3(-0.18874821f, -0.2050155f, -0.35333094f), new Float3(0.26591033f, 0.3015631f, -0.20211722f), new Float3(-0.08838976f, -0.42888197f, -0.1036702f), new Float3(-0.042018693f, 0.30995926f, 0.3235115f), new Float3(-0.32303345f, 0.20154992f, -0.23984788f), new Float3(0.2612721f, 0.27598545f, -0.24097495f), new Float3(0.38571304f, 0.21934603f, 0.074918374f), new Float3(0.07654968f, 0.37217322f, 0.24109592f), new Float3(0.4317039f, -0.02577753f, 0.12436751f), new Float3(-0.28904364f, -0.341818f, -0.045980845f), new Float3(-0.22019476f, 0.38302338f, -0.085483104f), new Float3(0.41613227f, -0.16696343f, -0.03817252f), new Float3(0.22047181f, 0.02654239f, -0.391392f), new Float3(-0.10403074f, 0.38900796f, -0.2008741f), new Float3(-0.14321226f, 0.3716144f, -0.20950656f), new Float3(0.39783806f, -0.062066693f, 0.20092937f), new Float3(-0.25992745f, 0.2616725f, -0.25780848f), new Float3(0.40326184f, -0.11245936f, 0.1650236f), new Float3(-0.0895347f, -0.30482447f, 0.31869355f), new Float3(0.1189372f, -0.2875222f, 0.3250922f), new Float3(0.02167047f, -0.032846306f, -0.44827616f), new Float3(-0.34113437f, 0.2500031f, 0.15370683f), new Float3(0.31629646f, 0.3082064f, -0.08640228f), new Float3(0.2355139f, -0.34393343f, -0.16953762f), new Float3(-0.028745415f, -0.39559332f, 0.21255504f), new Float3(-0.24614552f, 0.020202823f, -0.3761705f), new Float3(0.042080294f, -0.44704396f, 0.029680781f), new Float3(0.27274588f, 0.22884719f, -0.27520657f), new Float3(-0.13475229f, -0.027208483f, -0.42848748f), new Float3(0.38296244f, 0.123193145f, -0.20165123f), new Float3(-0.35476136f, 0.12717022f, 0.24591078f), new Float3(0.23057902f, 0.30638957f, 0.23549682f), new Float3(-0.08323845f, -0.19222452f, 0.39827263f), new Float3(0.2993663f, -0.2619918f, -0.21033332f), new Float3(-0.21548657f, 0.27067477f, 0.2877511f), new Float3(0.016833553f, -0.26806557f, -0.36105052f), new Float3(0.052404292f, 0.4335128f, -0.108721785f), new Float3(0.0094010485f, -0.44728905f, 0.0484161f), new Float3(0.34656888f, 0.011419145f, -0.28680938f), new Float3(-0.3706868f, -0.25511044f, 0.0031566927f), new Float3(0.274117f, 0.21399724f, -0.28559598f), new Float3(0.06413434f, 0.17087185f, 0.41132662f), new Float3(-0.38818797f, -0.039732803f, -0.22412363f), new Float3(0.064194694f, -0.28036824f, 0.3460819f), new Float3(-0.19861208f, -0.33911735f, 0.21920918f), new Float3(-0.20320301f, -0.38716415f, 0.10636004f), new Float3(-0.13897364f, -0.27759016f, -0.32577604f), new Float3(-0.065556414f, 0.34225327f, -0.28471926f), new Float3(-0.25292465f, -0.2904228f, 0.23277397f), new Float3(0.14444765f, 0.1069184f, 0.41255707f), new Float3(-0.364378f, -0.24471f, -0.09922543f), new Float3(0.42861426f, -0.13584961f, -0.018295068f), new Float3(0.16587292f, -0.31368086f, -0.27674988f), new Float3(0.22196105f, -0.365814f, 0.13933203f), new Float3(0.043229405f, -0.38327307f, 0.23180372f), new Float3(-0.0848127f, -0.44048697f, -0.035749655f), new Float3(0.18220821f, -0.39532593f, 0.1140946f), new Float3(-0.32693234f, 0.30365425f, 0.05838957f), new Float3(-0.40804854f, 0.042278584f, -0.18495652f), new Float3(0.26760253f, -0.012996716f, 0.36155218f), new Float3(0.30248925f, -0.10099903f, -0.3174893f), new Float3(0.1448494f, 0.42592168f, -0.01045808f), new Float3(0.41984022f, 0.0806232f, 0.14047809f), new Float3(-0.30088723f, -0.3330409f, -0.032413557f), new Float3(0.36393103f, -0.12912844f, -0.23104121f), new Float3(0.32958066f, 0.018417599f, -0.30583882f), new Float3(0.27762595f, -0.2974929f, -0.19215047f), new Float3(0.41490006f, -0.14479318f, -0.096916884f), new Float3(0.14501671f, -0.039899293f, 0.4241205f), new Float3(0.092990234f, -0.29973218f, -0.32251117f), new Float3(0.10289071f, -0.36126688f, 0.24778973f), new Float3(0.26830572f, -0.070760414f, -0.35426685f), new Float3(-0.4227307f, -0.07933162f, -0.13230732f), new Float3(-0.17812248f, 0.18068571f, -0.3716518f), new Float3(0.43907887f, -0.028418485f, -0.094351165f), new Float3(0.29725835f, 0.23827997f, -0.23949975f), new Float3(-0.17070028f, 0.22158457f, 0.3525077f), new Float3(0.38066867f, 0.14718525f, -0.18954648f), new Float3(-0.17514457f, -0.2748879f, 0.31025964f), new Float3(-0.22272375f, -0.23167789f, 0.31499124f), new Float3(0.13696331f, 0.13413431f, -0.40712288f), new Float3(-0.35295033f, -0.24728934f, -0.1295146f), new Float3(-0.25907442f, -0.29855776f, -0.21504351f), new Float3(-0.37840194f, 0.21998167f, -0.10449899f), new Float3(-0.056358058f, 0.14857374f, 0.42101023f), new Float3(0.32514286f, 0.09666047f, -0.29570064f), new Float3(-0.41909957f, 0.14067514f, -0.08405979f), new Float3(-0.3253151f, -0.3080335f, -0.042254567f), new Float3(0.2857946f, -0.05796152f, 0.34272718f), new Float3(-0.2733604f, 0.1973771f, -0.29802075f), new Float3(0.21900366f, 0.24100378f, -0.31057137f), new Float3(0.31827673f, -0.27134296f, 0.16605099f), new Float3(-0.03222023f, -0.33311614f, -0.30082467f), new Float3(-0.30877802f, 0.19927941f, -0.25969952f), new Float3(-0.06487612f, -0.4311323f, 0.11142734f), new Float3(0.39211714f, -0.06294284f, -0.2116184f), new Float3(-0.16064045f, -0.3589281f, -0.21878128f), new Float3(-0.037677713f, -0.22903514f, 0.3855169f), new Float3(0.13948669f, -0.3602214f, 0.23083329f), new Float3(-0.4345094f, 0.005751117f, 0.11691243f), new Float3(-0.10446375f, 0.41681284f, -0.13362028f), new Float3(0.26587275f, 0.25519434f, 0.2582393f), new Float3(0.2051462f, 0.19753908f, 0.3484155f), new Float3(-0.26608557f, 0.23483312f, 0.2766801f), new Float3(0.07849406f, -0.33003464f, -0.29566166f), new Float3(-0.21606864f, 0.053764515f, -0.39105463f), new Float3(-0.18577918f, 0.21484992f, 0.34903526f), new Float3(0.024924217f, -0.32299542f, -0.31233433f), new Float3(-0.12016783f, 0.40172666f, 0.16332598f), new Float3(-0.021600846f, -0.06885389f, 0.44417626f), new Float3(0.259767f, 0.30963007f, 0.19786438f), new Float3(-0.16115539f, -0.09823036f, 0.40850917f), new Float3(-0.32788968f, 0.14616702f, 0.27133662f), new Float3(0.2822735f, 0.03754421f, -0.3484424f), new Float3(0.03169341f, 0.34740525f, -0.28426242f), new Float3(0.22026137f, -0.3460788f, -0.18497133f), new Float3(0.2933396f, 0.30319735f, 0.15659896f), new Float3(-0.3194923f, 0.24537522f, -0.20053846f), new Float3(-0.3441586f, -0.16988562f, -0.23493347f), new Float3(0.27036458f, -0.35742772f, 0.040600598f), new Float3(0.2298569f, 0.37441564f, 0.09735889f), new Float3(0.09326604f, -0.31701088f, 0.30545956f), new Float3(-0.11161653f, -0.29850188f, 0.31770802f), new Float3(0.21729073f, -0.34600052f, -0.1885958f), new Float3(0.19913395f, 0.38203415f, -0.12998295f), new Float3(-0.054191817f, -0.21031451f, 0.3941206f), new Float3(0.08871337f, 0.20121174f, 0.39261147f), new Float3(0.27876732f, 0.35054046f, 0.04370535f), new Float3(-0.32216644f, 0.30672136f, 0.06804997f), new Float3(-0.42773664f, 0.13206677f, 0.045822866f), new Float3(0.24013188f, -0.1612516f, 0.34472394f), new Float3(0.1448608f, -0.2387819f, 0.35284352f), new Float3(-0.38370657f, -0.22063984f, 0.081162356f), new Float3(-0.4382628f, -0.09082753f, -0.046648555f), new Float3(-0.37728354f, 0.05445141f, 0.23914887f), new Float3(0.12595794f, 0.34839457f, 0.25545222f), new Float3(-0.14062855f, -0.27087736f, -0.33067968f), new Float3(-0.15806945f, 0.4162932f, -0.06491554f), new Float3(0.2477612f, -0.29278675f, -0.23535146f), new Float3(0.29161328f, 0.33125353f, 0.08793625f), new Float3(0.073652655f, -0.16661598f, 0.4114783f), new Float3(-0.26126525f, -0.24222377f, 0.27489653f), new Float3(-0.3721862f, 0.25279015f, 0.008634938f), new Float3(-0.36911917f, -0.25528118f, 0.032902323f), new Float3(0.22784418f, -0.3358365f, 0.1944245f), new Float3(0.36339816f, -0.23101902f, 0.13065979f), new Float3(-0.3042315f, -0.26984522f, 0.19268309f), new Float3(-0.3199312f, 0.31633255f, -0.008816978f), new Float3(0.28748524f, 0.16422755f, -0.30476475f), new Float3(-0.14510968f, 0.3277541f, -0.27206695f), new Float3(0.3220091f, 0.05113441f, 0.31015387f), new Float3(-0.12474009f, -0.043336052f, -0.4301882f), new Float3(-0.2829556f, -0.30561906f, -0.1703911f), new Float3(0.10693844f, 0.34910247f, -0.26304305f), new Float3(-0.14206612f, -0.30553767f, -0.29826826f), new Float3(-0.25054833f, 0.31564668f, -0.20023163f), new Float3(0.3265788f, 0.18712291f, 0.24664004f), new Float3(0.07646097f, -0.30266908f, 0.3241067f), new Float3(0.34517714f, 0.27571207f, -0.085648015f), new Float3(0.29813796f, 0.2852657f, 0.17954728f), new Float3(0.28122503f, 0.34667164f, 0.056844097f), new Float3(0.43903455f, -0.0979043f, -0.012783354f), new Float3(0.21483733f, 0.18501726f, 0.3494475f), new Float3(0.2595421f, -0.07946825f, 0.3589188f), new Float3(0.3182823f, -0.30735552f, -0.08203022f), new Float3(-0.40898594f, -0.046477184f, 0.18185264f), new Float3(-0.2826749f, 0.07417482f, 0.34218854f), new Float3(0.34838647f, 0.22544225f, -0.1740766f), new Float3(-0.32264152f, -0.14205854f, -0.27968165f), new Float3(0.4330735f, -0.11886856f, -0.028594075f), new Float3(-0.08717822f, -0.39098963f, -0.20500502f), new Float3(-0.21496783f, 0.3939974f, -0.032478984f), new Float3(-0.26873308f, 0.32268628f, -0.16172849f), new Float3(0.2105665f, -0.1961317f, -0.34596834f), new Float3(0.43618459f, -0.11055175f, 0.0046166084f), new Float3(0.053333335f, -0.3136395f, -0.31825432f), new Float3(-0.059862167f, 0.13610291f, -0.4247264f), new Float3(0.36649886f, 0.2550543f, -0.055909745f), new Float3(-0.23410155f, -0.18240573f, 0.33826706f), new Float3(-0.047309477f, -0.422215f, -0.14831145f), new Float3(-0.23915662f, -0.25776964f, -0.28081828f), new Float3(-0.1242081f, 0.42569533f, -0.07652336f), new Float3(0.26148328f, -0.36501792f, 0.02980623f), new Float3(-0.27287948f, -0.3499629f, 0.07458405f), new Float3(0.0078929f, -0.16727713f, 0.41767937f), new Float3(-0.017303303f, 0.29784867f, -0.33687797f), new Float3(0.20548357f, -0.32526004f, -0.23341466f), new Float3(-0.3231995f, 0.15642828f, -0.2712421f), new Float3(-0.2669546f, 0.25993437f, -0.2523279f), new Float3(-0.05554373f, 0.3170814f, -0.3144428f), new Float3(-0.20839357f, -0.31092283f, -0.24979813f), new Float3(0.06989323f, -0.31561416f, 0.31305373f), new Float3(0.38475662f, -0.16053091f, -0.16938764f), new Float3(-0.30262154f, -0.30015376f, -0.14431883f), new Float3(0.34507355f, 0.0861152f, 0.27569625f), new Float3(0.18144733f, -0.27887824f, -0.3029914f), new Float3(-0.038550105f, 0.09795111f, 0.4375151f), new Float3(0.35336703f, 0.26657528f, 0.08105161f), new Float3(-0.007945601f, 0.14035943f, -0.42747644f), new Float3(0.40630993f, -0.14917682f, -0.123119935f), new Float3(-0.20167735f, 0.008816271f, -0.40217972f), new Float3(-0.075270556f, -0.42564347f, -0.12514779f)};
    private static final int X_PRIME = 1619;
    private static final int Y_PRIME = 31337;
    private static final int Z_PRIME = 6971;
    private static final int W_PRIME = 1013;
    private static final float F3 = 0.33333334f;
    private static final float G3 = 0.16666667f;
    private static final float G33 = -0.5f;
    private static final float SQRT3 = 1.7320508f;
    private static final float F2 = 0.3660254f;
    private static final float G2 = 0.21132487f;
    private static final byte[] SIMPLEX_4D = new byte[]{0, 1, 2, 3, 0, 1, 3, 2, 0, 0, 0, 0, 0, 2, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 0, 0, 2, 1, 3, 0, 0, 0, 0, 0, 3, 1, 2, 0, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 0, 3, 0, 0, 0, 0, 1, 3, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 0, 1, 2, 3, 1, 0, 1, 0, 2, 3, 1, 0, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 3, 1, 0, 0, 0, 0, 2, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 1, 2, 3, 0, 2, 1, 0, 0, 0, 0, 3, 1, 2, 0, 2, 1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0, 2, 0, 0, 0, 0, 3, 2, 0, 1, 3, 2, 1, 0};
    private static final float F4 = 0.309017f;
    private static final float G4 = 0.1381966f;
    private static final float CUBIC_3D_BOUNDING = 0.2962963f;
    private static final float CUBIC_2D_BOUNDING = 0.44444445f;

    public FastNoise() {
        this(1337);
    }

    public FastNoise(int seed) {
        this.m_seed = seed;
        this.CalculateFractalBounding();
    }

    public static float GetDecimalType() {
        return 0.0f;
    }

    public int GetSeed() {
        return this.m_seed;
    }

    public void SetSeed(int seed) {
        this.m_seed = seed;
    }

    public void SetFrequency(float frequency) {
        this.m_frequency = frequency;
    }

    public void SetInterp(Interp interp) {
        this.m_interp = interp;
    }

    public void SetNoiseType(NoiseType noiseType) {
        this.m_noiseType = noiseType;
    }

    public void SetFractalOctaves(int octaves) {
        this.m_octaves = octaves;
        this.CalculateFractalBounding();
    }

    public void SetFractalLacunarity(float lacunarity) {
        this.m_lacunarity = lacunarity;
    }

    public void SetFractalGain(float gain) {
        this.m_gain = gain;
        this.CalculateFractalBounding();
    }

    public void SetFractalType(FractalType fractalType) {
        this.m_fractalType = fractalType;
    }

    public void SetCellularDistanceFunction(CellularDistanceFunction cellularDistanceFunction) {
        this.m_cellularDistanceFunction = cellularDistanceFunction;
    }

    public void SetCellularReturnType(CellularReturnType cellularReturnType) {
        this.m_cellularReturnType = cellularReturnType;
    }

    public void SetCellularNoiseLookup(FastNoise noise) {
        this.m_cellularNoiseLookup = noise;
    }

    public void SetGradientPerturbAmp(float gradientPerturbAmp) {
        this.m_gradientPerturbAmp = gradientPerturbAmp / 0.45f;
    }

    private static int FastFloor(float f) {
        return f >= 0.0f ? (int)f : (int)f - 1;
    }

    private static int FastRound(float f) {
        return f >= 0.0f ? (int)(f + 0.5f) : (int)(f - 0.5f);
    }

    private static float Lerp(float a, float b, float t) {
        return a + t * (b - a);
    }

    private static float InterpHermiteFunc(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    private static float InterpQuinticFunc(float t) {
        return t * t * t * (t * (t * 6.0f - 15.0f) + 10.0f);
    }

    private static float CubicLerp(float a, float b, float c, float d, float t) {
        float p = d - c - (a - b);
        return t * t * t * p + t * t * (a - b - p) + t * (c - a) + b;
    }

    private void CalculateFractalBounding() {
        float amp = this.m_gain;
        float ampFractal = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            ampFractal += amp;
            amp *= this.m_gain;
        }
        this.m_fractalBounding = 1.0f / ampFractal;
    }

    private static int Hash2D(int seed, int x, int y) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        return hash;
    }

    private static int Hash3D(int seed, int x, int y, int z) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash ^= 6971 * z;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        return hash;
    }

    private static int Hash4D(int seed, int x, int y, int z, int w) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash ^= 6971 * z;
        hash ^= 1013 * w;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        return hash;
    }

    private static float ValCoord2D(int seed, int x, int y) {
        int n = seed;
        n ^= 1619 * x;
        return (float)((n ^= 31337 * y) * n * n * 60493) / 2.1474836E9f;
    }

    private static float ValCoord3D(int seed, int x, int y, int z) {
        int n = seed;
        n ^= 1619 * x;
        n ^= 31337 * y;
        return (float)((n ^= 6971 * z) * n * n * 60493) / 2.1474836E9f;
    }

    private static float ValCoord4D(int seed, int x, int y, int z, int w) {
        int n = seed;
        n ^= 1619 * x;
        n ^= 31337 * y;
        n ^= 6971 * z;
        return (float)((n ^= 1013 * w) * n * n * 60493) / 2.1474836E9f;
    }

    private static float GradCoord2D(int seed, int x, int y, float xd, float yd) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        Float2 g = GRAD_2D[hash & 7];
        return xd * g.x + yd * g.y;
    }

    private static float GradCoord3D(int seed, int x, int y, int z, float xd, float yd, float zd) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash ^= 6971 * z;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        Float3 g = GRAD_3D[hash & 0xF];
        return xd * g.x + yd * g.y + zd * g.z;
    }

    private static float GradCoord4D(int seed, int x, int y, int z, int w, float xd, float yd, float zd, float wd) {
        int hash = seed;
        hash ^= 1619 * x;
        hash ^= 31337 * y;
        hash ^= 6971 * z;
        hash ^= 1013 * w;
        hash = hash * hash * hash * 60493;
        hash = hash >> 13 ^ hash;
        float a = yd;
        float b = zd;
        float c = wd;
        switch ((hash &= 0x1F) >> 3) {
            case 1: {
                a = wd;
                b = xd;
                c = yd;
                break;
            }
            case 2: {
                a = zd;
                b = wd;
                c = xd;
                break;
            }
            case 3: {
                a = yd;
                b = zd;
                c = wd;
            }
        }
        return ((hash & 4) == 0 ? -a : a) + ((hash & 2) == 0 ? -b : b) + ((hash & 1) == 0 ? -c : c);
    }

    public float GetNoise(float x, float y, float z) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        z *= this.m_frequency;
        switch (this.m_noiseType.ordinal()) {
            case 0: {
                return this.SingleValue(this.m_seed, x, y, z);
            }
            case 1: {
                switch (this.m_fractalType.ordinal()) {
                    case 0: {
                        return this.SingleValueFractalFBM(x, y, z);
                    }
                    case 1: {
                        return this.SingleValueFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.SingleValueFractalRigidMulti(x, y, z);
                    }
                }
                return 0.0f;
            }
            case 2: {
                return this.SinglePerlin(this.m_seed, x, y, z);
            }
            case 3: {
                switch (this.m_fractalType.ordinal()) {
                    case 0: {
                        return this.SinglePerlinFractalFBM(x, y, z);
                    }
                    case 1: {
                        return this.SinglePerlinFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.SinglePerlinFractalRigidMulti(x, y, z);
                    }
                }
                return 0.0f;
            }
            case 4: {
                return this.SingleSimplex(this.m_seed, x, y, z);
            }
            case 5: {
                switch (this.m_fractalType.ordinal()) {
                    case 0: {
                        return this.SingleSimplexFractalFBM(x, y, z);
                    }
                    case 1: {
                        return this.SingleSimplexFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.SingleSimplexFractalRigidMulti(x, y, z);
                    }
                }
                return 0.0f;
            }
            case 6: {
                switch (this.m_cellularReturnType.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return this.SingleCellular(x, y, z);
                    }
                }
                return this.SingleCellular2Edge(x, y, z);
            }
            case 7: {
                return this.GetWhiteNoise(x, y, z);
            }
            case 8: {
                return this.SingleCubic(this.m_seed, x, y, z);
            }
            case 9: {
                switch (this.m_fractalType.ordinal()) {
                    case 0: {
                        return this.SingleCubicFractalFBM(x, y, z);
                    }
                    case 1: {
                        return this.SingleCubicFractalBillow(x, y, z);
                    }
                    case 2: {
                        return this.SingleCubicFractalRigidMulti(x, y, z);
                    }
                }
                return 0.0f;
            }
        }
        return 0.0f;
    }

    public float GetNoise(float x, float y) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        switch (this.m_noiseType.ordinal()) {
            case 0: {
                return this.SingleValue(this.m_seed, x, y);
            }
            case 1: {
                switch (this.m_fractalType.ordinal()) {
                    case 0: {
                        return this.SingleValueFractalFBM(x, y);
                    }
                    case 1: {
                        return this.SingleValueFractalBillow(x, y);
                    }
                    case 2: {
                        return this.SingleValueFractalRigidMulti(x, y);
                    }
                }
                return 0.0f;
            }
            case 2: {
                return this.SinglePerlin(this.m_seed, x, y);
            }
            case 3: {
                switch (this.m_fractalType.ordinal()) {
                    case 0: {
                        return this.SinglePerlinFractalFBM(x, y);
                    }
                    case 1: {
                        return this.SinglePerlinFractalBillow(x, y);
                    }
                    case 2: {
                        return this.SinglePerlinFractalRigidMulti(x, y);
                    }
                }
                return 0.0f;
            }
            case 4: {
                return this.SingleSimplex(this.m_seed, x, y);
            }
            case 5: {
                switch (this.m_fractalType.ordinal()) {
                    case 0: {
                        return this.SingleSimplexFractalFBM(x, y);
                    }
                    case 1: {
                        return this.SingleSimplexFractalBillow(x, y);
                    }
                    case 2: {
                        return this.SingleSimplexFractalRigidMulti(x, y);
                    }
                }
                return 0.0f;
            }
            case 6: {
                switch (this.m_cellularReturnType.ordinal()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return this.SingleCellular(x, y);
                    }
                }
                return this.SingleCellular2Edge(x, y);
            }
            case 7: {
                return this.GetWhiteNoise(x, y);
            }
            case 8: {
                return this.SingleCubic(this.m_seed, x, y);
            }
            case 9: {
                switch (this.m_fractalType.ordinal()) {
                    case 0: {
                        return this.SingleCubicFractalFBM(x, y);
                    }
                    case 1: {
                        return this.SingleCubicFractalBillow(x, y);
                    }
                    case 2: {
                        return this.SingleCubicFractalRigidMulti(x, y);
                    }
                }
                return 0.0f;
            }
        }
        return 0.0f;
    }

    private int FloatCast2Int(float f) {
        int i = Float.floatToRawIntBits(f);
        return i ^ i >> 16;
    }

    public float GetWhiteNoise(float x, float y, float z, float w) {
        int xi = this.FloatCast2Int(x);
        int yi = this.FloatCast2Int(y);
        int zi = this.FloatCast2Int(z);
        int wi = this.FloatCast2Int(w);
        return FastNoise.ValCoord4D(this.m_seed, xi, yi, zi, wi);
    }

    public float GetWhiteNoise(float x, float y, float z) {
        int xi = this.FloatCast2Int(x);
        int yi = this.FloatCast2Int(y);
        int zi = this.FloatCast2Int(z);
        return FastNoise.ValCoord3D(this.m_seed, xi, yi, zi);
    }

    public float GetWhiteNoise(float x, float y) {
        int xi = this.FloatCast2Int(x);
        int yi = this.FloatCast2Int(y);
        return FastNoise.ValCoord2D(this.m_seed, xi, yi);
    }

    public float GetWhiteNoiseInt(int x, int y, int z, int w) {
        return FastNoise.ValCoord4D(this.m_seed, x, y, z, w);
    }

    public float GetWhiteNoiseInt(int x, int y, int z) {
        return FastNoise.ValCoord3D(this.m_seed, x, y, z);
    }

    public float GetWhiteNoiseInt(int x, int y) {
        return FastNoise.ValCoord2D(this.m_seed, x, y);
    }

    public float GetValueFractal(float x, float y, float z) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        z *= this.m_frequency;
        switch (this.m_fractalType.ordinal()) {
            case 0: {
                return this.SingleValueFractalFBM(x, y, z);
            }
            case 1: {
                return this.SingleValueFractalBillow(x, y, z);
            }
            case 2: {
                return this.SingleValueFractalRigidMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    private float SingleValueFractalFBM(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = this.SingleValue(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += this.SingleValue(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleValueFractalBillow(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = Math.abs(this.SingleValue(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += (Math.abs(this.SingleValue(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity)) * 2.0f - 1.0f) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleValueFractalRigidMulti(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = 1.0f - Math.abs(this.SingleValue(seed, x, y, z));
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum -= (1.0f - Math.abs(this.SingleValue(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity))) * (amp *= this.m_gain);
        }
        return sum;
    }

    public float GetValue(float x, float y, float z) {
        return this.SingleValue(this.m_seed, x * this.m_frequency, y * this.m_frequency, z * this.m_frequency);
    }

    private float SingleValue(int seed, float x, float y, float z) {
        float ys;
        float xs;
        int x0 = FastNoise.FastFloor(x);
        int y0 = FastNoise.FastFloor(y);
        int z0 = FastNoise.FastFloor(z);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        float zs = switch (this.m_interp.ordinal()) {
            default -> {
                xs = x - (float)x0;
                ys = y - (float)y0;
                yield z - (float)z0;
            }
            case 1 -> {
                xs = FastNoise.InterpHermiteFunc(x - (float)x0);
                ys = FastNoise.InterpHermiteFunc(y - (float)y0);
                yield FastNoise.InterpHermiteFunc(z - (float)z0);
            }
            case 2 -> {
                xs = FastNoise.InterpQuinticFunc(x - (float)x0);
                ys = FastNoise.InterpQuinticFunc(y - (float)y0);
                yield FastNoise.InterpQuinticFunc(z - (float)z0);
            }
        };
        float xf00 = FastNoise.Lerp(FastNoise.ValCoord3D(seed, x0, y0, z0), FastNoise.ValCoord3D(seed, x1, y0, z0), xs);
        float xf10 = FastNoise.Lerp(FastNoise.ValCoord3D(seed, x0, y1, z0), FastNoise.ValCoord3D(seed, x1, y1, z0), xs);
        float xf01 = FastNoise.Lerp(FastNoise.ValCoord3D(seed, x0, y0, z1), FastNoise.ValCoord3D(seed, x1, y0, z1), xs);
        float xf11 = FastNoise.Lerp(FastNoise.ValCoord3D(seed, x0, y1, z1), FastNoise.ValCoord3D(seed, x1, y1, z1), xs);
        float yf0 = FastNoise.Lerp(xf00, xf10, ys);
        float yf1 = FastNoise.Lerp(xf01, xf11, ys);
        return FastNoise.Lerp(yf0, yf1, zs);
    }

    public float GetValueFractal(float x, float y) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        switch (this.m_fractalType.ordinal()) {
            case 0: {
                return this.SingleValueFractalFBM(x, y);
            }
            case 1: {
                return this.SingleValueFractalBillow(x, y);
            }
            case 2: {
                return this.SingleValueFractalRigidMulti(x, y);
            }
        }
        return 0.0f;
    }

    private float SingleValueFractalFBM(float x, float y) {
        int seed = this.m_seed;
        float sum = this.SingleValue(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += this.SingleValue(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleValueFractalBillow(float x, float y) {
        int seed = this.m_seed;
        float sum = Math.abs(this.SingleValue(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += (Math.abs(this.SingleValue(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity)) * 2.0f - 1.0f) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleValueFractalRigidMulti(float x, float y) {
        int seed = this.m_seed;
        float sum = 1.0f - Math.abs(this.SingleValue(seed, x, y));
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum -= (1.0f - Math.abs(this.SingleValue(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity))) * (amp *= this.m_gain);
        }
        return sum;
    }

    public float GetValue(float x, float y) {
        return this.SingleValue(this.m_seed, x * this.m_frequency, y * this.m_frequency);
    }

    private float SingleValue(int seed, float x, float y) {
        float xs;
        int x0 = FastNoise.FastFloor(x);
        int y0 = FastNoise.FastFloor(y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        float ys = switch (this.m_interp.ordinal()) {
            default -> {
                xs = x - (float)x0;
                yield y - (float)y0;
            }
            case 1 -> {
                xs = FastNoise.InterpHermiteFunc(x - (float)x0);
                yield FastNoise.InterpHermiteFunc(y - (float)y0);
            }
            case 2 -> {
                xs = FastNoise.InterpQuinticFunc(x - (float)x0);
                yield FastNoise.InterpQuinticFunc(y - (float)y0);
            }
        };
        float xf0 = FastNoise.Lerp(FastNoise.ValCoord2D(seed, x0, y0), FastNoise.ValCoord2D(seed, x1, y0), xs);
        float xf1 = FastNoise.Lerp(FastNoise.ValCoord2D(seed, x0, y1), FastNoise.ValCoord2D(seed, x1, y1), xs);
        return FastNoise.Lerp(xf0, xf1, ys);
    }

    public float GetPerlinFractal(float x, float y, float z) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        z *= this.m_frequency;
        switch (this.m_fractalType.ordinal()) {
            case 0: {
                return this.SinglePerlinFractalFBM(x, y, z);
            }
            case 1: {
                return this.SinglePerlinFractalBillow(x, y, z);
            }
            case 2: {
                return this.SinglePerlinFractalRigidMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    private float SinglePerlinFractalFBM(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = this.SinglePerlin(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += this.SinglePerlin(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SinglePerlinFractalBillow(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = Math.abs(this.SinglePerlin(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += (Math.abs(this.SinglePerlin(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity)) * 2.0f - 1.0f) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SinglePerlinFractalRigidMulti(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = 1.0f - Math.abs(this.SinglePerlin(seed, x, y, z));
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum -= (1.0f - Math.abs(this.SinglePerlin(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity))) * (amp *= this.m_gain);
        }
        return sum;
    }

    public float GetPerlin(float x, float y, float z) {
        return this.SinglePerlin(this.m_seed, x * this.m_frequency, y * this.m_frequency, z * this.m_frequency);
    }

    private float SinglePerlin(int seed, float x, float y, float z) {
        float ys;
        float xs;
        int x0 = FastNoise.FastFloor(x);
        int y0 = FastNoise.FastFloor(y);
        int z0 = FastNoise.FastFloor(z);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        float zs = switch (this.m_interp.ordinal()) {
            default -> {
                xs = x - (float)x0;
                ys = y - (float)y0;
                yield z - (float)z0;
            }
            case 1 -> {
                xs = FastNoise.InterpHermiteFunc(x - (float)x0);
                ys = FastNoise.InterpHermiteFunc(y - (float)y0);
                yield FastNoise.InterpHermiteFunc(z - (float)z0);
            }
            case 2 -> {
                xs = FastNoise.InterpQuinticFunc(x - (float)x0);
                ys = FastNoise.InterpQuinticFunc(y - (float)y0);
                yield FastNoise.InterpQuinticFunc(z - (float)z0);
            }
        };
        float xd0 = x - (float)x0;
        float yd0 = y - (float)y0;
        float zd0 = z - (float)z0;
        float xd1 = xd0 - 1.0f;
        float yd1 = yd0 - 1.0f;
        float zd1 = zd0 - 1.0f;
        float xf00 = FastNoise.Lerp(FastNoise.GradCoord3D(seed, x0, y0, z0, xd0, yd0, zd0), FastNoise.GradCoord3D(seed, x1, y0, z0, xd1, yd0, zd0), xs);
        float xf10 = FastNoise.Lerp(FastNoise.GradCoord3D(seed, x0, y1, z0, xd0, yd1, zd0), FastNoise.GradCoord3D(seed, x1, y1, z0, xd1, yd1, zd0), xs);
        float xf01 = FastNoise.Lerp(FastNoise.GradCoord3D(seed, x0, y0, z1, xd0, yd0, zd1), FastNoise.GradCoord3D(seed, x1, y0, z1, xd1, yd0, zd1), xs);
        float xf11 = FastNoise.Lerp(FastNoise.GradCoord3D(seed, x0, y1, z1, xd0, yd1, zd1), FastNoise.GradCoord3D(seed, x1, y1, z1, xd1, yd1, zd1), xs);
        float yf0 = FastNoise.Lerp(xf00, xf10, ys);
        float yf1 = FastNoise.Lerp(xf01, xf11, ys);
        return FastNoise.Lerp(yf0, yf1, zs);
    }

    public float GetPerlinFractal(float x, float y) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        switch (this.m_fractalType.ordinal()) {
            case 0: {
                return this.SinglePerlinFractalFBM(x, y);
            }
            case 1: {
                return this.SinglePerlinFractalBillow(x, y);
            }
            case 2: {
                return this.SinglePerlinFractalRigidMulti(x, y);
            }
        }
        return 0.0f;
    }

    private float SinglePerlinFractalFBM(float x, float y) {
        int seed = this.m_seed;
        float sum = this.SinglePerlin(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += this.SinglePerlin(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SinglePerlinFractalBillow(float x, float y) {
        int seed = this.m_seed;
        float sum = Math.abs(this.SinglePerlin(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += (Math.abs(this.SinglePerlin(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity)) * 2.0f - 1.0f) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SinglePerlinFractalRigidMulti(float x, float y) {
        int seed = this.m_seed;
        float sum = 1.0f - Math.abs(this.SinglePerlin(seed, x, y));
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum -= (1.0f - Math.abs(this.SinglePerlin(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity))) * (amp *= this.m_gain);
        }
        return sum;
    }

    public float GetPerlin(float x, float y) {
        return this.SinglePerlin(this.m_seed, x * this.m_frequency, y * this.m_frequency);
    }

    private float SinglePerlin(int seed, float x, float y) {
        float xs;
        int x0 = FastNoise.FastFloor(x);
        int y0 = FastNoise.FastFloor(y);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        float ys = switch (this.m_interp.ordinal()) {
            default -> {
                xs = x - (float)x0;
                yield y - (float)y0;
            }
            case 1 -> {
                xs = FastNoise.InterpHermiteFunc(x - (float)x0);
                yield FastNoise.InterpHermiteFunc(y - (float)y0);
            }
            case 2 -> {
                xs = FastNoise.InterpQuinticFunc(x - (float)x0);
                yield FastNoise.InterpQuinticFunc(y - (float)y0);
            }
        };
        float xd0 = x - (float)x0;
        float yd0 = y - (float)y0;
        float xd1 = xd0 - 1.0f;
        float yd1 = yd0 - 1.0f;
        float xf0 = FastNoise.Lerp(FastNoise.GradCoord2D(seed, x0, y0, xd0, yd0), FastNoise.GradCoord2D(seed, x1, y0, xd1, yd0), xs);
        float xf1 = FastNoise.Lerp(FastNoise.GradCoord2D(seed, x0, y1, xd0, yd1), FastNoise.GradCoord2D(seed, x1, y1, xd1, yd1), xs);
        return FastNoise.Lerp(xf0, xf1, ys);
    }

    public float GetSimplexFractal(float x, float y, float z) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        z *= this.m_frequency;
        switch (this.m_fractalType.ordinal()) {
            case 0: {
                return this.SingleSimplexFractalFBM(x, y, z);
            }
            case 1: {
                return this.SingleSimplexFractalBillow(x, y, z);
            }
            case 2: {
                return this.SingleSimplexFractalRigidMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    private float SingleSimplexFractalFBM(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = this.SingleSimplex(seed, x, y, z);
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += this.SingleSimplex(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleSimplexFractalBillow(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = Math.abs(this.SingleSimplex(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += (Math.abs(this.SingleSimplex(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity)) * 2.0f - 1.0f) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleSimplexFractalRigidMulti(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = 1.0f - Math.abs(this.SingleSimplex(seed, x, y, z));
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum -= (1.0f - Math.abs(this.SingleSimplex(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity))) * (amp *= this.m_gain);
        }
        return sum;
    }

    public float GetSimplex(float x, float y, float z) {
        return this.SingleSimplex(this.m_seed, x * this.m_frequency, y * this.m_frequency, z * this.m_frequency);
    }

    private float SingleSimplex(int seed, float x, float y, float z) {
        float n3;
        float n2;
        float n1;
        float n0;
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        float t = (x + y + z) * 0.33333334f;
        int i = FastNoise.FastFloor(x + t);
        int j = FastNoise.FastFloor(y + t);
        int k = FastNoise.FastFloor(z + t);
        t = (float)(i + j + k) * 0.16666667f;
        float x0 = x - ((float)i - t);
        float y0 = y - ((float)j - t);
        float z0 = z - ((float)k - t);
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        float x1 = x0 - (float)i1 + 0.16666667f;
        float y1 = y0 - (float)j1 + 0.16666667f;
        float z1 = z0 - (float)k1 + 0.16666667f;
        float x2 = x0 - (float)i2 + 0.33333334f;
        float y2 = y0 - (float)j2 + 0.33333334f;
        float z2 = z0 - (float)k2 + 0.33333334f;
        float x3 = x0 + -0.5f;
        float y3 = y0 + -0.5f;
        float z3 = z0 + -0.5f;
        t = 0.6f - x0 * x0 - y0 * y0 - z0 * z0;
        if (t < 0.0f) {
            n0 = 0.0f;
        } else {
            t *= t;
            n0 = t * t * FastNoise.GradCoord3D(seed, i, j, k, x0, y0, z0);
        }
        t = 0.6f - x1 * x1 - y1 * y1 - z1 * z1;
        if (t < 0.0f) {
            n1 = 0.0f;
        } else {
            t *= t;
            n1 = t * t * FastNoise.GradCoord3D(seed, i + i1, j + j1, k + k1, x1, y1, z1);
        }
        t = 0.6f - x2 * x2 - y2 * y2 - z2 * z2;
        if (t < 0.0f) {
            n2 = 0.0f;
        } else {
            t *= t;
            n2 = t * t * FastNoise.GradCoord3D(seed, i + i2, j + j2, k + k2, x2, y2, z2);
        }
        t = 0.6f - x3 * x3 - y3 * y3 - z3 * z3;
        if (t < 0.0f) {
            n3 = 0.0f;
        } else {
            t *= t;
            n3 = t * t * FastNoise.GradCoord3D(seed, i + 1, j + 1, k + 1, x3, y3, z3);
        }
        return 32.0f * (n0 + n1 + n2 + n3);
    }

    public float GetSimplexFractal(float x, float y) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        switch (this.m_fractalType.ordinal()) {
            case 0: {
                return this.SingleSimplexFractalFBM(x, y);
            }
            case 1: {
                return this.SingleSimplexFractalBillow(x, y);
            }
            case 2: {
                return this.SingleSimplexFractalRigidMulti(x, y);
            }
        }
        return 0.0f;
    }

    private float SingleSimplexFractalFBM(float x, float y) {
        int seed = this.m_seed;
        float sum = this.SingleSimplex(seed, x, y);
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += this.SingleSimplex(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleSimplexFractalBillow(float x, float y) {
        int seed = this.m_seed;
        float sum = Math.abs(this.SingleSimplex(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum += (Math.abs(this.SingleSimplex(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity)) * 2.0f - 1.0f) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleSimplexFractalRigidMulti(float x, float y) {
        int seed = this.m_seed;
        float sum = 1.0f - Math.abs(this.SingleSimplex(seed, x, y));
        float amp = 1.0f;
        for (int i = 1; i < this.m_octaves; ++i) {
            sum -= (1.0f - Math.abs(this.SingleSimplex(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity))) * (amp *= this.m_gain);
        }
        return sum;
    }

    public float GetSimplex(float x, float y) {
        return this.SingleSimplex(this.m_seed, x * this.m_frequency, y * this.m_frequency);
    }

    private float SingleSimplex(int seed, float x, float y) {
        float n2;
        float n1;
        float n0;
        int j1;
        int i1;
        float Y0;
        float y0;
        int j;
        float t = (x + y) * 0.3660254f;
        int i = FastNoise.FastFloor(x + t);
        float X0 = (float)i - (t = (float)(i + (j = FastNoise.FastFloor(y + t))) * 0.21132487f);
        float x0 = x - X0;
        if (x0 > (y0 = y - (Y0 = (float)j - t))) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        float x1 = x0 - (float)i1 + 0.21132487f;
        float y1 = y0 - (float)j1 + 0.21132487f;
        float x2 = x0 - 1.0f + 0.42264974f;
        float y2 = y0 - 1.0f + 0.42264974f;
        t = 0.5f - x0 * x0 - y0 * y0;
        if (t < 0.0f) {
            n0 = 0.0f;
        } else {
            t *= t;
            n0 = t * t * FastNoise.GradCoord2D(seed, i, j, x0, y0);
        }
        t = 0.5f - x1 * x1 - y1 * y1;
        if (t < 0.0f) {
            n1 = 0.0f;
        } else {
            t *= t;
            n1 = t * t * FastNoise.GradCoord2D(seed, i + i1, j + j1, x1, y1);
        }
        t = 0.5f - x2 * x2 - y2 * y2;
        if (t < 0.0f) {
            n2 = 0.0f;
        } else {
            t *= t;
            n2 = t * t * FastNoise.GradCoord2D(seed, i + 1, j + 1, x2, y2);
        }
        return 50.0f * (n0 + n1 + n2);
    }

    public float GetSimplex(float x, float y, float z, float w) {
        return this.SingleSimplex(this.m_seed, x * this.m_frequency, y * this.m_frequency, z * this.m_frequency, w * this.m_frequency);
    }

    private float SingleSimplex(int seed, float x, float y, float z, float w) {
        float n4;
        float n3;
        float n2;
        float n1;
        float n0;
        float t = (x + y + z + w) * 0.309017f;
        int i = FastNoise.FastFloor(x + t);
        int j = FastNoise.FastFloor(y + t);
        int k = FastNoise.FastFloor(z + t);
        int l = FastNoise.FastFloor(w + t);
        t = (float)(i + j + k + l) * 0.1381966f;
        float X0 = (float)i - t;
        float Y0 = (float)j - t;
        float Z0 = (float)k - t;
        float W0 = (float)l - t;
        float x0 = x - X0;
        float y0 = y - Y0;
        float z0 = z - Z0;
        float w0 = w - W0;
        int c = x0 > y0 ? 32 : 0;
        c += x0 > z0 ? 16 : 0;
        c += y0 > z0 ? 8 : 0;
        c += x0 > w0 ? 4 : 0;
        c += y0 > w0 ? 2 : 0;
        c += z0 > w0 ? 1 : 0;
        int i1 = SIMPLEX_4D[c <<= 2] >= 3 ? 1 : 0;
        int i2 = SIMPLEX_4D[c] >= 2 ? 1 : 0;
        int i3 = SIMPLEX_4D[c++] >= 1 ? 1 : 0;
        int j1 = SIMPLEX_4D[c] >= 3 ? 1 : 0;
        int j2 = SIMPLEX_4D[c] >= 2 ? 1 : 0;
        int j3 = SIMPLEX_4D[c++] >= 1 ? 1 : 0;
        int k1 = SIMPLEX_4D[c] >= 3 ? 1 : 0;
        int k2 = SIMPLEX_4D[c] >= 2 ? 1 : 0;
        int k3 = SIMPLEX_4D[c++] >= 1 ? 1 : 0;
        int l1 = SIMPLEX_4D[c] >= 3 ? 1 : 0;
        int l2 = SIMPLEX_4D[c] >= 2 ? 1 : 0;
        int l3 = SIMPLEX_4D[c] >= 1 ? 1 : 0;
        float x1 = x0 - (float)i1 + 0.1381966f;
        float y1 = y0 - (float)j1 + 0.1381966f;
        float z1 = z0 - (float)k1 + 0.1381966f;
        float w1 = w0 - (float)l1 + 0.1381966f;
        float x2 = x0 - (float)i2 + 0.2763932f;
        float y2 = y0 - (float)j2 + 0.2763932f;
        float z2 = z0 - (float)k2 + 0.2763932f;
        float w2 = w0 - (float)l2 + 0.2763932f;
        float x3 = x0 - (float)i3 + 0.41458982f;
        float y3 = y0 - (float)j3 + 0.41458982f;
        float z3 = z0 - (float)k3 + 0.41458982f;
        float w3 = w0 - (float)l3 + 0.41458982f;
        float x4 = x0 - 1.0f + 0.5527864f;
        float y4 = y0 - 1.0f + 0.5527864f;
        float z4 = z0 - 1.0f + 0.5527864f;
        float w4 = w0 - 1.0f + 0.5527864f;
        t = 0.6f - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0;
        if (t < 0.0f) {
            n0 = 0.0f;
        } else {
            t *= t;
            n0 = t * t * FastNoise.GradCoord4D(seed, i, j, k, l, x0, y0, z0, w0);
        }
        t = 0.6f - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1;
        if (t < 0.0f) {
            n1 = 0.0f;
        } else {
            t *= t;
            n1 = t * t * FastNoise.GradCoord4D(seed, i + i1, j + j1, k + k1, l + l1, x1, y1, z1, w1);
        }
        t = 0.6f - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2;
        if (t < 0.0f) {
            n2 = 0.0f;
        } else {
            t *= t;
            n2 = t * t * FastNoise.GradCoord4D(seed, i + i2, j + j2, k + k2, l + l2, x2, y2, z2, w2);
        }
        t = 0.6f - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3;
        if (t < 0.0f) {
            n3 = 0.0f;
        } else {
            t *= t;
            n3 = t * t * FastNoise.GradCoord4D(seed, i + i3, j + j3, k + k3, l + l3, x3, y3, z3, w3);
        }
        t = 0.6f - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4;
        if (t < 0.0f) {
            n4 = 0.0f;
        } else {
            t *= t;
            n4 = t * t * FastNoise.GradCoord4D(seed, i + 1, j + 1, k + 1, l + 1, x4, y4, z4, w4);
        }
        return 27.0f * (n0 + n1 + n2 + n3 + n4);
    }

    public float GetCubicFractal(float x, float y, float z) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        z *= this.m_frequency;
        switch (this.m_fractalType.ordinal()) {
            case 0: {
                return this.SingleCubicFractalFBM(x, y, z);
            }
            case 1: {
                return this.SingleCubicFractalBillow(x, y, z);
            }
            case 2: {
                return this.SingleCubicFractalRigidMulti(x, y, z);
            }
        }
        return 0.0f;
    }

    private float SingleCubicFractalFBM(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = this.SingleCubic(seed, x, y, z);
        float amp = 1.0f;
        int i = 0;
        while (++i < this.m_octaves) {
            sum += this.SingleCubic(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleCubicFractalBillow(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = Math.abs(this.SingleCubic(seed, x, y, z)) * 2.0f - 1.0f;
        float amp = 1.0f;
        int i = 0;
        while (++i < this.m_octaves) {
            sum += (Math.abs(this.SingleCubic(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity)) * 2.0f - 1.0f) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleCubicFractalRigidMulti(float x, float y, float z) {
        int seed = this.m_seed;
        float sum = 1.0f - Math.abs(this.SingleCubic(seed, x, y, z));
        float amp = 1.0f;
        int i = 0;
        while (++i < this.m_octaves) {
            sum -= (1.0f - Math.abs(this.SingleCubic(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity, z *= this.m_lacunarity))) * (amp *= this.m_gain);
        }
        return sum;
    }

    public float GetCubic(float x, float y, float z) {
        return this.SingleCubic(this.m_seed, x * this.m_frequency, y * this.m_frequency, z * this.m_frequency);
    }

    private float SingleCubic(int seed, float x, float y, float z) {
        int x1 = FastNoise.FastFloor(x);
        int y1 = FastNoise.FastFloor(y);
        int z1 = FastNoise.FastFloor(z);
        int x0 = x1 - 1;
        int y0 = y1 - 1;
        int z0 = z1 - 1;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int z2 = z1 + 1;
        int x3 = x1 + 2;
        int y3 = y1 + 2;
        int z3 = z1 + 2;
        float xs = x - (float)x1;
        float ys = y - (float)y1;
        float zs = z - (float)z1;
        return FastNoise.CubicLerp(FastNoise.CubicLerp(FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y0, z0), FastNoise.ValCoord3D(seed, x1, y0, z0), FastNoise.ValCoord3D(seed, x2, y0, z0), FastNoise.ValCoord3D(seed, x3, y0, z0), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y1, z0), FastNoise.ValCoord3D(seed, x1, y1, z0), FastNoise.ValCoord3D(seed, x2, y1, z0), FastNoise.ValCoord3D(seed, x3, y1, z0), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y2, z0), FastNoise.ValCoord3D(seed, x1, y2, z0), FastNoise.ValCoord3D(seed, x2, y2, z0), FastNoise.ValCoord3D(seed, x3, y2, z0), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y3, z0), FastNoise.ValCoord3D(seed, x1, y3, z0), FastNoise.ValCoord3D(seed, x2, y3, z0), FastNoise.ValCoord3D(seed, x3, y3, z0), xs), ys), FastNoise.CubicLerp(FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y0, z1), FastNoise.ValCoord3D(seed, x1, y0, z1), FastNoise.ValCoord3D(seed, x2, y0, z1), FastNoise.ValCoord3D(seed, x3, y0, z1), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y1, z1), FastNoise.ValCoord3D(seed, x1, y1, z1), FastNoise.ValCoord3D(seed, x2, y1, z1), FastNoise.ValCoord3D(seed, x3, y1, z1), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y2, z1), FastNoise.ValCoord3D(seed, x1, y2, z1), FastNoise.ValCoord3D(seed, x2, y2, z1), FastNoise.ValCoord3D(seed, x3, y2, z1), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y3, z1), FastNoise.ValCoord3D(seed, x1, y3, z1), FastNoise.ValCoord3D(seed, x2, y3, z1), FastNoise.ValCoord3D(seed, x3, y3, z1), xs), ys), FastNoise.CubicLerp(FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y0, z2), FastNoise.ValCoord3D(seed, x1, y0, z2), FastNoise.ValCoord3D(seed, x2, y0, z2), FastNoise.ValCoord3D(seed, x3, y0, z2), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y1, z2), FastNoise.ValCoord3D(seed, x1, y1, z2), FastNoise.ValCoord3D(seed, x2, y1, z2), FastNoise.ValCoord3D(seed, x3, y1, z2), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y2, z2), FastNoise.ValCoord3D(seed, x1, y2, z2), FastNoise.ValCoord3D(seed, x2, y2, z2), FastNoise.ValCoord3D(seed, x3, y2, z2), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y3, z2), FastNoise.ValCoord3D(seed, x1, y3, z2), FastNoise.ValCoord3D(seed, x2, y3, z2), FastNoise.ValCoord3D(seed, x3, y3, z2), xs), ys), FastNoise.CubicLerp(FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y0, z3), FastNoise.ValCoord3D(seed, x1, y0, z3), FastNoise.ValCoord3D(seed, x2, y0, z3), FastNoise.ValCoord3D(seed, x3, y0, z3), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y1, z3), FastNoise.ValCoord3D(seed, x1, y1, z3), FastNoise.ValCoord3D(seed, x2, y1, z3), FastNoise.ValCoord3D(seed, x3, y1, z3), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y2, z3), FastNoise.ValCoord3D(seed, x1, y2, z3), FastNoise.ValCoord3D(seed, x2, y2, z3), FastNoise.ValCoord3D(seed, x3, y2, z3), xs), FastNoise.CubicLerp(FastNoise.ValCoord3D(seed, x0, y3, z3), FastNoise.ValCoord3D(seed, x1, y3, z3), FastNoise.ValCoord3D(seed, x2, y3, z3), FastNoise.ValCoord3D(seed, x3, y3, z3), xs), ys), zs) * 0.2962963f;
    }

    public float GetCubicFractal(float x, float y) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        switch (this.m_fractalType.ordinal()) {
            case 0: {
                return this.SingleCubicFractalFBM(x, y);
            }
            case 1: {
                return this.SingleCubicFractalBillow(x, y);
            }
            case 2: {
                return this.SingleCubicFractalRigidMulti(x, y);
            }
        }
        return 0.0f;
    }

    private float SingleCubicFractalFBM(float x, float y) {
        int seed = this.m_seed;
        float sum = this.SingleCubic(seed, x, y);
        float amp = 1.0f;
        int i = 0;
        while (++i < this.m_octaves) {
            sum += this.SingleCubic(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleCubicFractalBillow(float x, float y) {
        int seed = this.m_seed;
        float sum = Math.abs(this.SingleCubic(seed, x, y)) * 2.0f - 1.0f;
        float amp = 1.0f;
        int i = 0;
        while (++i < this.m_octaves) {
            sum += (Math.abs(this.SingleCubic(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity)) * 2.0f - 1.0f) * (amp *= this.m_gain);
        }
        return sum * this.m_fractalBounding;
    }

    private float SingleCubicFractalRigidMulti(float x, float y) {
        int seed = this.m_seed;
        float sum = 1.0f - Math.abs(this.SingleCubic(seed, x, y));
        float amp = 1.0f;
        int i = 0;
        while (++i < this.m_octaves) {
            sum -= (1.0f - Math.abs(this.SingleCubic(++seed, x *= this.m_lacunarity, y *= this.m_lacunarity))) * (amp *= this.m_gain);
        }
        return sum;
    }

    public float GetCubic(float x, float y) {
        return this.SingleCubic(0, x *= this.m_frequency, y *= this.m_frequency);
    }

    private float SingleCubic(int seed, float x, float y) {
        int x1 = FastNoise.FastFloor(x);
        int y1 = FastNoise.FastFloor(y);
        int x0 = x1 - 1;
        int y0 = y1 - 1;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int x3 = x1 + 2;
        int y3 = y1 + 2;
        float xs = x - (float)x1;
        float ys = y - (float)y1;
        return FastNoise.CubicLerp(FastNoise.CubicLerp(FastNoise.ValCoord2D(seed, x0, y0), FastNoise.ValCoord2D(seed, x1, y0), FastNoise.ValCoord2D(seed, x2, y0), FastNoise.ValCoord2D(seed, x3, y0), xs), FastNoise.CubicLerp(FastNoise.ValCoord2D(seed, x0, y1), FastNoise.ValCoord2D(seed, x1, y1), FastNoise.ValCoord2D(seed, x2, y1), FastNoise.ValCoord2D(seed, x3, y1), xs), FastNoise.CubicLerp(FastNoise.ValCoord2D(seed, x0, y2), FastNoise.ValCoord2D(seed, x1, y2), FastNoise.ValCoord2D(seed, x2, y2), FastNoise.ValCoord2D(seed, x3, y2), xs), FastNoise.CubicLerp(FastNoise.ValCoord2D(seed, x0, y3), FastNoise.ValCoord2D(seed, x1, y3), FastNoise.ValCoord2D(seed, x2, y3), FastNoise.ValCoord2D(seed, x3, y3), xs), ys) * 0.44444445f;
    }

    public float GetCellular(float x, float y, float z) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        z *= this.m_frequency;
        switch (this.m_cellularReturnType.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return this.SingleCellular(x, y, z);
            }
        }
        return this.SingleCellular2Edge(x, y, z);
    }

    private float SingleCellular(float x, float y, float z) {
        int xr = FastNoise.FastRound(x);
        int yr = FastNoise.FastRound(y);
        int zr = FastNoise.FastRound(z);
        float distance = 999999.0f;
        int xc = 0;
        int yc = 0;
        int zc = 0;
        switch (this.m_cellularDistanceFunction.ordinal()) {
            case 0: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[FastNoise.Hash3D(this.m_seed, xi, yi, zi) & 0xFF];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = vecX * vecX + vecY * vecY + vecZ * vecZ;
                            if (!(newDistance < distance)) continue;
                            distance = newDistance;
                            xc = xi;
                            yc = yi;
                            zc = zi;
                        }
                    }
                }
                break;
            }
            case 1: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[FastNoise.Hash3D(this.m_seed, xi, yi, zi) & 0xFF];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ);
                            if (!(newDistance < distance)) continue;
                            distance = newDistance;
                            xc = xi;
                            yc = yi;
                            zc = zi;
                        }
                    }
                }
                break;
            }
            case 2: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[FastNoise.Hash3D(this.m_seed, xi, yi, zi) & 0xFF];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ) + (vecX * vecX + vecY * vecY + vecZ * vecZ);
                            if (!(newDistance < distance)) continue;
                            distance = newDistance;
                            xc = xi;
                            yc = yi;
                            zc = zi;
                        }
                    }
                }
                break;
            }
        }
        switch (this.m_cellularReturnType.ordinal()) {
            case 0: {
                return FastNoise.ValCoord3D(0, xc, yc, zc);
            }
            case 1: {
                Float3 vec = CELL_3D[FastNoise.Hash3D(this.m_seed, xc, yc, zc) & 0xFF];
                return this.m_cellularNoiseLookup.GetNoise((float)xc + vec.x, (float)yc + vec.y, (float)zc + vec.z);
            }
            case 2: {
                return distance - 1.0f;
            }
        }
        return 0.0f;
    }

    private float SingleCellular2Edge(float x, float y, float z) {
        int xr = FastNoise.FastRound(x);
        int yr = FastNoise.FastRound(y);
        int zr = FastNoise.FastRound(z);
        float distance = 999999.0f;
        float distance2 = 999999.0f;
        switch (this.m_cellularDistanceFunction.ordinal()) {
            case 0: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[FastNoise.Hash3D(this.m_seed, xi, yi, zi) & 0xFF];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = vecX * vecX + vecY * vecY + vecZ * vecZ;
                            distance2 = Math.max(Math.min(distance2, newDistance), distance);
                            distance = Math.min(distance, newDistance);
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[FastNoise.Hash3D(this.m_seed, xi, yi, zi) & 0xFF];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ);
                            distance2 = Math.max(Math.min(distance2, newDistance), distance);
                            distance = Math.min(distance, newDistance);
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        for (int zi = zr - 1; zi <= zr + 1; ++zi) {
                            Float3 vec = CELL_3D[FastNoise.Hash3D(this.m_seed, xi, yi, zi) & 0xFF];
                            float vecX = (float)xi - x + vec.x;
                            float vecY = (float)yi - y + vec.y;
                            float vecZ = (float)zi - z + vec.z;
                            float newDistance = Math.abs(vecX) + Math.abs(vecY) + Math.abs(vecZ) + (vecX * vecX + vecY * vecY + vecZ * vecZ);
                            distance2 = Math.max(Math.min(distance2, newDistance), distance);
                            distance = Math.min(distance, newDistance);
                        }
                    }
                }
                break;
            }
        }
        switch (this.m_cellularReturnType.ordinal()) {
            case 3: {
                return distance2 - 1.0f;
            }
            case 4: {
                return distance2 + distance - 1.0f;
            }
            case 5: {
                return distance2 - distance - 1.0f;
            }
            case 6: {
                return distance2 * distance - 1.0f;
            }
            case 7: {
                return distance / distance2 - 1.0f;
            }
        }
        return 0.0f;
    }

    public float GetCellular(float x, float y) {
        x *= this.m_frequency;
        y *= this.m_frequency;
        switch (this.m_cellularReturnType.ordinal()) {
            case 0: 
            case 1: 
            case 2: {
                return this.SingleCellular(x, y);
            }
        }
        return this.SingleCellular2Edge(x, y);
    }

    private float SingleCellular(float x, float y) {
        int xr = FastNoise.FastRound(x);
        int yr = FastNoise.FastRound(y);
        float distance = 999999.0f;
        int xc = 0;
        int yc = 0;
        switch (this.m_cellularDistanceFunction.ordinal()) {
            default: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[FastNoise.Hash2D(this.m_seed, xi, yi) & 0xFF];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = vecX * vecX + vecY * vecY;
                        if (!(newDistance < distance)) continue;
                        distance = newDistance;
                        xc = xi;
                        yc = yi;
                    }
                }
                break;
            }
            case 1: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[FastNoise.Hash2D(this.m_seed, xi, yi) & 0xFF];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = Math.abs(vecX) + Math.abs(vecY);
                        if (!(newDistance < distance)) continue;
                        distance = newDistance;
                        xc = xi;
                        yc = yi;
                    }
                }
                break;
            }
            case 2: {
                int xi;
                for (xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[FastNoise.Hash2D(this.m_seed, xi, yi) & 0xFF];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = Math.abs(vecX) + Math.abs(vecY) + (vecX * vecX + vecY * vecY);
                        if (!(newDistance < distance)) continue;
                        distance = newDistance;
                        xc = xi;
                        yc = yi;
                    }
                }
            }
        }
        switch (this.m_cellularReturnType.ordinal()) {
            case 0: {
                return FastNoise.ValCoord2D(0, xc, yc);
            }
            case 1: {
                Float2 vec = CELL_2D[FastNoise.Hash2D(this.m_seed, xc, yc) & 0xFF];
                return this.m_cellularNoiseLookup.GetNoise((float)xc + vec.x, (float)yc + vec.y);
            }
            case 2: {
                return distance - 1.0f;
            }
        }
        return 0.0f;
    }

    private float SingleCellular2Edge(float x, float y) {
        int xr = FastNoise.FastRound(x);
        int yr = FastNoise.FastRound(y);
        float distance = 999999.0f;
        float distance2 = 999999.0f;
        switch (this.m_cellularDistanceFunction.ordinal()) {
            default: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[FastNoise.Hash2D(this.m_seed, xi, yi) & 0xFF];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = vecX * vecX + vecY * vecY;
                        distance2 = Math.max(Math.min(distance2, newDistance), distance);
                        distance = Math.min(distance, newDistance);
                    }
                }
                break;
            }
            case 1: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[FastNoise.Hash2D(this.m_seed, xi, yi) & 0xFF];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = Math.abs(vecX) + Math.abs(vecY);
                        distance2 = Math.max(Math.min(distance2, newDistance), distance);
                        distance = Math.min(distance, newDistance);
                    }
                }
                break;
            }
            case 2: {
                for (int xi = xr - 1; xi <= xr + 1; ++xi) {
                    for (int yi = yr - 1; yi <= yr + 1; ++yi) {
                        Float2 vec = CELL_2D[FastNoise.Hash2D(this.m_seed, xi, yi) & 0xFF];
                        float vecX = (float)xi - x + vec.x;
                        float vecY = (float)yi - y + vec.y;
                        float newDistance = Math.abs(vecX) + Math.abs(vecY) + (vecX * vecX + vecY * vecY);
                        distance2 = Math.max(Math.min(distance2, newDistance), distance);
                        distance = Math.min(distance, newDistance);
                    }
                }
            }
        }
        switch (this.m_cellularReturnType.ordinal()) {
            case 3: {
                return distance2 - 1.0f;
            }
            case 4: {
                return distance2 + distance - 1.0f;
            }
            case 5: {
                return distance2 - distance - 1.0f;
            }
            case 6: {
                return distance2 * distance - 1.0f;
            }
            case 7: {
                return distance / distance2 - 1.0f;
            }
        }
        return 0.0f;
    }

    public void GradientPerturb(GVector3f v3) {
        this.SingleGradientPerturb(this.m_seed, this.m_gradientPerturbAmp, this.m_frequency, v3);
    }

    public void GradientPerturbFractal(GVector3f v3) {
        int seed = this.m_seed;
        float amp = this.m_gradientPerturbAmp * this.m_fractalBounding;
        float freq = this.m_frequency;
        this.SingleGradientPerturb(seed, amp, this.m_frequency, v3);
        for (int i = 1; i < this.m_octaves; ++i) {
            this.SingleGradientPerturb(++seed, amp *= this.m_gain, freq *= this.m_lacunarity, v3);
        }
    }

    private void SingleGradientPerturb(int seed, float perturbAmp, float frequency, GVector3f v3) {
        float ys;
        float xs;
        float xf = v3.x * frequency;
        float yf = v3.y * frequency;
        float zf = v3.z * frequency;
        int x0 = FastNoise.FastFloor(xf);
        int y0 = FastNoise.FastFloor(yf);
        int z0 = FastNoise.FastFloor(zf);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        int z1 = z0 + 1;
        float zs = switch (this.m_interp.ordinal()) {
            default -> {
                xs = xf - (float)x0;
                ys = yf - (float)y0;
                yield zf - (float)z0;
            }
            case 1 -> {
                xs = FastNoise.InterpHermiteFunc(xf - (float)x0);
                ys = FastNoise.InterpHermiteFunc(yf - (float)y0);
                yield FastNoise.InterpHermiteFunc(zf - (float)z0);
            }
            case 2 -> {
                xs = FastNoise.InterpQuinticFunc(xf - (float)x0);
                ys = FastNoise.InterpQuinticFunc(yf - (float)y0);
                yield FastNoise.InterpQuinticFunc(zf - (float)z0);
            }
        };
        Float3 vec0 = CELL_3D[FastNoise.Hash3D(seed, x0, y0, z0) & 0xFF];
        Float3 vec1 = CELL_3D[FastNoise.Hash3D(seed, x1, y0, z0) & 0xFF];
        float lx0x = FastNoise.Lerp(vec0.x, vec1.x, xs);
        float ly0x = FastNoise.Lerp(vec0.y, vec1.y, xs);
        float lz0x = FastNoise.Lerp(vec0.z, vec1.z, xs);
        vec0 = CELL_3D[FastNoise.Hash3D(seed, x0, y1, z0) & 0xFF];
        vec1 = CELL_3D[FastNoise.Hash3D(seed, x1, y1, z0) & 0xFF];
        float lx1x = FastNoise.Lerp(vec0.x, vec1.x, xs);
        float ly1x = FastNoise.Lerp(vec0.y, vec1.y, xs);
        float lz1x = FastNoise.Lerp(vec0.z, vec1.z, xs);
        float lx0y = FastNoise.Lerp(lx0x, lx1x, ys);
        float ly0y = FastNoise.Lerp(ly0x, ly1x, ys);
        float lz0y = FastNoise.Lerp(lz0x, lz1x, ys);
        vec0 = CELL_3D[FastNoise.Hash3D(seed, x0, y0, z1) & 0xFF];
        vec1 = CELL_3D[FastNoise.Hash3D(seed, x1, y0, z1) & 0xFF];
        lx0x = FastNoise.Lerp(vec0.x, vec1.x, xs);
        ly0x = FastNoise.Lerp(vec0.y, vec1.y, xs);
        lz0x = FastNoise.Lerp(vec0.z, vec1.z, xs);
        vec0 = CELL_3D[FastNoise.Hash3D(seed, x0, y1, z1) & 0xFF];
        vec1 = CELL_3D[FastNoise.Hash3D(seed, x1, y1, z1) & 0xFF];
        lx1x = FastNoise.Lerp(vec0.x, vec1.x, xs);
        ly1x = FastNoise.Lerp(vec0.y, vec1.y, xs);
        lz1x = FastNoise.Lerp(vec0.z, vec1.z, xs);
        v3.x += FastNoise.Lerp(lx0y, FastNoise.Lerp(lx0x, lx1x, ys), zs) * perturbAmp;
        v3.y += FastNoise.Lerp(ly0y, FastNoise.Lerp(ly0x, ly1x, ys), zs) * perturbAmp;
        v3.z += FastNoise.Lerp(lz0y, FastNoise.Lerp(lz0x, lz1x, ys), zs) * perturbAmp;
    }

    public void GradientPerturb(GVector2f v2) {
        this.SingleGradientPerturb(this.m_seed, this.m_gradientPerturbAmp, this.m_frequency, v2);
    }

    public void GradientPerturbFractal(GVector2f v2) {
        int seed = this.m_seed;
        float amp = this.m_gradientPerturbAmp * this.m_fractalBounding;
        float freq = this.m_frequency;
        this.SingleGradientPerturb(seed, amp, this.m_frequency, v2);
        for (int i = 1; i < this.m_octaves; ++i) {
            this.SingleGradientPerturb(++seed, amp *= this.m_gain, freq *= this.m_lacunarity, v2);
        }
    }

    private void SingleGradientPerturb(int seed, float perturbAmp, float frequency, GVector2f v2) {
        float xs;
        float xf = v2.x * frequency;
        float yf = v2.y * frequency;
        int x0 = FastNoise.FastFloor(xf);
        int y0 = FastNoise.FastFloor(yf);
        int x1 = x0 + 1;
        int y1 = y0 + 1;
        float ys = switch (this.m_interp.ordinal()) {
            default -> {
                xs = xf - (float)x0;
                yield yf - (float)y0;
            }
            case 1 -> {
                xs = FastNoise.InterpHermiteFunc(xf - (float)x0);
                yield FastNoise.InterpHermiteFunc(yf - (float)y0);
            }
            case 2 -> {
                xs = FastNoise.InterpQuinticFunc(xf - (float)x0);
                yield FastNoise.InterpQuinticFunc(yf - (float)y0);
            }
        };
        Float2 vec0 = CELL_2D[FastNoise.Hash2D(seed, x0, y0) & 0xFF];
        Float2 vec1 = CELL_2D[FastNoise.Hash2D(seed, x1, y0) & 0xFF];
        float lx0x = FastNoise.Lerp(vec0.x, vec1.x, xs);
        float ly0x = FastNoise.Lerp(vec0.y, vec1.y, xs);
        vec0 = CELL_2D[FastNoise.Hash2D(seed, x0, y1) & 0xFF];
        vec1 = CELL_2D[FastNoise.Hash2D(seed, x1, y1) & 0xFF];
        float lx1x = FastNoise.Lerp(vec0.x, vec1.x, xs);
        float ly1x = FastNoise.Lerp(vec0.y, vec1.y, xs);
        v2.x += FastNoise.Lerp(lx0x, lx1x, ys) * perturbAmp;
        v2.y += FastNoise.Lerp(ly0x, ly1x, ys) * perturbAmp;
    }

    public static enum Interp {
        Linear,
        Hermite,
        Quintic;

    }

    public static enum NoiseType {
        Value,
        ValueFractal,
        Perlin,
        PerlinFractal,
        Simplex,
        SimplexFractal,
        Cellular,
        WhiteNoise,
        Cubic,
        CubicFractal;

    }

    public static enum FractalType {
        FBM,
        Billow,
        RigidMulti;

    }

    public static enum CellularDistanceFunction {
        Euclidean,
        Manhattan,
        Natural;

    }

    public static enum CellularReturnType {
        CellValue,
        NoiseLookup,
        Distance,
        Distance2,
        Distance2Add,
        Distance2Sub,
        Distance2Mul,
        Distance2Div;

    }

    private static class Float2 {
        public final float x;
        public final float y;

        public Float2(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    private static class Float3 {
        public final float x;
        public final float y;
        public final float z;

        public Float3(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

