/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.NetherVines;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.orcinus.galosphere.api.Cordyceps;
import net.orcinus.galosphere.blocks.blockentities.CordycepsBlockEntity;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import org.jetbrains.annotations.Nullable;

public class CordycepsBlock
extends GrowingPlantHeadBlock
implements EntityBlock,
Cordyceps {
    public static final MapCodec<CordycepsBlock> CODEC = CordycepsBlock.simpleCodec(CordycepsBlock::new);
    public static final BooleanProperty BULB = BooleanProperty.create((String)"bulb");
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0);
    protected static final VoxelShape BULB_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);

    public CordycepsBlock(BlockBehaviour.Properties properties) {
        super(properties, Direction.UP, SHAPE, false, 0.2);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)BULB, (Comparable)Boolean.valueOf(false))).setValue((Property)ALIVE, (Comparable)Boolean.valueOf(false))).setValue((Property)ALIVE_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends GrowingPlantHeadBlock> codec() {
        return CODEC;
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockState belowState = levelReader.getBlockState(blockPos.below());
        if (belowState.hasProperty((Property)ALIVE) && ((Boolean)belowState.getValue((Property)ALIVE)).booleanValue() && belowState.is((Block)this.getHeadBlock())) {
            return false;
        }
        return super.canSurvive(blockState, levelReader, blockPos);
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.getValue((Property)BULB) != false ? BULB_SHAPE : super.getShape(blockState, blockGetter, blockPos, collisionContext);
    }

    protected BlockState getGrowIntoState(BlockState blockState, RandomSource randomSource) {
        return (BlockState)super.getGrowIntoState(blockState, randomSource).setValue((Property)BULB, (Comparable)Boolean.valueOf((Boolean)blockState.getValue((Property)BULB) != false || (Boolean)blockState.getValue((Property)ALIVE) == false && randomSource.nextFloat() < 0.11f));
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        BlockPos blockPos2 = blockPos.relative(this.growthDirection);
        int i = Math.min((Integer)blockState.getValue((Property)AGE) + 1, 25);
        if (((Boolean)blockState.getValue((Property)BULB)).booleanValue()) {
            serverLevel.setBlockAndUpdate(blockPos2, (BlockState)blockState.setValue((Property)AGE, (Comparable)Integer.valueOf(i)));
        } else {
            serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)BULB, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return (Boolean)blockState.getValue((Property)ALIVE) == false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BULB, ALIVE, ALIVE_STAGE});
    }

    public SoundType getSoundType(BlockState state) {
        return this.soundType;
    }

    protected int getBlocksToGrowWhenBonemealed(RandomSource randomSource) {
        return NetherVines.getBlocksToGrowWhenBonemealed((RandomSource)randomSource);
    }

    protected Block getBodyBlock() {
        return (Block)GBlocks.LICHEN_CORDYCEPS_PLANT.get();
    }

    protected boolean canGrowInto(BlockState blockState) {
        return NetherVines.isValidGrowthState((BlockState)blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState blockState, BlockEntityType<T> type) {
        return world.isClientSide ? null : (type == GBlockEntityTypes.CORDYCEPS.get() ? (level, pos, state, te) -> CordycepsBlockEntity.serverTick(level, pos, state, (CordycepsBlockEntity)te) : null);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CordycepsBlockEntity(blockPos, blockState);
    }
}

