/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class LichenMossBlock
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public LichenMossBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void stepOn(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (!(entity.isSteppingCarefully() || ((Boolean)blockState.getValue((Property)LIT)).booleanValue() || level.isClientSide)) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
            level.scheduleTick(blockPos, (Block)this, 100);
        }
        super.stepOn(level, blockPos, blockState, entity);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (level.isClientSide) {
            return;
        }
        boolean bl2 = (Boolean)state.getValue((Property)LIT);
        if (bl2 != level.hasNeighborSignal(pos)) {
            if (bl2) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource randomSource) {
        boolean flag1;
        boolean flag = serverLevel.getEntitiesOfClass(Entity.class, new AABB(pos.above())).isEmpty();
        boolean bl = flag1 = (Boolean)state.getValue((Property)LIT) != false && !serverLevel.hasNeighborSignal(pos) && flag;
        if (flag1) {
            serverLevel.setBlock(pos, (BlockState)state.cycle((Property)LIT), 2);
        } else {
            serverLevel.scheduleTick(pos, (Block)this, 40);
        }
    }

    public boolean isRandomlyTicking(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)LIT);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LIT});
    }

    public float getShadeBrightness(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 1.0f;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(blockPlaceContext.getLevel().hasNeighborSignal(blockPlaceContext.getClickedPos())));
    }
}

