/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class BerserkerSlamShockwave
extends TextureSheetParticle {
    private final SpriteSet sprites;

    public BerserkerSlamShockwave(ClientLevel clientLevel, double d, double e, double f, SpriteSet sprites) {
        super(clientLevel, d, e, f);
        this.alpha = 1.0f;
        this.quadSize = 1.0f;
        this.lifetime = 80;
        this.rCol = 1.0f;
        this.gCol = 1.0f;
        this.bCol = 1.0f;
        this.sprites = sprites;
        this.setSpriteFromAge(this.sprites);
    }

    public void tick() {
        this.quadSize = Mth.lerp((float)(this.quadSize >= 6.0f ? 0.05f : 0.25f), (float)this.quadSize, (float)10.0f);
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.alpha = Mth.lerp((float)(this.quadSize >= 6.0f ? 0.15f : 0.025f), (float)this.alpha, (float)0.0f);
        }
        if (this.alpha <= 0.01f) {
            this.remove();
        }
        this.setSpriteFromAge(this.sprites);
    }

    public void render(VertexConsumer consumer, Camera camera, float delta) {
        this.renderRotatedQuad(consumer, camera, Axis.XP.rotation(1.5707964f), delta);
        this.renderRotatedQuad(consumer, camera, Axis.XN.rotation(1.5707964f), delta);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected int getLightColor(float tint) {
        return Math.max(50, super.getLightColor(tint));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType particleOptions, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            return new BerserkerSlamShockwave(clientLevel, d, e, f, this.sprites);
        }
    }
}

