/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HoveringAshParticle
extends SimpleAnimatedParticle {
    private final SpriteSet sprites;

    public HoveringAshParticle(ClientLevel clientLevel, double d, double e, double f, double g, double h, double i, SpriteSet spriteSet) {
        super(clientLevel, d, e, f, spriteSet, -0.1f);
        this.xd = g;
        this.yd = h;
        this.zd = i;
        this.sprites = spriteSet;
        this.hasPhysics = false;
        this.lifetime = (int)(50.0 / (Math.random() * 0.8 + 0.2));
        this.quadSize = 0.2f;
        this.xd = g;
        this.yd = h;
        this.zd = i;
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        super.tick();
        BlockPos blockPos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.getBlockState(blockPos).isCollisionShapeFullBlock((BlockGetter)this.level, blockPos)) {
            this.remove();
        }
        this.setSpriteFromAge(this.sprites);
    }

    public int getLightColor(float f) {
        BlockPos blockPos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        return this.level.hasChunkAt(blockPos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)blockPos) : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType p_106566_, ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new HoveringAshParticle(world, x, y, z, velocityX, velocityY, velocityZ, this.sprites);
        }
    }
}

