/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.particles;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SmokeParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.api.Spectatable;

@OnlyIn(value=Dist.CLIENT)
public class SpectateOrbParticle
extends SmokeParticle {
    protected SpectateOrbParticle(ClientLevel clientLevel, double d, double e, double f, double g, double h, double i, SpriteSet spriteSet) {
        super(clientLevel, d, e, f, g, h, i, 2.5f, spriteSet);
        if (this.isPlayerSpectating()) {
            this.setAlpha(0.0f);
        }
    }

    protected int getLightColor(float p_107249_) {
        return 240;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.oRoll = this.roll;
        this.roll += 0.05f + this.random.nextFloat() / 10.0f;
        if (this.isPlayerSpectating()) {
            this.setAlpha(0.0f);
        }
    }

    public boolean isPlayerSpectating() {
        Minecraft minecraft = Minecraft.getInstance();
        return minecraft.getCameraEntity() instanceof Spectatable && minecraft.options.getCameraType().isFirstPerson();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public Provider(SpriteSet spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(SimpleParticleType particleOptions, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            SpectateOrbParticle particle = new SpectateOrbParticle(clientLevel, d, e, f, g, h, i, this.sprite);
            particle.setColor(1.0f, 1.0f, 1.0f);
            return particle;
        }
    }
}

