/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.model.MoleModel;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GModelLayers;

@OnlyIn(value=Dist.CLIENT)
public class MoleRenderer
extends MobRenderer<Mole, MoleModel> {
    private static final ResourceLocation TEXTURE = Galosphere.id("textures/entity/mole/mole.png");

    public MoleRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MoleModel(context.bakeLayer(GModelLayers.MOLE)), 0.6f);
    }

    public ResourceLocation getTextureLocation(Mole mole) {
        return TEXTURE;
    }

    public void render(Mole entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        float size = entity.isBaby() ? 0.5f : 1.0f;
        poseStack.scale(size, size, size);
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        poseStack.popPose();
    }
}

