/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.items.components.SterlingAttached;

@OnlyIn(value=Dist.CLIENT)
public class BannerLayer<S extends AbstractClientPlayer, M extends HumanoidModel<S>>
extends RenderLayer<S, M> {
    public BannerLayer(RenderLayerParent<S, M> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, S livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack attached;
        ItemStack headStack = livingEntity.getItemBySlot(EquipmentSlot.HEAD);
        SterlingAttached sterlingAttached = (SterlingAttached)headStack.get(GDataComponents.STERLING_ATTACHED.get());
        if (sterlingAttached != null && !(attached = sterlingAttached.attached()).isEmpty()) {
            poseStack.pushPose();
            poseStack.scale(1.0f, 1.0f, 1.0f);
            ((HumanoidModel)this.getParentModel()).getHead().translateAndRotate(poseStack);
            poseStack.translate(0.0, -0.25, 0.0);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.scale(0.625f, -0.625f, -0.625f);
            ClientLevel level = Minecraft.getInstance().level;
            Minecraft.getInstance().getItemRenderer().renderStatic(attached, ItemDisplayContext.HEAD, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, (Level)level, 0);
            poseStack.popPose();
        }
    }
}

