/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.renderer.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.items.components.SterlingAttached;

@OnlyIn(value=Dist.CLIENT)
public class HorseBannerLayer<T extends Horse>
extends RenderLayer<T, HorseModel<T>> {
    public HorseBannerLayer(RenderLayerParent<T, HorseModel<T>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T livingEntity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack attached;
        ItemStack bodyArmor = livingEntity.getBodyArmorItem();
        SterlingAttached sterlingAttached = (SterlingAttached)bodyArmor.get(GDataComponents.STERLING_ATTACHED.get());
        if (bodyArmor.is((Item)GItems.STERLING_HORSE_ARMOR.get()) && sterlingAttached != null && !(attached = sterlingAttached.attached()).isEmpty()) {
            poseStack.pushPose();
            poseStack.scale(1.0f, 1.0f, 1.0f);
            poseStack.translate(0.0, 0.35, 0.3);
            if (livingEntity.getStandAnim(partialTick) > 0.0f) {
                poseStack.translate(0.0, 0.35, 0.35);
            }
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.scale(0.625f, -0.625f, -0.625f);
            ClientLevel level = Minecraft.getInstance().level;
            Minecraft.getInstance().getItemRenderer().renderStatic(attached, ItemDisplayContext.HEAD, packedLight, OverlayTexture.NO_OVERLAY, poseStack, bufferSource, (Level)level, 0);
            poseStack.popPose();
        }
    }
}

