/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GRecipeSerializers;

public class PreservedTransformRecipe
implements SmithingRecipe {
    private final ResourceLocation ID = Galosphere.id("preserved_transform_recipe");
    final Ingredient template;
    final Ingredient base;
    final Ingredient addition;

    public PreservedTransformRecipe(Ingredient template, Ingredient base, Ingredient addition) {
        this.template = template;
        this.base = base;
        this.addition = addition;
    }

    public boolean isTemplateIngredient(ItemStack itemStack) {
        return this.template.test(itemStack);
    }

    public boolean isBaseIngredient(ItemStack itemStack) {
        return this.base.test(itemStack);
    }

    public boolean isAdditionIngredient(ItemStack itemStack) {
        return this.addition.test(itemStack);
    }

    public boolean matches(SmithingRecipeInput recipeInput, Level level) {
        boolean templateIngredient = this.isTemplateIngredient(recipeInput.getItem(0));
        boolean baseIngredient = this.isBaseIngredient(recipeInput.getItem(1));
        boolean additionIngredient = this.isAdditionIngredient(recipeInput.getItem(2));
        return templateIngredient && baseIngredient && additionIngredient;
    }

    public ItemStack assemble(SmithingRecipeInput recipeInput, HolderLookup.Provider provider) {
        ItemStack stack = recipeInput.getItem(1).copy();
        stack.set(GDataComponents.PRESERVED.get(), (Object)true);
        return stack;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)Items.IRON_INGOT);
    }

    public RecipeSerializer<?> getSerializer() {
        return GRecipeSerializers.PRESERVED_TRANSFORM.get();
    }

    public boolean isIncomplete() {
        return false;
    }

    public static class Serializer
    implements RecipeSerializer<PreservedTransformRecipe> {
        private static final MapCodec<PreservedTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("template").forGetter(recipe -> recipe.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(recipe -> recipe.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(recipe -> recipe.addition)).apply((Applicative)instance, PreservedTransformRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, PreservedTransformRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, smithingTrimRecipe -> smithingTrimRecipe.template, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, smithingTrimRecipe -> smithingTrimRecipe.base, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, smithingTrimRecipe -> smithingTrimRecipe.addition, PreservedTransformRecipe::new);

        public MapCodec<PreservedTransformRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, PreservedTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

