/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.datagen;

import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.orcinus.galosphere.init.GBiomes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEnchantments;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMobEffects;
import net.orcinus.galosphere.init.GPotions;
import net.orcinus.galosphere.init.GTrimPatterns;
import net.orcinus.galosphere.items.EchoBellItem;
import net.orcinus.galosphere.items.MonstrometerItem;

public class GLanguageProvider
extends LanguageProvider {
    public GLanguageProvider(PackOutput output) {
        super(output, "galosphere", "en_us");
    }

    protected void addTranslations() {
        GBiomes.BIOMES.stream().map(ResourceKey::location).map(ResourceLocation::getPath).forEach(s -> this.add("biome.galosphere." + s, this.reformat((String)s)));
        GBlocks.BLOCKS.getEntries().stream().map(DeferredHolder::get).forEach(block -> this.add((Block)block, this.reformat(BuiltInRegistries.BLOCK.getKey(block).getPath())));
        GItems.ITEMS.getEntries().stream().map(DeferredHolder::get).filter(Predicate.not(BlockItem.class::isInstance)).forEach(item -> this.add((Item)item, this.reformat(BuiltInRegistries.ITEM.getKey(item).getPath())));
        this.add((Item)GItems.LICHEN_CORDYCEPS.get(), this.reformat(BuiltInRegistries.ITEM.getKey((Object)((Item)GItems.LICHEN_CORDYCEPS.get())).getPath()));
        GEntityTypes.ENTITY_TYPES.getEntries().stream().map(DeferredHolder::get).forEach(entityType -> this.add((EntityType)entityType, this.reformat(BuiltInRegistries.ENTITY_TYPE.getKey(entityType).getPath())));
        GMobEffects.MOB_EFFECTS.getEntries().stream().map(DeferredHolder::get).forEach(mobEffect -> this.add((MobEffect)mobEffect, this.reformat(BuiltInRegistries.MOB_EFFECT.getKey(mobEffect).getPath())));
        GEnchantments.ENCHANTMENTS.keySet().forEach(resourceLocation -> this.add("enchantment.galosphere." + resourceLocation.getPath(), this.reformat(resourceLocation.getPath())));
        GTrimPatterns.TRIM_PATTERNS.stream().map(ResourceKey::location).forEach(holder -> this.add("trim_pattern.galosphere." + holder.getPath(), this.reformat(holder.getPath()) + " Armor Trim"));
        GPotions.POTIONS.getEntries().stream().map(DeferredHolder::get).forEach(potion -> this.add(potion.toString(), this.reformat(BuiltInRegistries.POTION.getKey(potion).getPath())));
        this.add("item.minecraft.potion.effect.haste", "Potion of Haste");
        this.add("item.minecraft.splash_potion.effect.haste", "Splash Potion of Haste");
        this.add("item.minecraft.lingering_potion.effect.haste", "Lingering Potion of Haste");
        this.add("item.minecraft.tipped_arrow.effect.haste", "Arrow of Haste");
        this.add("item.minecraft.tipped_arrow.effect.astral", "Arrow of Astral");
        this.add("item.galosphere.preserved", "Preserved");
        this.add("item.galosphere.silver_bomb.duration", "Duration");
        this.add("item.galosphere.silver_bomb.explosion", "Explosion");
        this.add("item.galosphere.silver_bomb.bouncy", "Bouncy");
        this.add("subtitles.block.lumiere.compost", "Composter filled with Lumiere Shard");
        this.add("subtitles.entity.specterpillar.death", "Specterpillar dies");
        this.add("subtitles.entity.specterpillar.hurt", "Specterpillar hurts");
        this.add("subtitles.entity.spectre.ambient", "Spectre chirps");
        this.add("subtitles.entity.spectre.death", "Spectre dies");
        this.add("subtitles.entity.spectre.hurt", "Spectre hurts");
        this.add("subtitles.entity.spectre.lock_to_spyglass", "Spyglass locks to Spectre");
        this.add("subtitles.entity.spectre.receive_item", "Spectre receives Item");
        this.add("subtitles.entity.berserker.shake", "Berserker shakes");
        this.add("subtitles.entity.berserker.roar", "Berserker roars");
        this.add("subtitles.entity.berserker.idle", "Berserker grunts");
        this.add("subtitles.entity.berserker.smash", "Berserker smashes");
        this.add("subtitles.entity.berserker.step", "Berserker steps");
        this.add("subtitles.entity.berserker.hurt", "Berserker hurts");
        this.add("subtitles.entity.berserker.death", "Berserker dies");
        this.add("subtitles.entity.berserker.summoning", "Berserker summons");
        this.add("subtitles.entity.berserker.punch", "Berserker hits");
        this.add("subtitles.entity.preserved.death", "Preserved dies");
        this.add("subtitles.entity.preserved.idle", "Preserved groans");
        this.add("subtitles.entity.preserved.hurt", "Preserved hurts");
        this.add("subtitles.entity.preserved.emerge", "Preserved emerges");
        this.add("subtitles.entity.pink_salt_pillar.emerge", "Pink Salt Pillar pierces");
        this.add("subtitles.entity.pink_salt_shard.land", "Pink Salt Shard lands");
        this.add("subtitles.item.saltbound_tablet.prepare_attack", "Saltbound Tablet charges up");
        this.add("subtitles.item.saltbound_tablet.cast_attack", "Saltbound Tablet fires");
        this.add("subtitles.item.saltbound_tablet.cooldown_over", "Saltbound Tablet recharged");
        this.add("galosphere.midnightconfig.title", "Galosphere Config");
        this.add("galosphere.midnightconfig.slowBuddingAmethystDestroySpeed", "Slowed Budding Amethyst Destroy Speed");
        this.add("galosphere.midnightconfig.pillagerDropSilverIngot", "Pillager Drop Silver Ingots");
        this.add("galosphere.midnightconfig.spectreFlareAncientCityLoot", "Spectre Flares spawn in Ancient City chest loot");
        this.add("advancements.galosphere.light_spread.title", "Spread the Light!");
        this.add("advancements.galosphere.light_spread.description", "Use a Glow Flare");
        this.add("advancements.galosphere.lumiere_compost.title", "Fragility of Light");
        this.add("advancements.galosphere.lumiere_compost.description", "Create a Glowstone Dust by composting a Lumiere Shard");
        this.add("advancements.galosphere.coarse_dirt_compost.title", "Saline Solution");
        this.add("advancements.galosphere.coarse_dirt_compost.description", "Create a Coarse Dirt by composting a Pink Salt Shard");
        this.add("advancements.galosphere.sterling_armor.title", "Looking Good, Partner!");
        this.add("advancements.galosphere.sterling_armor.description", "Get a full suit of Sterling Armor");
        this.add("advancements.galosphere.use_spectre_flare.title", "I spy with my little eye");
        this.add("advancements.galosphere.use_spectre_flare.description", "Use a Spectre Flare");
        this.add("advancements.galosphere.warped_teleport.title", "What is this Place?");
        this.add("advancements.galosphere.warped_teleport.description", "Teleport with a Burrow Anchor");
        this.add("advancements.galosphere.find_pink_salt_shrine.title", "Peaceful Revolution");
        this.add("advancements.galosphere.find_pink_salt_shrine.description", "Enter a Pink Salt Shrine");
        this.add("advancements.galosphere.find_forgotten_ruins.title", "Stony Encounter");
        this.add("advancements.galosphere.find_forgotten_ruins.description", "Step foot in a Forgotten Ruins");
        this.add("advancements.galosphere.summon_berserker.title", "Reign of Terror");
        this.add("advancements.galosphere.summon_berserker.description", "Summon the Berserker");
        this.add("advancements.galosphere.saltbound_kill_evoker.title", "Finally a Worthy Opponent");
        this.add("advancements.galosphere.saltbound_kill_evoker.description", "Kill an Evoker with a Saltbound Tablet");
        this.add("advancements.galosphere.questful.title", "Questful");
        this.add("advancements.galosphere.questful.description", "Insert a Mining Pouch into a Mole Burrow");
        this.add("advancements.galosphere.opalising.title", "Oh...pal?");
        this.add("advancements.galosphere.opalising.description", "Turn saplings into Opal Saplings");
        this.add("advancements.galosphere.rebrushing.title", "Rebrushing");
        this.add("advancements.galosphere.rebrushing.description", "Re-brush a Suspicious Block");
        this.add("advancements.galosphere.attached_sterling.title", "Looking Good Partner!");
        this.add("advancements.galosphere.attached_sterling.description", "Attach a banner to a Sterling Helmet");
        this.add("advancements.galosphere.attached_sterling_horse.title", "Fancy Seeing You Here!");
        this.add("advancements.galosphere.attached_sterling_horse.description", "Give a Sterling Armor with Banner to a Horse");
        this.add("advancements.galosphere.light_the_way.title", "Light the Way!");
        this.add("advancements.galosphere.light_the_way.description", "Walk on a Lichen Moss");
        this.add("advancements.galosphere.edible_air.title", "Edible Air");
        this.add("advancements.galosphere.edible_air.description", "Eat a Lichen Cordyceps under water");
        this.add("advancements.galosphere.watchfly.title", "Watchfly?");
        this.add("advancements.galosphere.watchfly.description", "Catch a Spectre in a Bottle");
        this.add("advancements.galosphere.eye_for_eye.title", "Eye for an Eye");
        this.add("advancements.galosphere.eye_for_eye.description", "Use a Spyglass on an Allurite-Bounded Spectre");
        this.add("attribute.name.generic.illager_resistance", "Illager Resistance");
        this.add("item.minecraft.potion.effect.astral", "Potion of Astral");
        this.add("item.minecraft.splash_potion.effect.astral", "Splash Potion of Astral");
        this.add("item.minecraft.lingering_potion.effect.astral", "Lingering Potion of Astral");
        this.add("item.minecraft.lingering_potion.tipped_arrow.astral", "Arrow of Astral");
        this.add("itemGroup.galosphere.galosphere", "Galosphere");
        this.add("upgrade.galosphere.silver_upgrade", "Silver Upgrade");
        this.add("item.galosphere.smithing_template.silver_upgrade.applies_to", "Leather Equipment");
        this.add("item.galosphere.smithing_template.silver_upgrade.ingredients", "Silver Ingot");
        this.add("item.galosphere.smithing_template.silver_upgrade.base_slot_description", "Add Leather Armor");
        this.add("item.galosphere.smithing_template.silver_upgrade.additions_slot_description", "Add Silver Ingot");
        this.add("upgrade.galosphere.preserved_upgrade", "Preserved Upgrade");
        this.add("item.galosphere.smithing_template.preserved_upgrade.applies_to", "All items");
        this.add("item.galosphere.smithing_template.preserved_upgrade.ingredients", "Pink Salt Shard");
        this.add("item.galosphere.smithing_template.preserved_upgrade.base_slot_description", "Add an item");
        this.add("item.galosphere.smithing_template.preserved_upgrade.additions_slot_description", "Add Pink Salt Shard");
        this.add("container.galosphere.combustion_table", "Combustion Table");
        this.add("item.galosphere.sterling_helmet.empty.description", "Can hold a banner");
        this.add("filled_map.galosphere.ancient_city", "Ancient City Explorer Map");
        this.add("filled_map.galosphere.forgotten_ruins", "Forgotten Ruins Explorer Map");
        this.add(EchoBellItem.INSERT_FUEL.getString(), "Insert Allurite Shard");
        this.add(MonstrometerItem.INSERT_FUEL.getString(), "Insert Lumiere Shard");
    }

    private String reformat(String id) {
        char[] buffer = id.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            boolean flag1;
            boolean bl = flag1 = i > 0 && String.valueOf(buffer[i - 1]).equals("_");
            if (i != 0 && !flag1) continue;
            buffer[i] = Character.toUpperCase(buffer[i]);
            if (!flag1) continue;
            buffer[i - 1] = 32;
        }
        return new String(buffer);
    }
}

