/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.DripstoneUtils;
import net.minecraft.world.phys.BlockHitResult;
import net.orcinus.galosphere.blocks.GlowInkClumpsBlock;
import net.orcinus.galosphere.entities.ThrowableLaunchedProjectile;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class GlowFlare
extends ThrowableLaunchedProjectile {
    public GlowFlare(EntityType<? extends GlowFlare> type, Level world) {
        super(type, world);
    }

    public GlowFlare(Level world, ItemStack stack, Entity entity, double x, double y, double z, boolean shotAtAngle) {
        super(world, stack, entity, x, y, z, shotAtAngle);
        this.setOwner(entity);
    }

    public GlowFlare(Level world, double x, double y, double z) {
        super(GEntityTypes.GLOW_FLARE.get(), world);
        this.setPos(x, y, z);
        this.entityData.set(THROWN, (Object)true);
    }

    public GlowFlare(Level level, @Nullable Entity entity, ItemStack itemStack) {
        super(GEntityTypes.GLOW_FLARE.get(), level);
        this.entityData.set(DATA_ID_FIREWORKS_ITEM, (Object)itemStack.copy());
        this.entityData.set(THROWN, (Object)true);
        this.setOwner(entity);
    }

    @Override
    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide && this.life % 2 < 2) {
            world.addParticle((ParticleOptions)ParticleTypes.GLOW, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.05, -this.getDeltaMovement().y * 0.5, this.random.nextGaussian() * 0.05);
        }
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)GItems.GLOW_FLARE.get();
    }

    protected void onHitBlock(BlockHitResult result) {
        Level world = this.level();
        if (!world.isClientSide()) {
            BlockPos hitPos = result.getBlockPos();
            BlockPos placePos = hitPos.relative(result.getDirection());
            if (world.getBlockState(hitPos).isCollisionShapeFullBlock((BlockGetter)world, hitPos) && (world.getBlockState(placePos).canBeReplaced() && !world.getFluidState(placePos).is(FluidTags.LAVA) || world.isStateAtPosition(placePos, DripstoneUtils::isEmptyOrWater))) {
                world.setBlock(placePos, (BlockState)((BlockState)((BlockState)((Block)GBlocks.GLOW_INK_CLUMPS.get()).defaultBlockState().setValue((Property)GlowInkClumpsBlock.getFaceProperty((Direction)result.getDirection().getOpposite()), (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.AGE_15, (Comparable)Integer.valueOf(15))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(world.getBlockState(placePos).is(Blocks.WATER))), 2);
            }
            this.playSound(GSoundEvents.GLOW_FLARE_SPREAD.get(), 1.0f, 1.0f);
            this.discard();
        }
    }
}

