/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GParticleTypes;
import org.joml.Vector3fc;

public class PalladiumBomb
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Integer> TIME = SynchedEntityData.defineId(PalladiumBomb.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LAST_DURATION = SynchedEntityData.defineId(PalladiumBomb.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean shrapnel;
    private int duration;
    private int explosion;
    private int bouncy;

    public PalladiumBomb(EntityType<? extends PalladiumBomb> entity, Level world) {
        super(entity, world);
    }

    public PalladiumBomb(Level world, LivingEntity entity, ItemStack stack) {
        super(GEntityTypes.PALLADIUM_BOMB.get(), entity, world);
        this.explosion = (Integer)stack.getOrDefault(GDataComponents.EXPLOSION.get(), (Object)1);
        this.duration = (Integer)stack.getOrDefault(GDataComponents.DURATION.get(), (Object)1);
        this.bouncy = (Integer)stack.getOrDefault(GDataComponents.BOUNCY.get(), (Object)1);
        this.entityData.set(LAST_DURATION, (Object)(this.duration * 20));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TIME, (Object)40);
        builder.define(LAST_DURATION, (Object)0);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setTime(tag.getInt("Time"));
        this.setLastDuration(tag.getInt("LastDuration"));
        this.duration = tag.getInt("Duration");
        this.explosion = tag.getInt("Explosion");
        this.bouncy = tag.getInt("Bouncy");
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("LastDuration", this.getLastDuration());
        tag.putInt("Time", this.getTime());
        tag.putInt("Duration", this.duration);
        tag.putInt("Explosion", this.explosion);
        tag.putInt("Bouncy", this.bouncy);
    }

    public void setTime(int time) {
        this.entityData.set(TIME, (Object)time);
    }

    public int getTime() {
        return (Integer)this.entityData.get(TIME);
    }

    public void setLastDuration(int lastDuration) {
        this.entityData.set(LAST_DURATION, (Object)lastDuration);
    }

    public int getLastDuration() {
        return (Integer)this.entityData.get(LAST_DURATION);
    }

    protected double getDefaultGravity() {
        return 0.05f;
    }

    protected Item getDefaultItem() {
        return (Item)GItems.PALLADIUM_BOMB.get();
    }

    public void tick() {
        super.tick();
        if (!this.isRemoved()) {
            int k;
            int i;
            if (this.level().isClientSide()) {
                SimpleParticleType particle = this.isInWater() ? ParticleTypes.BUBBLE : ParticleTypes.SMOKE;
                this.level().addParticle((ParticleOptions)particle, this.getX(), this.getY() + 0.3, this.getZ(), 0.0, 0.0, 0.0);
            }
            if ((i = this.getTime()) > (k = -this.getLastDuration())) {
                this.setTime(i - 1);
            }
            if (i == k && !this.level().isClientSide()) {
                this.bombExplode();
            }
        }
    }

    protected void onHitEntity(EntityHitResult pResult) {
        if (!this.level().isClientSide()) {
            this.bombExplode();
        }
    }

    private void bombExplode() {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean flag = EventHooks.canEntityGrief((Level)serverLevel, (Entity)this.getOwner());
        this.level().explode((Entity)this, null, new ExplosionDamageCalculator(){

            public boolean shouldBlockExplode(Explosion explosion, BlockGetter world, BlockPos pos, BlockState state, float p_46098_) {
                return PalladiumBomb.this.explosion > 0 && (double)world.getBlockState(pos).getBlock().defaultDestroyTime() < 3.0;
            }
        }, this.getX(), this.getY(), this.getZ(), 2.0f + (float)this.explosion, false, flag ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ItemStack itemstack = this.getItem();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)(itemstack.isEmpty() ? (ParticleOptions)GParticleTypes.PALLADIUM_BOMB.get() : new ItemParticleOption(ParticleTypes.ITEM, itemstack)), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitBlock(BlockHitResult hit) {
        super.onHitBlock(hit);
        if (this.level().isClientSide) {
            return;
        }
        if (this.explosion == 0) {
            this.bombExplode();
        }
        Direction direction = hit.getDirection();
        float adjust = (float)Math.max(1, this.bouncy) * 0.35f;
        Vec3 newVel = new Vec3(this.getDeltaMovement().toVector3f().reflect((Vector3fc)direction.step()).mul(adjust));
        this.setDeltaMovement(newVel);
        this.hasImpulse = true;
    }
}

