/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.orcinus.galosphere.entities.ai.PreservedAi;
import net.orcinus.galosphere.init.GEntityTypeTags;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSoundEvents;
import org.jetbrains.annotations.Nullable;

public class Preserved
extends Monster {
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Preserved>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY, GSensorTypes.PRESERVED_ENTITY_SENSOR.get());
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object)MemoryModuleType.IS_EMERGING, (Object[])new MemoryModuleType[0]);
    private boolean fromChamber;
    public AnimationState digAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();

    public Preserved(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.fromChamber = compoundTag.getBoolean("FromChamber");
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean("FromChamber", this.fromChamber);
    }

    public boolean shouldDropExperience() {
        return !this.fromChamber;
    }

    public boolean isFromChamber() {
        return this.fromChamber;
    }

    public void setFromChamber(boolean fromChamber) {
        this.fromChamber = fromChamber;
    }

    public void handleEntityEvent(byte b) {
        if (b == 4) {
            this.attackAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(b);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.hurt(source, amount);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        if (DATA_POSE.equals(entityDataAccessor) && this.getPose() == Pose.EMERGING) {
            this.digAnimationState.start(this.tickCount);
        }
        super.onSyncedDataUpdated(entityDataAccessor);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType entitySpawnReason, @Nullable SpawnGroupData spawnGroupData) {
        if (entitySpawnReason == MobSpawnType.TRIGGERED) {
            this.setPose(Pose.EMERGING);
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.IS_EMERGING, (Object)Unit.INSTANCE, 40L);
            this.playSound(GSoundEvents.PRESERVED_EMERGE.get(), 1.0f, 1.0f);
        }
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, entitySpawnReason, spawnGroupData);
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        if (this.hasPose(Pose.EMERGING) && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return true;
        }
        return super.isInvulnerableTo(damageSource);
    }

    protected SoundEvent getAmbientSound() {
        return GSoundEvents.PRESERVED_IDLE.get();
    }

    protected SoundEvent getDeathSound() {
        return GSoundEvents.PRESERVED_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return GSoundEvents.PRESERVED_HURT.get();
    }

    protected SoundEvent getStepSound() {
        return GSoundEvents.PRESERVED_STEP.get();
    }

    protected void playStepSound(BlockPos blockPos, BlockState blockState) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    protected Brain.Provider<Preserved> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return PreservedAi.makeBrain((Brain<Preserved>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Preserved> getBrain() {
        return super.getBrain();
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.getPose() == Pose.EMERGING && (float)this.digAnimationState.getAccumulatedTime() < 2000.0f) {
            RandomSource randomSource = this.getRandom();
            BlockState blockState = this.getBlockStateOn();
            if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    double d = this.getX() + (double)Mth.randomBetween((RandomSource)randomSource, (float)-0.7f, (float)0.7f);
                    double e = this.getY();
                    double f = this.getZ() + (double)Mth.randomBetween((RandomSource)randomSource, (float)-0.7f, (float)0.7f);
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), d, e, f, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void customServerAiStep() {
        ProfilerFiller profiler = this.level().getProfiler();
        profiler.push("preservedBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("preservedUpdateActivity");
        PreservedAi.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    public boolean canTargetEntity(@Nullable Entity entity) {
        Entity e2;
        Entity entity2;
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        Predicate<LivingEntity> predicate = e -> e.getType().is(GEntityTypeTags.PRESERVED_INVALID_TARGETS);
        if (livingEntity.isInvulnerable() || livingEntity.isDeadOrDying() || predicate.test(livingEntity)) {
            return false;
        }
        DamageSource lastSource = this.getLastDamageSource();
        if (lastSource != null && (entity2 = (e2 = lastSource.getEntity())) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            if (e2 == livingEntity && !predicate.test(living)) {
                return true;
            }
        }
        if (this.level() != entity.level() || !EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity) || this.isAlliedTo(entity) || !this.level().getWorldBorder().isWithinBounds(livingEntity.getBoundingBox())) {
            return false;
        }
        return livingEntity instanceof Player || livingEntity instanceof AbstractVillager || livingEntity instanceof IronGolem || livingEntity instanceof Turtle;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, (double)0.26f).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 2.0);
    }
}

