/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.blocks.PollinatedClusterBlock;
import net.orcinus.galosphere.entities.ai.SparkleAi;
import net.orcinus.galosphere.entities.variants.SparkleVariant;
import net.orcinus.galosphere.init.GBlockTags;
import net.orcinus.galosphere.init.GEntityDataSerializers;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GRegistries;
import net.orcinus.galosphere.init.GSensorTypes;
import net.orcinus.galosphere.init.GSparkleVariants;

public class Sparkle
extends Animal {
    private static final EntityDataAccessor<Holder<SparkleVariant>> VARIANT = SynchedEntityData.defineId(Sparkle.class, (EntityDataSerializer)((EntityDataSerializer)GEntityDataSerializers.SPARKLE_VARIANT.get()));
    protected static final ImmutableList<SensorType<? extends Sensor<? super Sparkle>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, GSensorTypes.SPARKLE_TEMPTATIONS.get(), GSensorTypes.NEAREST_POLLINATED_CLUSTER.get(), (Object)SensorType.IS_IN_WATER);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, GMemoryModuleTypes.POLLINATED_COOLDOWN.get(), (Object)MemoryModuleType.IS_TEMPTED, (Object)MemoryModuleType.HURT_BY, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.IS_IN_WATER, MemoryModuleType.IS_PANICKING});
    private static final UniformInt REGROWTH_TICKS = UniformInt.of((int)6000, (int)12000);
    private int growthTicks;

    public Sparkle(EntityType<? extends Sparkle> type, Level world) {
        super(type, world);
        this.setPathfindingMalus(PathType.WATER, 4.0f);
        this.setPathfindingMalus(PathType.TRAPDOOR, -1.0f);
        this.moveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
    }

    public float getWalkTargetValue(BlockPos p_27573_, LevelReader p_27574_) {
        return 0.0f;
    }

    protected Brain.Provider<Sparkle> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return SparkleAi.makeBrain((Brain<Sparkle>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Sparkle> getBrain() {
        return super.getBrain();
    }

    protected void customServerAiStep() {
        ProfilerFiller profiler = this.level().getProfiler();
        profiler.push("sparkleBrain");
        this.getBrain().tick((ServerLevel)this.level(), (LivingEntity)this);
        profiler.pop();
        profiler.push("sparkleActivityUpdate");
        SparkleAi.updateActivity(this);
        profiler.pop();
        super.customServerAiStep();
    }

    public float maxUpStep() {
        return 1.0f;
    }

    public static boolean isValidTargetState(Level level, BlockPos blockPos, LivingEntity livingEntity) {
        BlockState state = level.getBlockState(blockPos);
        return state.is(GBlockTags.CRYSTAL_CLUSTERS) && (!(state.getBlock() instanceof PollinatedClusterBlock) || (Boolean)state.getValue((Property)PollinatedClusterBlock.POLLINATED) == false);
    }

    public void travel(Vec3 deltaMovement) {
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), deltaMovement);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(deltaMovement);
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 1.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        RegistryAccess registryAccess = this.registryAccess();
        Registry registry = registryAccess.registryOrThrow(GRegistries.SPARKLE_VARIANT);
        builder.define(VARIANT, (Object)((Holder)registry.getHolder(GSparkleVariants.DEFAULT).or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public static boolean checkSparkleSpawnRules(EntityType<? extends LivingEntity> sparkle, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(GBlockTags.SPARKLES_SPAWNABLE_ON);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType entitySpawnReason, @Nullable SpawnGroupData spawnGroupData) {
        this.setVariant(this.getNonDefaultRandomVariant());
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, entitySpawnReason, spawnGroupData);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        Optional.ofNullable(ResourceLocation.tryParse((String)tag.getString("variant"))).map(resourceLocation -> ResourceKey.create(GRegistries.SPARKLE_VARIANT, (ResourceLocation)resourceLocation)).flatMap(resourceKey -> this.registryAccess().lookupOrThrow(GRegistries.SPARKLE_VARIANT).get(resourceKey)).ifPresent(this::setVariant);
        this.setGrowthTicks(tag.getInt("GrowthTicks"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.getVariant().unwrapKey().ifPresent(resourceKey -> tag.putString("variant", resourceKey.location().toString()));
        tag.putInt("GrowthTicks", this.getGrowthTicks());
    }

    public void setGrowthTicks(int growthTicks) {
        this.growthTicks = growthTicks;
    }

    public int getGrowthTicks() {
        return this.growthTicks;
    }

    protected PathNavigation createNavigation(Level world) {
        return new SparklePathNavigation(this, world);
    }

    public void setVariant(Holder<SparkleVariant> holder) {
        this.entityData.set(VARIANT, holder);
    }

    public Holder<SparkleVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(GItemTags.SPARKLE_TEMPT_ITEMS);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob mob) {
        Sparkle sparkleEntity = (Sparkle)GEntityTypes.SPARKLE.get().create((Level)world);
        if (sparkleEntity != null) {
            sparkleEntity.setVariant((Holder<SparkleVariant>)world.registryAccess().lookupOrThrow(GRegistries.SPARKLE_VARIANT).getOrThrow(GSparkleVariants.DEFAULT));
        }
        return sparkleEntity;
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide() && this.getVariant() == this.getDefaultVariant()) {
            if (this.getGrowthTicks() > 0) {
                this.setGrowthTicks(this.getGrowthTicks() - 1);
            } else {
                this.setVariant(this.getNonDefaultRandomVariant());
            }
        }
    }

    private Holder<SparkleVariant> getNonDefaultRandomVariant() {
        Registry registry = this.level().registryAccess().registryOrThrow(GRegistries.SPARKLE_VARIANT);
        Optional optional = registry.getRandom(this.getRandom());
        return (Holder)optional.orElseThrow();
    }

    private Holder<SparkleVariant> getDefaultVariant() {
        return this.level().registryAccess().lookupOrThrow(GRegistries.SPARKLE_VARIANT).getOrThrow(GSparkleVariants.DEFAULT);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.getVariant() != this.getDefaultVariant() && stack.is(ItemTags.PICKAXES) && !this.isBaby()) {
            this.extractShard(stack);
            stack.hurtAndBreak(1, (LivingEntity)player, Sparkle.getSlotForHand((InteractionHand)hand));
            this.gameEvent((Holder)GameEvent.SHEAR, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        if (this.getVariant() == this.getDefaultVariant() && stack.is(GItemTags.SPARKLE_TEMPT_ITEMS)) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.setGrowthTicks(this.getGrowthTicks() - Mth.nextInt((RandomSource)this.random, (int)600, (int)1000));
            this.playSound(SoundEvents.CAMEL_EAT, 1.0f, 1.0f);
            this.gameEvent((Holder)GameEvent.EAT);
            this.level().addParticle((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    public void extractShard(ItemStack stack) {
        this.spawnShard(stack);
        this.playSound(SoundEvents.CALCITE_HIT, 1.0f, 1.0f);
        this.setVariant(this.getDefaultVariant());
        this.setGrowthTicks(REGROWTH_TICKS.sample(this.getRandom()));
    }

    private void spawnShard(ItemStack stack) {
        Optional<Item> item;
        HolderLookup.RegistryLookup lookup = this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        SparkleVariant sparkleVariant = (SparkleVariant)this.getVariant().value();
        Optional<Item> optional = item = EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)stack) > 0 ? sparkleVariant.crystal() : sparkleVariant.item();
        if (item.isEmpty()) {
            return;
        }
        int fortuneLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.FORTUNE), (ItemStack)stack);
        int rolls = fortuneLevel > 0 ? Mth.nextInt((RandomSource)this.random, (int)0, (int)2) * fortuneLevel : 1;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < rolls; ++i) {
                this.spawnAtLocation((ItemLike)item.get());
            }
        }
    }

    static class SparklePathNavigation
    extends AmphibiousPathNavigation {
        SparklePathNavigation(Sparkle sparkle, Level world) {
            super((Mob)sparkle, world);
        }

        public boolean canCutCorner(PathType pathType) {
            return pathType != PathType.WATER_BORDER && super.canCutCorner(pathType);
        }
    }
}

