/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.orcinus.galosphere.crafting.WeaponRackingLoader;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GSoundEvents;
import net.orcinus.galosphere.util.weapon_racks.WeaponRackSetting;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeaponRack
extends HangingEntity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(WeaponRack.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Integer> DATA_ROTATION = SynchedEntityData.defineId(WeaponRack.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float dropChance = 1.0f;
    private boolean fixed = false;

    public WeaponRack(EntityType<? extends WeaponRack> entityType, Level level) {
        super(entityType, level);
        this.setInvisible(false);
    }

    public WeaponRack(Level level, BlockPos blockPos, Direction direction) {
        this(GEntityTypes.WEAPON_RACK.get(), level, blockPos, direction);
    }

    public WeaponRack(EntityType<? extends WeaponRack> entityType, Level level, BlockPos blockPos, Direction direction) {
        super(entityType, level, blockPos);
        this.setDirection(direction);
        this.setInvisible(false);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM, (Object)ItemStack.EMPTY);
        builder.define(DATA_ROTATION, (Object)0);
    }

    protected void setDirection(Direction direction) {
        Validate.notNull((Object)direction);
        this.direction = direction;
        if (direction.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(this.direction.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * direction.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        super.recreateFromPacket(clientboundAddEntityPacket);
        this.setDirection(Direction.from3DDataValue((int)clientboundAddEntityPacket.getData()));
    }

    public float getVisualRotationYInDegrees() {
        Direction direction = this.getDirection();
        int i = direction.getAxis().isVertical() ? 90 * direction.getAxisDirection().getStep() : 0;
        return Mth.wrapDegrees((int)(180 + direction.get2DDataValue() * 90 + this.getRotation() * 45 + i));
    }

    protected AABB calculateBoundingBox(BlockPos blockPos, Direction direction) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockPos).relative(direction, -0.46875);
        Direction.Axis axis = direction.getAxis();
        double d = axis == Direction.Axis.X ? 0.0625 : 0.75;
        double e = axis == Direction.Axis.Y ? 0.0625 : 0.75;
        double g = axis == Direction.Axis.Z ? 0.0625 : 0.75;
        return AABB.ofSize((Vec3)vec3, (double)d, (double)e, (double)g);
    }

    public boolean survives() {
        if (this.fixed) {
            return true;
        }
        if (!this.level().noCollision((Entity)this)) {
            return false;
        }
        BlockState blockState = this.level().getBlockState(this.pos.relative(this.direction.getOpposite()));
        return blockState.isSolid() || this.direction.getAxis().isHorizontal() && DiodeBlock.isDiode((BlockState)blockState) ? this.level().getEntities((Entity)this, this.getBoundingBox(), HANGING_ENTITY).isEmpty() : false;
    }

    public void move(MoverType moverType, Vec3 vec3) {
        if (!this.fixed) {
            super.move(moverType, vec3);
        }
    }

    public void push(double d, double e, double f) {
        if (!this.fixed) {
            super.push(d, e, f);
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        if (!this.fixed) {
            if (this.isInvulnerableTo(source)) {
                return false;
            }
            if (!source.is(DamageTypeTags.IS_EXPLOSION) && !this.getItem().isEmpty()) {
                if (!this.level().isClientSide) {
                    this.dropItem(source.getEntity(), false);
                    this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, source.getEntity());
                    this.playSound(this.getRemoveItemSound(), 1.0f, 1.0f);
                }
                return true;
            }
            return super.hurt(source, amount);
        }
        return (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || source.isCreativePlayer()) && super.hurt(source, amount);
    }

    private static boolean canHurtWhenFixed(DamageSource damageSource) {
        return damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY) || damageSource.isCreativePlayer();
    }

    private boolean shouldDamageDropItem(DamageSource damageSource) {
        return !damageSource.is(DamageTypeTags.IS_EXPLOSION) && !this.getItem().isEmpty();
    }

    public void playPlacementSound() {
        this.playSound(this.getPlaceSound(), 1.0f, 1.0f);
    }

    public boolean shouldRenderAtSqrDistance(double d) {
        double e = 16.0;
        return d < (e *= 64.0 * WeaponRack.getViewScale()) * e;
    }

    public void dropItem(@Nullable Entity entity) {
        this.playSound(this.getBreakSound(), 1.0f, 1.0f);
        this.dropItem(entity, true);
        this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, entity);
    }

    private void dropItem(@Nullable Entity entity, boolean bl) {
        if (!this.fixed) {
            ItemStack itemStack = this.getItem();
            this.setItem(ItemStack.EMPTY);
            if (!this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                return;
            }
            if (bl) {
                this.spawnAtLocation(this.getFrameItemStack());
            }
            if (!itemStack.isEmpty()) {
                itemStack = itemStack.copy();
                if (this.random.nextFloat() < this.dropChance) {
                    this.spawnAtLocation(itemStack);
                }
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        ItemStack itemStack = this.getItem();
        if (!itemStack.isEmpty()) {
            compoundTag.put("Item", this.getItem().save((HolderLookup.Provider)this.registryAccess()));
        }
        compoundTag.putByte("ItemRotation", (byte)this.getRotation());
        compoundTag.putFloat("ItemDropChance", this.dropChance);
        compoundTag.putByte("Facing", (byte)this.direction.get3DDataValue());
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        ItemStack itemStack;
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains("Item", 10)) {
            CompoundTag compoundTag2 = compoundTag.getCompound("Item");
            itemStack = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag2).orElse(ItemStack.EMPTY);
        } else {
            itemStack = ItemStack.EMPTY;
        }
        this.setItem(itemStack, false);
        this.setRotation(compoundTag.getByte("ItemRotation"), false);
        if (compoundTag.contains("ItemDropChance", 99)) {
            this.dropChance = compoundTag.getFloat("ItemDropChance");
        }
        this.setDirection(Direction.from3DDataValue((int)compoundTag.getByte("Facing")));
    }

    public void setItem(ItemStack itemStack) {
        this.setItem(itemStack, true);
    }

    public void setItem(ItemStack itemStack, boolean bl) {
        if (!itemStack.isEmpty()) {
            itemStack = itemStack.copyWithCount(1);
        }
        this.onItemChanged(itemStack);
        this.getEntityData().set(DATA_ITEM, (Object)itemStack);
        if (!itemStack.isEmpty()) {
            this.playSound(this.getAddItemSound(), 1.0f, 1.0f);
        }
        if (bl) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        if (entityDataAccessor.equals(DATA_ITEM)) {
            this.onItemChanged(this.getItem());
        }
    }

    private void onItemChanged(ItemStack itemStack) {
        if (!itemStack.isEmpty() && itemStack.getEntityRepresentation() instanceof WeaponRack) {
            itemStack.setEntityRepresentation((Entity)this);
        }
        this.recalculateBoundingBox();
    }

    public InteractionResult interact(Player player, InteractionHand interactionHand) {
        boolean hasItem;
        ItemStack itemStack = player.getItemInHand(interactionHand);
        boolean holdingItem = !this.getItem().isEmpty();
        boolean bl = hasItem = !itemStack.isEmpty() && itemStack.is(GItemTags.WEAPON_RACKS_CAN_HOLD);
        if (this.fixed) {
            return InteractionResult.PASS;
        }
        if (!player.level().isClientSide) {
            if (!holdingItem) {
                if (hasItem && !this.isRemoved()) {
                    this.setItem(itemStack);
                    this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
                    itemStack.consume(1, (LivingEntity)player);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }
            this.playSound(this.getRotateItemSound(), 1.0f, 1.0f);
            this.setRotation(this.getRotation() + 1);
            this.gameEvent((Holder)GameEvent.BLOCK_CHANGE, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        return !holdingItem && !hasItem ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    @Nullable
    public ItemStack getPickResult() {
        ItemStack itemStack = this.getItem();
        return itemStack.isEmpty() ? this.getFrameItemStack() : itemStack.copy();
    }

    protected ItemStack getFrameItemStack() {
        return new ItemStack((ItemLike)GItems.WEAPON_RACK.get());
    }

    public int getRotation() {
        return (Integer)this.getEntityData().get(DATA_ROTATION);
    }

    public void setRotation(int i) {
        this.setRotation(i, true);
    }

    private void setRotation(int i, boolean bl) {
        this.getEntityData().set(DATA_ROTATION, (Object)(i % 8));
        if (bl) {
            this.level().updateNeighbourForOutputSignal(this.pos, Blocks.AIR);
        }
    }

    public SoundEvent getBreakSound() {
        return GSoundEvents.PALLADIUM.getBreakSound();
    }

    public SoundEvent getPlaceSound() {
        return GSoundEvents.PALLADIUM.getPlaceSound();
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.ITEM_FRAME_ADD_ITEM;
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM);
    }

    public SoundEvent getRemoveItemSound() {
        return SoundEvents.ITEM_FRAME_REMOVE_ITEM;
    }

    public SoundEvent getRotateItemSound() {
        return SoundEvents.ITEM_FRAME_ROTATE_ITEM;
    }

    private WeaponRackSetting setting() {
        return this.settingsList(this::matchesItem).getFirst();
    }

    private boolean matchesItem(WeaponRackSetting weaponRackSetting) {
        return weaponRackSetting.ingredient().test(this.getItem());
    }

    @NotNull
    private List<WeaponRackSetting> settingsList(Predicate<WeaponRackSetting> predicate) {
        return WeaponRackingLoader.SETTINGS.stream().filter(predicate).toList();
    }

    public boolean isInvalidShift(float value) {
        return value == -11.0f;
    }

    public boolean isInvalidRotation(float value) {
        return value == -190.0f;
    }

    public float getXShift() {
        boolean empty;
        ItemStack itemStack = this.getItem();
        boolean ranged = itemStack.is(Tags.Items.RANGED_WEAPON_TOOLS) && !itemStack.is(Tags.Items.MELEE_WEAPON_TOOLS);
        boolean nonTools = itemStack.is(Tags.Items.MELEE_WEAPON_TOOLS) || ranged || itemStack.is(Tags.Items.TOOLS_BRUSH);
        boolean bl = empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidShift(this.setting().xShift());
        if (empty) {
            return nonTools ? 0.5525f : 0.5325f;
        }
        return this.setting().xShift();
    }

    public float getYShift() {
        boolean empty;
        ItemStack itemStack = this.getItem();
        boolean ranged = itemStack.is(Tags.Items.RANGED_WEAPON_TOOLS) && !itemStack.is(Tags.Items.MELEE_WEAPON_TOOLS);
        boolean bl = empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidShift(this.setting().yShift());
        if (empty) {
            return ranged ? -0.015f : -0.4375f;
        }
        return this.setting().yShift();
    }

    public float getZShift() {
        boolean empty;
        boolean bl = empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidShift(this.setting().zShift());
        if (empty) {
            return 0.02575f;
        }
        return this.setting().zShift();
    }

    public float getPitchRotation() {
        boolean empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidRotation(this.setting().pitch());
        return empty ? 0.0f : this.setting().pitch();
    }

    public float getYawRotation() {
        boolean empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidRotation(this.setting().yaw());
        return empty ? 0.0f : this.setting().yaw();
    }

    public float getRollRotation() {
        boolean empty;
        ItemStack itemStack = this.getItem();
        boolean ranged = itemStack.is(Tags.Items.RANGED_WEAPON_TOOLS) && !itemStack.is(Tags.Items.MELEE_WEAPON_TOOLS);
        boolean bl = empty = this.settingsList(this::matchesItem).isEmpty() || this.isInvalidRotation(this.setting().roll());
        if (empty) {
            return ranged ? 45.0f : 135.0f;
        }
        return this.setting().roll();
    }
}

