/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.entities.ai.tasks.berserker.ConditionalWalkIfTargetOutOfReach;
import net.orcinus.galosphere.entities.ai.tasks.berserker.HaliteAttack;
import net.orcinus.galosphere.entities.ai.tasks.berserker.Shake;
import net.orcinus.galosphere.entities.ai.tasks.berserker.Smash;
import net.orcinus.galosphere.entities.ai.tasks.berserker.Summon;
import net.orcinus.galosphere.entities.ai.tasks.berserker.Undermine;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSensorTypes;

public class BerserkerAi {
    public static final ImmutableList<? extends SensorType<? extends Sensor<? super Berserker>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.NEAREST_PLAYERS, (Object)SensorType.HURT_BY, GSensorTypes.BERSERKER_ENTITY_SENSOR.get());
    public static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.AVOID_TARGET, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY, MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.NEAREST_ATTACKABLE, GMemoryModuleTypes.IMPALING_COOLDOWN.get(), GMemoryModuleTypes.IMPALING_COUNT.get(), GMemoryModuleTypes.IS_SMASHING.get(), GMemoryModuleTypes.IS_IMPALING.get(), GMemoryModuleTypes.IS_SUMMONING.get(), GMemoryModuleTypes.SUMMONING_COOLDOWN.get(), GMemoryModuleTypes.SUMMON_COUNT.get(), GMemoryModuleTypes.SMASHING_COOLDOWN.get(), GMemoryModuleTypes.HURT_COUNT.get(), GMemoryModuleTypes.RAMPAGE_TICKS.get(), MemoryModuleType.ROAR_SOUND_COOLDOWN, MemoryModuleType.ROAR_SOUND_DELAY, GMemoryModuleTypes.IS_SHAKING.get(), GMemoryModuleTypes.HALITE_ATTACK_COOLDOWN.get(), GMemoryModuleTypes.IS_HALITE_ATTACKING.get()});

    public static Brain<?> makeBrain(Berserker berserker, Brain<Berserker> brain) {
        BerserkerAi.initCoreActivity(brain);
        BerserkerAi.initIdleActivity(brain);
        BerserkerAi.initShakeActivity(brain);
        BerserkerAi.initFightActivity(berserker, brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<Berserker> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(GMemoryModuleTypes.RAMPAGE_TICKS.get())));
    }

    private static void initIdleActivity(Brain<Berserker> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)StartAttacking.create(BerserkerAi::findNearestValidAttackTarget), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60)), BerserkerAi.createIdleMovementBehaviors()));
    }

    private static void initShakeActivity(Brain<Berserker> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.EMERGE, 5, ImmutableList.of((Object)((Object)new Shake())), GMemoryModuleTypes.IS_SHAKING.get());
    }

    private static void initFightActivity(Berserker berserker, Brain<Berserker> brain) {
        Predicate<LivingEntity> predicate = livingEntity -> {
            Berserker b;
            return livingEntity instanceof Berserker && (!(b = (Berserker)((Object)livingEntity)).hasPose(Pose.ROARING) || b.getPhase() != Berserker.Phase.UNDERMINE);
        };
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)BehaviorBuilder.triggerIf(Berserker::shouldUseMeleeAttack, (OneShot)MeleeAttack.create((int)600)), (Object)((Object)new HaliteAttack()), (Object)((Object)new Smash()), (Object)BehaviorBuilder.triggerIf(predicate, ConditionalWalkIfTargetOutOfReach.create(1.2f)), (Object)((Object)new Undermine()), (Object)((Object)new Summon()), (Object)StopAttackingIfTargetInvalid.create(livingEntity -> !berserker.canTargetEntity((Entity)livingEntity), (mob, livingEntity) -> {}, (boolean)false)), MemoryModuleType.ATTACK_TARGET);
    }

    private static RunOne<Berserker> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.3f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.2f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Berserker berserker) {
        return berserker.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }

    public static void updateActivity(Berserker berserker) {
        berserker.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.EMERGE, (Object)Activity.FIGHT, (Object)Activity.IDLE));
    }
}

