/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.orcinus.galosphere.entities.Preserved;
import net.orcinus.galosphere.entities.ai.tasks.preserved.Rise;

public class PreservedAi {
    public static Brain<?> makeBrain(Brain<Preserved> brain) {
        PreservedAi.initCoreActivity(brain);
        PreservedAi.initEmergeActivity(brain);
        PreservedAi.initIdleActivity(brain);
        PreservedAi.initFightActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<Preserved> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initEmergeActivity(Brain<Preserved> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.EMERGE, 5, ImmutableList.of((Object)((Object)new Rise(40))), MemoryModuleType.IS_EMERGING);
    }

    private static void initIdleActivity(Brain<Preserved> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)StartAttacking.create(PreservedAi::findNearestValidAttackTarget), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60)), PreservedAi.createIdleMovementBehaviors()));
    }

    private static void initFightActivity(Brain<Preserved> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.2f), (Object)MeleeAttack.create((int)40), (Object)StopAttackingIfTargetInvalid.create()), MemoryModuleType.ATTACK_TARGET);
    }

    private static RunOne<Preserved> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Preserved preserved) {
        return preserved.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }

    public static void updateActivity(Preserved preserved) {
        preserved.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.EMERGE, (Object)Activity.FIGHT, (Object)Activity.IDLE));
    }
}

