/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.TryFindLand;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.orcinus.galosphere.entities.Sparkle;
import net.orcinus.galosphere.entities.ai.tasks.sparkle.WalkToPollinatedCluster;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItemTags;

public class SparkleAi {
    public static Brain<?> makeBrain(Brain<Sparkle> brain) {
        SparkleAi.initCoreActivity(brain);
        SparkleAi.initIdleActivity(brain);
        SparkleAi.initSwimActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<Sparkle> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<Sparkle> brain) {
        brain.addActivityWithConditions(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove(GEntityTypes.SPARKLE.get(), 1.0f, 2)), (Object)Pair.of((Object)1, (Object)new FollowTemptation(entity -> Float.valueOf(2.0f))), (Object)Pair.of((Object)2, (Object)BabyFollowAdult.create((UniformInt)UniformInt.of((int)5, (int)16), (float)1.25f)), (Object)Pair.of((Object)3, (Object)((Object)new WalkToPollinatedCluster())), (Object)Pair.of((Object)4, (Object)TryFindLand.create((int)6, (float)1.0f)), (Object)Pair.of((Object)5, (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)1.5f), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.5f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::onGround), (Object)2))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initSwimActivity(Brain<Sparkle> brain) {
        brain.addActivityWithConditions(Activity.SWIM, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new FollowTemptation(entity -> Float.valueOf(2.0f))), (Object)Pair.of((Object)2, (Object)((Object)new WalkToPollinatedCluster())), (Object)Pair.of((Object)3, (Object)TryFindLand.create((int)8, (float)1.5f)), (Object)Pair.of((Object)4, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.swim((float)0.75f), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)1.0f, (boolean)true), (Object)1), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)1), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::isInWater), (Object)5))))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.IS_IN_WATER, (Object)MemoryStatus.VALUE_PRESENT)));
    }

    public static void updateActivity(Sparkle entity) {
        entity.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.SWIM, (Object)Activity.IDLE));
    }

    public static Predicate<ItemStack> getTemptations() {
        return itemStack -> itemStack.is(GItemTags.SPARKLE_TEMPT_ITEMS);
    }
}

