/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.sensors;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.NearestLivingEntitySensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.orcinus.galosphere.entities.Mole;

public class MoleEntitySensor
extends NearestLivingEntitySensor<Mole> {
    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)super.requires(), List.of(MemoryModuleType.NEAREST_ATTACKABLE)));
    }

    protected void doTick(ServerLevel serverLevel, Mole mole) {
        super.doTick(serverLevel, (LivingEntity)mole);
        mole.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).stream().flatMap(Collection::stream).filter(EntitySelector.NO_CREATIVE_OR_SPECTATOR).filter(livingEntity -> Sensor.isEntityAttackable((LivingEntity)mole, (LivingEntity)livingEntity)).filter(living -> living.getType() == EntityType.SILVERFISH).findFirst().ifPresentOrElse(livingEntity -> mole.getBrain().setMemory(MemoryModuleType.NEAREST_ATTACKABLE, livingEntity), () -> mole.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE));
    }
}

