/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.sensors;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.orcinus.galosphere.entities.ai.MoleAi;
import org.jetbrains.annotations.Nullable;

public class RepellentSensor
extends Sensor<LivingEntity> {
    private final RepellentCondition repellentCondition;

    public RepellentSensor(RepellentCondition repellentCondition) {
        this.repellentCondition = repellentCondition;
    }

    protected void doTick(ServerLevel serverLevel, LivingEntity livingEntity) {
        livingEntity.getBrain().setMemory(MemoryModuleType.NEAREST_REPELLENT, this.findNearestRepellent(serverLevel, livingEntity));
        livingEntity.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(entities -> entities.findClosest(living -> this.repellentCondition.validRepellent(serverLevel, null, (LivingEntity)living))).ifPresent(living -> livingEntity.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, living, (long)MoleAi.AVOID_DURATION.sample(living.getRandom())));
    }

    private Optional<BlockPos> findNearestRepellent(ServerLevel serverLevel, LivingEntity livingEntity) {
        return BlockPos.findClosestMatch((BlockPos)livingEntity.blockPosition(), (int)3, (int)1, blockPos -> this.repellentCondition.validRepellent(serverLevel, (BlockPos)blockPos, null));
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of((Object)MemoryModuleType.NEAREST_REPELLENT, (Object)MemoryModuleType.AVOID_TARGET);
    }

    public static interface RepellentCondition {
        public boolean validRepellent(ServerLevel var1, @Nullable BlockPos var2, @Nullable LivingEntity var3);
    }
}

