/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.berserker;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Shake
extends Behavior<Berserker> {
    public Shake() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.IS_SHAKING.get(), (Object)MemoryStatus.VALUE_PRESENT), 20);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Berserker livingEntity) {
        return livingEntity.isStationary();
    }

    protected boolean canStillUse(ServerLevel serverLevel, Berserker livingEntity, long l) {
        return true;
    }

    protected void start(ServerLevel serverLevel, Berserker livingEntity, long l) {
        livingEntity.setPose(Pose.EMERGING);
        livingEntity.playSound(GSoundEvents.BERSERKER_SHAKE.get(), 1.0f, 1.0f);
    }

    protected void stop(ServerLevel serverLevel, Berserker livingEntity, long l) {
        Brain<Berserker> brain = livingEntity.getBrain();
        if (livingEntity.hasPose(Pose.EMERGING)) {
            livingEntity.setPose(Pose.STANDING);
        }
        brain.eraseMemory(GMemoryModuleTypes.IS_SHAKING.get());
        livingEntity.playSound(GSoundEvents.BERSERKER_ROAR.get(), 3.0f, 1.0f);
    }
}

