/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.berserker;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.phys.Vec3;
import net.orcinus.galosphere.entities.Berserker;
import net.orcinus.galosphere.init.GMemoryModuleTypes;
import net.orcinus.galosphere.init.GSoundEvents;

public class Smash
extends Behavior<Berserker> {
    private static final int DURATION = Mth.ceil((float)27.0f);
    private static final int MAX_DURATION = 60;

    public Smash() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.RAMPAGE_TICKS.get(), (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, GMemoryModuleTypes.IS_SMASHING.get(), (Object)MemoryStatus.REGISTERED, GMemoryModuleTypes.IS_IMPALING.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.IS_SUMMONING.get(), (Object)MemoryStatus.VALUE_ABSENT, GMemoryModuleTypes.SMASHING_COOLDOWN.get(), (Object)MemoryStatus.VALUE_ABSENT), 60);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Berserker livingEntity) {
        Optional memory = livingEntity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (!livingEntity.shouldAttack()) return false;
        if (!memory.filter(arg_0 -> ((Berserker)livingEntity).isWithinMeleeAttackRange(arg_0)).isPresent()) return false;
        return true;
    }

    protected boolean canStillUse(ServerLevel serverLevel, Berserker livingEntity, long l) {
        return true;
    }

    protected void start(ServerLevel serverLevel, Berserker livingEntity, long l) {
        Brain<Berserker> brain = livingEntity.getBrain();
        brain.setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)DURATION);
        brain.setMemoryWithExpiry(GMemoryModuleTypes.IS_SMASHING.get(), (Object)Unit.INSTANCE, 60L);
        livingEntity.setPhase(Berserker.Phase.SMASH);
        livingEntity.playSound(GSoundEvents.BERSERKER_DUO_SMASH.get(), 10.0f, 1.0f);
    }

    protected void tick(ServerLevel level, Berserker self, long l) {
        self.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).ifPresent(target -> self.getLookControl().setLookAt(target.position()));
        self.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        if (self.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_COOLING_DOWN)) {
            return;
        }
        List<LivingEntity> list = level.getEntitiesOfClass(LivingEntity.class, self.getBoundingBox().inflate(8.0)).stream().filter(living -> self.canTargetEntity((Entity)living)).filter(e -> e.getUUID() != self.getUUID()).toList();
        for (LivingEntity enemy : list) {
            Vec3 selfPos = self.position().add(0.0, (double)1.6f, 0.0);
            Vec3 enemyPos = enemy.getEyePosition().subtract(selfPos);
            Vec3 normalizedDirection = enemyPos.normalize();
            double knockbackX = 0.5 * (1.0 - enemy.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            double knockbackY = 2.5 * (1.0 - enemy.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            double distanceFromEnemy = self.distanceTo((Entity)enemy);
            boolean canDamage = true;
            if (distanceFromEnemy > 3.0 && !enemy.onGround()) {
                canDamage = false;
            }
            if (!canDamage) continue;
            self.doHurtTarget((Entity)enemy);
            self.heal(10.0f);
            enemy.push(normalizedDirection.x() * knockbackY, normalizedDirection.y() * knockbackX, normalizedDirection.z() * knockbackY);
        }
        self.level().broadcastEntityEvent((Entity)self, (byte)32);
        self.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, (long)(60 - DURATION));
    }

    protected void stop(ServerLevel serverLevel, Berserker livingEntity, long l) {
        livingEntity.setPhase(Berserker.Phase.IDLING);
    }
}

