/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.entities.ai.tasks.mole;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.orcinus.galosphere.blocks.blockentities.MoleBurrowBlockEntity;
import net.orcinus.galosphere.entities.Mole;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GMemoryModuleTypes;

public class CreateBurrow
extends Behavior<Mole> {
    public CreateBurrow() {
        super((Map)ImmutableMap.of(GMemoryModuleTypes.NEAREST_TUFF_DIRT.get(), (Object)MemoryStatus.VALUE_PRESENT), 40);
    }

    protected boolean checkExtraStartConditions(ServerLevel serverLevel, Mole livingEntity) {
        return this.canBurrow(livingEntity);
    }

    protected boolean canStillUse(ServerLevel serverLevel, Mole livingEntity, long l) {
        return this.canBurrow(livingEntity);
    }

    protected void start(ServerLevel serverLevel, Mole livingEntity, long l) {
        livingEntity.transitionTo(Mole.State.DIGGING);
    }

    protected void stop(ServerLevel serverLevel, Mole livingEntity, long l) {
        if (livingEntity.getState() != Mole.State.DIGGING) {
            return;
        }
        if (this.canBurrow(livingEntity)) {
            serverLevel.setBlock(livingEntity.blockPosition().below(), ((Block)GBlocks.MOLE_BURROW.get()).defaultBlockState(), 2);
            BlockEntity blockEntity = serverLevel.getBlockEntity(livingEntity.blockPosition().below());
            if (blockEntity instanceof MoleBurrowBlockEntity) {
                MoleBurrowBlockEntity moleBurrowBlock = (MoleBurrowBlockEntity)blockEntity;
                moleBurrowBlock.addMole((Entity)livingEntity, false);
            }
            livingEntity.discard();
        } else {
            livingEntity.transitionTo(Mole.State.IDLING);
        }
    }

    private boolean canBurrow(Mole mole) {
        return mole.isAlive() && mole.level().getBlockState(mole.blockPosition().below()).is((Block)GBlocks.TUFF_DIRT.get());
    }
}

