/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.events;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SuspendedTownParticle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterEntitySpectatorShadersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.client.SpectatorTickHandler;
import net.orcinus.galosphere.client.gui.CombustionTableScreen;
import net.orcinus.galosphere.client.gui.GoldenBreathOverlay;
import net.orcinus.galosphere.client.gui.SpectatorVisionOverlay;
import net.orcinus.galosphere.client.model.BerserkerModel;
import net.orcinus.galosphere.client.model.MoleModel;
import net.orcinus.galosphere.client.model.PinkSaltPillarModel;
import net.orcinus.galosphere.client.model.PreservedModel;
import net.orcinus.galosphere.client.model.RopeDartModel;
import net.orcinus.galosphere.client.model.SparkleModel;
import net.orcinus.galosphere.client.model.SpecterpillarModel;
import net.orcinus.galosphere.client.model.SpectreModel;
import net.orcinus.galosphere.client.model.SterlingArmorModel;
import net.orcinus.galosphere.client.model.WeaponRackModel;
import net.orcinus.galosphere.client.particles.BerserkerSlamShockwave;
import net.orcinus.galosphere.client.particles.CrystalRainParticle;
import net.orcinus.galosphere.client.particles.HoveringAshParticle;
import net.orcinus.galosphere.client.particles.IndicatorParticle;
import net.orcinus.galosphere.client.particles.SpectateOrbParticle;
import net.orcinus.galosphere.client.particles.providers.PalladiumBombParticleProvider;
import net.orcinus.galosphere.client.particles.providers.PinkSaltFallingDustProvider;
import net.orcinus.galosphere.client.renderer.block.GildedBeadsRenderer;
import net.orcinus.galosphere.client.renderer.block.ShadowFrameBlockRenderer;
import net.orcinus.galosphere.client.renderer.entity.BerserkerRenderer;
import net.orcinus.galosphere.client.renderer.entity.MoleRenderer;
import net.orcinus.galosphere.client.renderer.entity.PinkSaltPillarRenderer;
import net.orcinus.galosphere.client.renderer.entity.PinkSaltShardRenderer;
import net.orcinus.galosphere.client.renderer.entity.PreservedRenderer;
import net.orcinus.galosphere.client.renderer.entity.RopeDartProjectileRenderer;
import net.orcinus.galosphere.client.renderer.entity.SparkleRenderer;
import net.orcinus.galosphere.client.renderer.entity.SpectatorVisionRenderer;
import net.orcinus.galosphere.client.renderer.entity.SpecterpillarRenderer;
import net.orcinus.galosphere.client.renderer.entity.SpectreRenderer;
import net.orcinus.galosphere.client.renderer.entity.ThrowableLaunchedProjectileRenderer;
import net.orcinus.galosphere.client.renderer.entity.WeaponRackRenderer;
import net.orcinus.galosphere.client.renderer.layer.BannerLayer;
import net.orcinus.galosphere.client.renderer.layer.HorseBannerLayer;
import net.orcinus.galosphere.client.renderer.layer.SaltStatueLayer;
import net.orcinus.galosphere.client.tooltip.PreservedComponent;
import net.orcinus.galosphere.client.tooltip.PreservedTooltip;
import net.orcinus.galosphere.client.tooltip.SterlingHelmetComponent;
import net.orcinus.galosphere.client.tooltip.SterlingHelmetTooltip;
import net.orcinus.galosphere.crafting.WeaponRackingLoader;
import net.orcinus.galosphere.events.CameraEvents;
import net.orcinus.galosphere.init.GBlockEntityTypes;
import net.orcinus.galosphere.init.GBlocks;
import net.orcinus.galosphere.init.GDataComponents;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GItems;
import net.orcinus.galosphere.init.GMenuTypes;
import net.orcinus.galosphere.init.GModelLayers;
import net.orcinus.galosphere.init.GParticleTypes;
import net.orcinus.galosphere.items.SaltboundTabletItem;
import net.orcinus.galosphere.items.components.MonstrometerTracker;
import net.orcinus.galosphere.util.quests.IndexedQuest;

@EventBusSubscriber(modid="galosphere", value={Dist.CLIENT})
public class ClientEvents {
    private static final Function<ItemLike, ItemStack> FUNCTION = ItemStack::new;
    public static boolean usingSpectreBoundSpyglass;
    private static float distance;

    @SubscribeEvent
    public static void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new WeaponRackingLoader());
    }

    @SubscribeEvent
    public static void renderGui(RenderGuiEvent.Post event) {
        GoldenBreathOverlay.render(event.getGuiGraphics(), event.getPartialTick());
    }

    @SubscribeEvent
    public static void registerTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(PreservedComponent.class, component -> new PreservedTooltip());
        event.register(SterlingHelmetComponent.class, component -> new SterlingHelmetTooltip(component.itemStack()));
    }

    @SubscribeEvent
    public static void gatherTooltip(RenderTooltipEvent.GatherComponents event) {
        if (event.getItemStack().has(GDataComponents.PRESERVED)) {
            event.getTooltipElements().add(Either.right((Object)new PreservedComponent()));
        }
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                boolean rightArm = arm == HumanoidArm.RIGHT;
                int direction = rightArm ? 1 : -1;
                float f = -0.4f * Mth.sin((float)(Mth.sqrt((float)swingProcess) * (float)Math.PI));
                float f1 = 0.2f * Mth.sin((float)(Mth.sqrt((float)swingProcess) * ((float)Math.PI * 2)));
                float f2 = -0.2f * Mth.sin((float)(swingProcess * (float)Math.PI));
                poseStack.translate((float)direction * f, f1, f2);
                int i = rightArm ? 1 : -1;
                poseStack.translate((float)i * 0.56f, -0.52f + equipProcess * -0.6f, -0.72f);
                float ff = Mth.sin((float)(swingProcess * swingProcess * (float)Math.PI));
                poseStack.mulPose(Axis.YP.rotationDegrees((float)i * (45.0f + ff * -20.0f)));
                float ff1 = Mth.sin((float)(Mth.sqrt((float)swingProcess) * (float)Math.PI));
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)i * ff1 * -20.0f));
                poseStack.mulPose(Axis.XP.rotationDegrees(ff1 * -80.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees((float)i * -45.0f));
                return true;
            }
        }, new Holder[]{GItems.ROPE_DART});
        event.registerItem(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return equipmentSlot == EquipmentSlot.HEAD ? new SterlingArmorModel(SterlingArmorModel.createBodyLayer().bakeRoot()) : super.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
            }
        }, new Holder[]{GItems.STERLING_HELMET});
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.register((Object)new SpectatorVisionOverlay());
        eventBus.register((Object)new CameraEvents());
        eventBus.addListener(clientTickEvent -> SpectatorTickHandler.tick());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.GLINTED_AMETHYST_CLUSTER.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.GLINTED_ALLURITE_CLUSTER.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.GLINTED_LUMIERE_CLUSTER.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.ALLURITE_CLUSTER.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.LUMIERE_CLUSTER.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.STRANDED_MEMBRANE_BLOCK.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.OPAL_SAPLING.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.POTTED_OPAL_SAPLING.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.BOWL_LICHEN.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.LICHEN_ROOTS.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.LICHEN_CORDYCEPS.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.LICHEN_CORDYCEPS_PLANT.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.LICHEN_SHELF.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.LICHEN_VINES.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.POTTED_BOWL_LICHEN.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.POTTED_LICHEN_ROOTS.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.PINK_SALT_STRAW.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.SHADOW_FRAME.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.CHANDELIER.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.SOUL_CHANDELIER.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.LIGHT_STAND.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.SOUL_LIGHT_STAND.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)GBlocks.OPAL_LEAVES.get()), (RenderType)RenderType.cutout());
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)GItems.MINING_POUCH.get()), (ResourceLocation)Galosphere.id("filled"), (itemStack, clientLevel, livingEntity, i) -> ((IndexedQuest)itemStack.getOrDefault(GDataComponents.QUESTS, (Object)IndexedQuest.EMPTY)).requests().isEmpty() ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)GItems.MONSTROMETER.get()), (ResourceLocation)Galosphere.id("fueled"), (itemStack, clientLevel, livingEntity, i) -> {
                MonstrometerTracker tracker = (MonstrometerTracker)itemStack.get(GDataComponents.MONSTROMETER_TRACKER);
                return tracker != null && tracker.fuel() > 0 ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)((Item)GItems.SALTBOUND_TABLET.get()), (ResourceLocation)Galosphere.id("using"), (stack, world, entity, i) -> entity != null && entity.getUseItem().getItem() instanceof SaltboundTabletItem ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)GItems.SALTBOUND_TABLET.get()), (ResourceLocation)Galosphere.id("cooldown"), (stack, world, entity, i) -> {
                Player player;
                return entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown((Item)GItems.SALTBOUND_TABLET.get()) ? 1 : 0;
            });
        });
    }

    private static void addAfter(BuildCreativeModeTabContentsEvent map, ItemLike after, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addAfter(map, after, blk));
    }

    private static void addBefore(BuildCreativeModeTabContentsEvent map, ItemLike before, ItemLike ... block) {
        ArrayList stream = Lists.newArrayList(Arrays.stream(block).toList());
        Collections.reverse(stream);
        stream.forEach(blk -> ClientEvents.addBefore(map, before, blk));
    }

    private static void addAfter(BuildCreativeModeTabContentsEvent event, ItemLike after, ItemLike block) {
        event.insertAfter(FUNCTION.apply(after), FUNCTION.apply(block), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void addBefore(BuildCreativeModeTabContentsEvent event, ItemLike before, ItemLike block) {
        event.insertBefore(FUNCTION.apply(before), FUNCTION.apply(block), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    private static void accept(BuildCreativeModeTabContentsEvent event, ItemLike block) {
        event.accept(new ItemStack(block), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    @SubscribeEvent
    public static void buildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        BuildCreativeModeTabContentsEvent entries = event;
        ResourceKey tabKey = event.getTabKey();
        if (tabKey.equals(CreativeModeTabs.BUILDING_BLOCKS)) {
            ClientEvents.addAfter(entries, (ItemLike)Blocks.AMETHYST_BLOCK, (ItemLike)GBlocks.AMETHYST_STAIRS.get(), (ItemLike)GBlocks.AMETHYST_SLAB.get(), (ItemLike)GBlocks.CHISELED_AMETHYST.get(), (ItemLike)GBlocks.AMETHYST_LAMP.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_AMETHYST_SLAB.get(), (ItemLike)GBlocks.AMETHYST_BRICKS.get(), (ItemLike)GBlocks.AMETHYST_BRICK_STAIRS.get(), (ItemLike)GBlocks.AMETHYST_BRICK_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), (ItemLike)GBlocks.ALLURITE_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_SLAB.get(), (ItemLike)GBlocks.CHISELED_ALLURITE.get(), (ItemLike)GBlocks.ALLURITE_LAMP.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_ALLURITE_SLAB.get(), (ItemLike)GBlocks.ALLURITE_BRICKS.get(), (ItemLike)GBlocks.ALLURITE_BRICK_STAIRS.get(), (ItemLike)GBlocks.ALLURITE_BRICK_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), (ItemLike)GBlocks.LUMIERE_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_SLAB.get(), (ItemLike)GBlocks.CHISELED_LUMIERE.get(), (ItemLike)GBlocks.LUMIERE_LAMP.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE_STAIRS.get(), (ItemLike)GBlocks.SMOOTH_LUMIERE_SLAB.get(), (ItemLike)GBlocks.LUMIERE_BRICKS.get(), (ItemLike)GBlocks.LUMIERE_BRICK_STAIRS.get(), (ItemLike)GBlocks.LUMIERE_BRICK_SLAB.get());
            ClientEvents.accept(entries, (ItemLike)GBlocks.PALLADIUM_BLOCK.get());
            ClientEvents.accept(entries, (ItemLike)GBlocks.PALLADIUM_PANEL.get());
            ClientEvents.accept(entries, (ItemLike)GBlocks.PALLADIUM_PANEL_STAIRS.get());
            ClientEvents.accept(entries, (ItemLike)GBlocks.PALLADIUM_PANEL_SLAB.get());
            ClientEvents.accept(entries, (ItemLike)GBlocks.PALLADIUM_TILES.get());
            ClientEvents.accept(entries, (ItemLike)GBlocks.PALLADIUM_TILES_STAIRS.get());
            ClientEvents.accept(entries, (ItemLike)GBlocks.PALLADIUM_TILES_SLAB.get());
            ClientEvents.accept(entries, (ItemLike)GBlocks.PALLADIUM_LATTICE.get());
        }
        if (tabKey.equals(CreativeModeTabs.NATURAL_BLOCKS)) {
            ClientEvents.addAfter(entries, (ItemLike)Blocks.DEEPSLATE_IRON_ORE, (ItemLike)GBlocks.PALLADIUM_ORE.get(), (ItemLike)GBlocks.DEEPSLATE_PALLADIUM_ORE.get());
            ClientEvents.addAfter(entries, (ItemLike)Blocks.RAW_GOLD_BLOCK, (ItemLike)GBlocks.RAW_PALLADIUM_BLOCK.get());
            ClientEvents.addAfter(entries, (ItemLike)Blocks.AMETHYST_CLUSTER, (ItemLike)GBlocks.GLINTED_AMETHYST_CLUSTER.get(), (ItemLike)GBlocks.ALLURITE_BLOCK.get(), (ItemLike)GBlocks.ALLURITE_CLUSTER.get(), (ItemLike)GBlocks.GLINTED_ALLURITE_CLUSTER.get(), (ItemLike)GBlocks.LUMIERE_BLOCK.get(), (ItemLike)GBlocks.LUMIERE_CLUSTER.get(), (ItemLike)GBlocks.GLINTED_LUMIERE_CLUSTER.get());
            ClientEvents.addAfter(entries, (ItemLike)Blocks.PEARLESCENT_FROGLIGHT, (ItemLike)GBlocks.AMETHYST_LAMP.get(), (ItemLike)GBlocks.ALLURITE_LAMP.get(), (ItemLike)GBlocks.LUMIERE_LAMP.get());
        }
        if (tabKey.equals(CreativeModeTabs.INGREDIENTS)) {
            ClientEvents.addAfter(entries, (ItemLike)Items.RAW_GOLD, (ItemLike)GItems.RAW_PALLADIUM.get());
            ClientEvents.addAfter(entries, (ItemLike)Items.GOLD_INGOT, (ItemLike)GItems.PALLADIUM_INGOT.get());
            ClientEvents.addAfter(entries, (ItemLike)Items.GOLD_NUGGET, (ItemLike)GItems.PALLADIUM_NUGGET.get());
            ClientEvents.addAfter(entries, (ItemLike)Items.AMETHYST_SHARD, (ItemLike)GItems.ALLURITE_SHARD.get(), (ItemLike)GItems.LUMIERE_SHARD.get());
        }
        if (tabKey.equals(CreativeModeTabs.FUNCTIONAL_BLOCKS)) {
            ClientEvents.addAfter(entries, (ItemLike)Blocks.END_ROD, (ItemLike)GBlocks.CHANDELIER.get());
            ClientEvents.addAfter(entries, (ItemLike)Blocks.SMITHING_TABLE, (ItemLike)GBlocks.COMBUSTION_TABLE.get());
        }
        if (tabKey.equals(CreativeModeTabs.NATURAL_BLOCKS)) {
            ClientEvents.addAfter(entries, (ItemLike)Blocks.SNOW, (ItemLike)GBlocks.LICHEN_MOSS.get());
            ClientEvents.addAfter(entries, (ItemLike)Blocks.RED_MUSHROOM, (ItemLike)GBlocks.BOWL_LICHEN.get());
            ClientEvents.addAfter(entries, (ItemLike)Blocks.CACTUS, (ItemLike)GBlocks.LICHEN_SHELF.get(), (ItemLike)GBlocks.LICHEN_ROOTS.get());
        }
        if (tabKey.equals(CreativeModeTabs.FOOD_AND_DRINKS)) {
            ClientEvents.addAfter(entries, (ItemLike)Items.GLOW_BERRIES, (ItemLike)GItems.LICHEN_CORDYCEPS.get(), (ItemLike)GItems.GOLDEN_LICHEN_CORDYCEPS.get());
        }
        if (tabKey.equals(CreativeModeTabs.SPAWN_EGGS)) {
            ClientEvents.addAfter(entries, (ItemLike)Items.SHEEP_SPAWN_EGG, (ItemLike)GItems.SPARKLE_SPAWN_EGG.get(), (ItemLike)GItems.SPECTRE_SPAWN_EGG.get(), (ItemLike)GItems.SPECTERPILLAR_SPAWN_EGG.get());
        }
        if (tabKey.equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
            ClientEvents.addBefore(entries, (ItemLike)Items.SADDLE, (ItemLike)GItems.GLOW_FLARE.get(), (ItemLike)GItems.SPECTRE_FLARE.get());
        }
        if (tabKey.equals(CreativeModeTabs.COMBAT)) {
            ClientEvents.addAfter(entries, (ItemLike)Items.CHAINMAIL_BOOTS, (ItemLike)GItems.STERLING_HELMET.get(), (ItemLike)GItems.STERLING_CHESTPLATE.get(), (ItemLike)GItems.STERLING_LEGGINGS.get(), (ItemLike)GItems.STERLING_BOOTS.get());
            ClientEvents.addAfter(entries, (ItemLike)Items.LEATHER_HORSE_ARMOR, (ItemLike)GItems.STERLING_HORSE_ARMOR.get());
            ClientEvents.addAfter(entries, (ItemLike)Items.TNT, (ItemLike)GItems.PALLADIUM_BOMB.get());
        }
    }

    @SubscribeEvent
    public static void loadEntityShader(RegisterEntitySpectatorShadersEvent event) {
        event.register(GEntityTypes.SPECTRE.get(), Galosphere.id("shaders/post/spectre.json"));
        event.register(GEntityTypes.SPECTATOR_VISION.get(), Galosphere.id("shaders/post/spectre.json"));
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        HorseRenderer horseRenderer = (HorseRenderer)event.getRenderer(EntityType.HORSE);
        Set set = event.getSkins();
        List<EntityType> mobs = event.getEntityTypes().stream().map(entityType -> entityType).toList();
        mobs.forEach(entityType -> {
            EntityRenderer renderer = event.getRenderer(entityType);
            if (renderer instanceof MobRenderer) {
                MobRenderer mobRenderer = (MobRenderer)renderer;
                mobRenderer.addLayer(new SaltStatueLayer(mobRenderer));
            }
        });
        if (horseRenderer == null) {
            return;
        }
        horseRenderer.addLayer(new HorseBannerLayer(horseRenderer));
        set.forEach(skin -> {
            PlayerRenderer playerRenderer = (PlayerRenderer)event.getSkin(skin);
            if (playerRenderer == null) {
                return;
            }
            playerRenderer.addLayer(new BannerLayer(playerRenderer));
        });
    }

    @SubscribeEvent
    public static void registerEntityLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(GModelLayers.SPARKLE, SparkleModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.SPECTRE, SpectreModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.SPECTERPILLAR, SpecterpillarModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.BERSERKER, BerserkerModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.STERLING_HELMET, SterlingArmorModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.GILDED_BEADS, GildedBeadsRenderer::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.PINK_SALT_PILLAR, PinkSaltPillarModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.PRESERVED, PreservedModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.MOLE, MoleModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.ROPE_DART, RopeDartModel::createBodyLayer);
        event.registerLayerDefinition(GModelLayers.WEAPON_RACK, WeaponRackModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(GEntityTypes.SPARKLE.get(), SparkleRenderer::new);
        event.registerEntityRenderer(GEntityTypes.PALLADIUM_BOMB.get(), context -> new ThrownItemRenderer(context, 1.5f, false));
        event.registerEntityRenderer(GEntityTypes.SPECTRE.get(), SpectreRenderer::new);
        event.registerEntityRenderer(GEntityTypes.GLOW_FLARE.get(), ThrowableLaunchedProjectileRenderer::new);
        event.registerEntityRenderer(GEntityTypes.SPECTRE_FLARE.get(), ThrowableLaunchedProjectileRenderer::new);
        event.registerEntityRenderer(GEntityTypes.SPECTERPILLAR.get(), SpecterpillarRenderer::new);
        event.registerEntityRenderer(GEntityTypes.SPECTATOR_VISION.get(), SpectatorVisionRenderer::new);
        event.registerEntityRenderer(GEntityTypes.BERSERKER.get(), BerserkerRenderer::new);
        event.registerEntityRenderer(GEntityTypes.PRESERVED.get(), PreservedRenderer::new);
        event.registerEntityRenderer(GEntityTypes.PINK_SALT_PILLAR.get(), PinkSaltPillarRenderer::new);
        event.registerEntityRenderer(GEntityTypes.PINK_SALT_SHARD.get(), PinkSaltShardRenderer::new);
        event.registerEntityRenderer(GEntityTypes.ROPE_DART.get(), RopeDartProjectileRenderer::new);
        event.registerEntityRenderer(GEntityTypes.MOLE.get(), MoleRenderer::new);
        event.registerEntityRenderer(GEntityTypes.WEAPON_RACK.get(), WeaponRackRenderer::new);
        event.registerBlockEntityRenderer(GBlockEntityTypes.SHADOW_FRAME.get(), ShadowFrameBlockRenderer::new);
        event.registerBlockEntityRenderer(GBlockEntityTypes.GILDED_BEADS.get(), GildedBeadsRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)GParticleTypes.PALLADIUM_BOMB.get(), (ParticleProvider)new PalladiumBombParticleProvider());
        event.registerSpriteSet((ParticleType)GParticleTypes.ALLURITE_RAIN.get(), CrystalRainParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.LUMIERE_RAIN.get(), CrystalRainParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.AMETHYST_RAIN.get(), CrystalRainParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.MONSTROMETER_INDICATOR.get(), IndicatorParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.SPECTATE_ORB.get(), SpectateOrbParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.PINK_SALT_FALLING_DUST.get(), PinkSaltFallingDustProvider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.BERSERKER_SLAM_SHOCKWAVE.get(), BerserkerSlamShockwave.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.HOVERING_ASH.get(), HoveringAshParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.ECHO_TRAIL.get(), SpectateOrbParticle.Provider::new);
        event.registerSpriteSet((ParticleType)GParticleTypes.OPAL_GLINT.get(), SuspendedTownParticle.HappyVillagerProvider::new);
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(GMenuTypes.COMBUSTION_TABLE.get(), CombustionTableScreen::new);
    }

    static {
        distance = 24.0f;
    }
}

